/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.data.source;

import oracle.olapi.data.source.CursorInfoSpecification;
import oracle.olapi.data.source.CursorSpecificationVisitor;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.transaction.Transaction;

public abstract class CursorSpecification
implements CursorInfoSpecification {
    private SourceDefinition _sourceDefinition;
    private boolean _extentCalculationSpecified;
    private boolean _parentStartCalculationSpecified;
    private boolean _parentEndCalculationSpecified;
    private int _defaultFetchSize;
    private Transaction _transaction = null;

    CursorSpecification(SourceDefinition sourceDefinition) {
        this._sourceDefinition = sourceDefinition;
        this._extentCalculationSpecified = true;
        this._parentStartCalculationSpecified = false;
        this._parentEndCalculationSpecified = false;
        this._defaultFetchSize = -1;
    }

    public final Transaction getTransaction() {
        return this._transaction;
    }

    public final void setTransaction(Transaction transaction) {
        this._transaction = transaction;
    }

    final SourceDefinition _getSourceDefinition() {
        return this._sourceDefinition;
    }

    final void _setDefaultFetchSize(int n) {
        this._defaultFetchSize = n;
    }

    public abstract Object acceptVisitor(CursorSpecificationVisitor var1, Object var2);

    public final int getDefaultFetchSize() {
        return this._defaultFetchSize;
    }

    public final Source getSource() {
        return this._sourceDefinition.getSource();
    }

    abstract boolean isExpired(SourceDefinition var1, Transaction var2);

    public final boolean isExtentCalculationSpecified() {
        return this._extentCalculationSpecified;
    }

    public final boolean isParentEndCalculationSpecified() {
        return this._parentEndCalculationSpecified;
    }

    public final boolean isParentStartCalculationSpecified() {
        return this._parentStartCalculationSpecified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setDefaultFetchSize(int n) throws IllegalArgumentException {
        CursorSpecification cursorSpecification = this;
        synchronized (cursorSpecification) {
            if (n <= 0) {
                throw new IllegalArgumentException();
            }
            if (this._defaultFetchSize == -1) {
                throw new IllegalStateException();
            }
            this._setDefaultFetchSize(n);
        }
    }

    public final void setExtentCalculationSpecified(boolean bl) {
        this._extentCalculationSpecified = bl;
    }

    public final void setParentEndCalculationSpecified(boolean bl) {
        this._parentEndCalculationSpecified = bl;
    }

    public final void setParentStartCalculationSpecified(boolean bl) {
        this._parentStartCalculationSpecified = bl;
    }
}

