/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.replay;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.express.mdm.MdmMetadataProvider;
import oracle.express.mdm.MdmSource;
import oracle.express.olapi.replay.DataProviderRequestException;
import oracle.express.olapi.replay.MethodExecutor;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.FundamentalMetadataProvider;
import oracle.olapi.data.source.Source;

class Providers {
    private ProviderLookup _providers = new ProviderLookup();
    private DataProvider _dp = null;
    private FundamentalMetadataProvider _fmdp = null;

    Providers() {
    }

    void addMetadataProvider(MdmMetadataProvider mdmMetadataProvider) {
        this._providers.put(mdmMetadataProvider);
        if (this._dp == null) {
            this._dp = mdmMetadataProvider.getDataProvider();
        }
        if (this._fmdp == null) {
            this._fmdp = this._dp.getFundamentalMetadataProvider();
        }
    }

    MdmMetadataProvider getMetadataProvider(String string) {
        return this._providers.get(string);
    }

    DataProvider getDataProvider() {
        return this._dp;
    }

    FundamentalMetadataProvider getFundamentalMetadataProvider() {
        return this._fmdp;
    }

    Source getSourceByName(String string, String string2) {
        try {
            MdmMetadataProvider mdmMetadataProvider = this.getMetadataProvider(string);
            MdmSource mdmSource = (MdmSource)mdmMetadataProvider.getMetadataObject(string2);
            return mdmSource.getSource();
        }
        catch (Exception exception) {
            return null;
        }
    }

    Object create(String string, Object[] objectArray) throws DataProviderRequestException {
        try {
            Object object = MethodExecutor.invoke(this._dp, string, objectArray);
            return object;
        }
        catch (Exception exception) {
            throw new DataProviderRequestException(this.getClass(), string);
        }
    }

    public Object create(String string) throws DataProviderRequestException {
        return this.create(string, new Object[0]);
    }

    public Object create(String string, Object object) throws DataProviderRequestException {
        return this.create(string, new Object[]{object});
    }

    public Object create(String string, Object object, Object object2) throws DataProviderRequestException {
        return this.create(string, new Object[]{object, object2});
    }

    class ProviderLookup {
        private Hashtable lookup = new Hashtable();

        public MdmMetadataProvider get(String string) {
            return (MdmMetadataProvider)this.lookup.get(string);
        }

        public void put(MdmMetadataProvider mdmMetadataProvider) {
            this.lookup.put(mdmMetadataProvider.getID(), mdmMetadataProvider);
        }

        public Enumeration elements() {
            return this.lookup.elements();
        }
    }
}

