/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.replay;

import java.lang.reflect.Constructor;
import oracle.express.olapi.replay.DefinitionHandler;
import oracle.express.olapi.replay.ElementFactory;
import oracle.express.olapi.replay.InvalidSourceNodeException;
import oracle.express.olapi.replay.NestedNodeContextException;
import oracle.express.olapi.replay.NodeContext;
import oracle.express.olapi.replay.Providers;
import oracle.express.olapi.replay.SourceCache;
import oracle.express.olapi.replay.SourceHandler;
import oracle.express.olapi.replay.SourceNodeNotFoundException;
import oracle.express.olapi.replay.XMLNodeHandler;
import oracle.olapi.data.source.FundamentalMetadataProvider;
import oracle.olapi.data.source.Source;

class BaseElementFactory
extends ElementFactory {
    private SourceCache cache = new SourceCache();
    static /* synthetic */ Class class$java$lang$String;

    BaseElementFactory(Providers providers) {
        super(providers);
    }

    protected XMLNodeHandler initHandlers() {
        SourceHandler sourceHandler = null;
        sourceHandler = new RefHandler(sourceHandler);
        sourceHandler = new DefinitionHandler(sourceHandler, this.getProviders(), this.cache);
        sourceHandler = new EmptySourceHandler(sourceHandler);
        sourceHandler = new VoidSourceHandler(sourceHandler);
        sourceHandler = new FundamentalHandler(sourceHandler);
        sourceHandler = new DataHandler(sourceHandler);
        return sourceHandler;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class DataHandler
    extends SourceHandler {
        public DataHandler(XMLNodeHandler xMLNodeHandler) {
            super(xMLNodeHandler);
        }

        protected String getType() {
            return "Data";
        }

        protected Object doHandle(NodeContext nodeContext) throws InvalidSourceNodeException {
            try {
                String string = nodeContext.getAttributeByName("class");
                Class<?> clazz = Class.forName(string);
                Constructor<?> constructor = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = BaseElementFactory.class$("java.lang.String")) : class$java$lang$String);
                String string2 = nodeContext.getText();
                Object obj = constructor.newInstance(string2);
                return obj;
            }
            catch (Exception exception) {
                throw new InvalidSourceNodeException(this.getClass(), nodeContext, exception);
            }
        }
    }

    private class FundamentalHandler
    extends SourceHandler {
        private FundamentalMetadataProvider fmdp = null;

        public FundamentalHandler(XMLNodeHandler xMLNodeHandler) {
            super(xMLNodeHandler);
            this.fmdp = BaseElementFactory.this.getProviders().getFundamentalMetadataProvider();
        }

        protected String getType() {
            return "Fundamental";
        }

        protected Object doHandle(NodeContext nodeContext) throws SourceNodeNotFoundException {
            Source source = null;
            String string = nodeContext.find("FundamentalType").getText() + "!" + nodeContext.find("FundamentalName").getText();
            source = this.fmdp.getMetadataObject(string).getSource();
            return source;
        }
    }

    private class VoidSourceHandler
    extends SourceHandler {
        private Source voidSource = null;

        public VoidSourceHandler(XMLNodeHandler xMLNodeHandler) {
            super(xMLNodeHandler);
            this.voidSource = BaseElementFactory.this.getProviders().getFundamentalMetadataProvider().getVoidDataType().getSource();
        }

        protected String getType() {
            return "Voidsource";
        }

        protected Object doHandle(NodeContext nodeContext) {
            return this.voidSource;
        }
    }

    private class EmptySourceHandler
    extends SourceHandler {
        private Source emptySource = null;

        public EmptySourceHandler(XMLNodeHandler xMLNodeHandler) {
            super(xMLNodeHandler);
            this.emptySource = BaseElementFactory.this.getProviders().getFundamentalMetadataProvider().getEmptyDataType().getSource();
        }

        protected String getType() {
            return "Emptysource";
        }

        protected Object doHandle(NodeContext nodeContext) {
            return this.emptySource;
        }
    }

    class RefHandler
    extends SourceHandler {
        public RefHandler(XMLNodeHandler xMLNodeHandler) {
            super(xMLNodeHandler);
        }

        protected String getType() {
            return "Ref";
        }

        public Object doHandle(NodeContext nodeContext) throws NestedNodeContextException {
            Object object = null;
            object = BaseElementFactory.this.cache.get(nodeContext.getID());
            if (object == null) {
                object = nodeContext.findDefinition().create();
            }
            return object;
        }
    }
}

