/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data.full;

import oracle.express.ExpressServerException;
import oracle.express.ObjectClosedException;
import oracle.express.TaskInterruptedException;
import oracle.express.UnexpectedException;
import oracle.express.idl.ExpressModule.ExpressException;
import oracle.express.idl.ExpressModule.RemoteObjectClosedException;
import oracle.express.idl.ExpressModule.RemoteTaskInterruptedException;
import oracle.express.idl.ExpressOlapiDataCursorModule.CursorBlock2Struct;
import oracle.express.idl.ExpressOlapiDataCursorModule.CursorBlockStruct;
import oracle.express.idl.ExpressOlapiDataCursorModule.CursorManagerInterface;
import oracle.express.idl.ExpressOlapiDataCursorModule.CursorValue2Union;
import oracle.express.idl.ExpressOlapiDataCursorModule.CursorValueUnion;
import oracle.express.idl.ExpressOlapiDataCursorModule.InvalidIndexSpecificationException;
import oracle.express.idl.ExpressOlapiDataCursorModule.RemoteSpecificationUpdateNeededException;
import oracle.express.idl.util.InterfaceStub;
import oracle.express.olapi.data.CursorBlock;
import oracle.express.olapi.data.CursorBlockFetcher;
import oracle.express.olapi.data.CursorTreeManager;
import oracle.express.olapi.data.full.DataCursorManager;
import oracle.olapi.data.cursor.PositionOutOfBoundsException;
import oracle.olapi.data.cursor.SpecificationUpdateNeededException;
import oracle.olapi.data.source.Parameter;
import org.omg.CORBA.NO_IMPLEMENT;

final class FullCursorBlockFetcher
implements CursorBlockFetcher {
    private DataCursorManager _cursorManager;
    private CursorManagerInterface _cursorManagerInterface;
    private boolean _closed;

    public FullCursorBlockFetcher(DataCursorManager dataCursorManager, CursorManagerInterface cursorManagerInterface) {
        this._cursorManager = dataCursorManager;
        this._cursorManagerInterface = cursorManagerInterface;
        this._closed = false;
    }

    public final CursorBlock fetchCursorBlock(long[] lArray, int[] nArray, Parameter[] parameterArray, CursorTreeManager cursorTreeManager) {
        try {
            if (((InterfaceStub)((Object)this._getCursorManagerInterface())).isPostServerVsnnum("10.2.0.0.0")) {
                CursorValue2Union[] cursorValue2UnionArray = CursorTreeManager.getParameterValues2(cursorTreeManager, parameterArray);
                CursorBlock2Struct cursorBlock2Struct = this._getCursorManagerInterface().fetch2Blocks(nArray, lArray, cursorValue2UnionArray);
                return new CursorBlock(cursorBlock2Struct, cursorValue2UnionArray);
            }
            CursorValueUnion[] cursorValueUnionArray = CursorTreeManager.getParameterValues(cursorTreeManager, parameterArray);
            CursorBlockStruct cursorBlockStruct = this._getCursorManagerInterface().fetchBlocks(nArray, lArray, cursorValueUnionArray);
            return new CursorBlock(cursorBlockStruct, cursorValueUnionArray);
        }
        catch (RemoteSpecificationUpdateNeededException remoteSpecificationUpdateNeededException) {
            throw new UnexpectedException(remoteSpecificationUpdateNeededException.toString());
        }
        catch (ExpressException expressException) {
            throw new ExpressServerException(expressException);
        }
        catch (RemoteObjectClosedException remoteObjectClosedException) {
            this._closed();
            throw new ObjectClosedException(remoteObjectClosedException.toString());
        }
        catch (RemoteTaskInterruptedException remoteTaskInterruptedException) {
            throw new TaskInterruptedException(remoteTaskInterruptedException.toString());
        }
        catch (InvalidIndexSpecificationException invalidIndexSpecificationException) {
            throw new PositionOutOfBoundsException();
        }
        catch (NO_IMPLEMENT nO_IMPLEMENT) {
            this._closed();
            throw new ObjectClosedException(nO_IMPLEMENT.toString());
        }
    }

    public final CursorBlock fetchAnyCursorBlock(Parameter[] parameterArray) {
        return this.fetchAnyCursorBlock(parameterArray, null);
    }

    public final CursorBlock fetchAnyCursorBlock(Parameter[] parameterArray, CursorTreeManager cursorTreeManager) {
        try {
            if (((InterfaceStub)((Object)this._getCursorManagerInterface())).isPostServerVsnnum("10.2.0.0.0")) {
                CursorValue2Union[] cursorValue2UnionArray = CursorTreeManager.getParameterValues2(cursorTreeManager, parameterArray);
                CursorBlock2Struct cursorBlock2Struct = this._getCursorManagerInterface().fetch2InitialBlocks(cursorValue2UnionArray);
                return new CursorBlock(cursorBlock2Struct, cursorValue2UnionArray);
            }
            CursorValueUnion[] cursorValueUnionArray = CursorTreeManager.getParameterValues(cursorTreeManager, parameterArray);
            CursorBlockStruct cursorBlockStruct = this._getCursorManagerInterface().fetchInitialBlocks(cursorValueUnionArray);
            return new CursorBlock(cursorBlockStruct, cursorValueUnionArray);
        }
        catch (RemoteSpecificationUpdateNeededException remoteSpecificationUpdateNeededException) {
            throw new SpecificationUpdateNeededException();
        }
        catch (ExpressException expressException) {
            throw new ExpressServerException(expressException);
        }
        catch (RemoteObjectClosedException remoteObjectClosedException) {
            this._closed();
            throw new ObjectClosedException(remoteObjectClosedException.toString());
        }
        catch (RemoteTaskInterruptedException remoteTaskInterruptedException) {
            throw new TaskInterruptedException(remoteTaskInterruptedException.toString());
        }
        catch (NO_IMPLEMENT nO_IMPLEMENT) {
            this._closed();
            throw new ObjectClosedException(nO_IMPLEMENT.toString());
        }
    }

    public void close() {
        this._closed = true;
    }

    private void _closed() {
        this._cursorManager._closed();
    }

    private CursorManagerInterface _getCursorManagerInterface() throws ObjectClosedException {
        if (this._closed) {
            throw new ObjectClosedException();
        }
        return this._cursorManagerInterface;
    }
}

