/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data.full;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import oracle.express.ExpressServerException;
import oracle.express.ObjectClosedException;
import oracle.express.TaskInterruptedException;
import oracle.express.connection.ConnectionParameterInfo;
import oracle.express.connection.InvalidVersionConnectionFailureException;
import oracle.express.idl.ExpressConnectionModule.ConnectionInterface;
import oracle.express.idl.ExpressConnectionModule.ConnectionParameterTypeEnum;
import oracle.express.idl.ExpressConnectionModule.DatabaseInterface;
import oracle.express.idl.ExpressConnectionModule.PropertyStruct;
import oracle.express.idl.ExpressConnectionModule.RemoteAPIVersionMismatchException;
import oracle.express.idl.ExpressConnectionModule.RemoteAuthenticationException;
import oracle.express.idl.ExpressConnectionModule.ServerInterface;
import oracle.express.idl.ExpressConnectionModule.ServerInterfaceStub;
import oracle.express.idl.ExpressConnectionModule.VersionInfoStruct;
import oracle.express.idl.ExpressMdmModule.MetadataProviderInterface;
import oracle.express.idl.ExpressMdmModule.MetadataProviderInterfaceHelper;
import oracle.express.idl.ExpressModule.ExpressException;
import oracle.express.idl.ExpressModule.RemoteObjectClosedException;
import oracle.express.idl.ExpressModule.RemoteTaskInterruptedException;
import oracle.express.idl.ExpressOlapiDataSourceModule.DataProviderInterface;
import oracle.express.idl.ExpressOlapiDataSourceModule.DataProviderInterfaceHelper;
import oracle.express.idl.ExpressOlapiDataSourceModule.DefinitionManagerInterface;
import oracle.express.idl.ExpressOlapiDataSourceModule.DefinitionUnion;
import oracle.express.idl.ExpressOlapiDataSourceModule.UnmatchedInputsException;
import oracle.express.idl.util.InterfaceStub;
import oracle.express.idl.util.OlapiException;
import oracle.express.idl.util.OlapiTracer;
import oracle.express.idl.util.RpcProperties;
import oracle.express.idl.util.StringHolder;
import oracle.express.idl.util.TypeMapHelper;
import oracle.express.mdm.MdmMetadataProvider;
import oracle.express.olapi.data.full.BaseCursorManager;
import oracle.express.olapi.data.full.CursorInputTemplate;
import oracle.express.olapi.data.full.DefinitionManager;
import oracle.express.olapi.data.full.DefinitionManagerPrior9202;
import oracle.express.olapi.data.full.DefinitionManagerSince9202;
import oracle.express.olapi.data.full.ExpressFundamentalIdProvider;
import oracle.express.olapi.data.full.ExpressGenerationInfoListener;
import oracle.express.olapi.data.full.ExpressSpecifiedCursorManager;
import oracle.express.olapi.data.full.UnknownServerVersionException;
import oracle.express.olapi.replay.ExceptionDefinitionWriter;
import oracle.express.olapi.transaction.ExpressDataReadTransaction;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.olapi.UnsupportedOperationException;
import oracle.olapi.data.cursor.CursorManager;
import oracle.olapi.data.cursor.SourceType;
import oracle.olapi.data.source.CursorInfoSpecification;
import oracle.olapi.data.source.CursorManagerSpecification;
import oracle.olapi.data.source.CursorManagerSpecificationExpiredException;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.DataProviderMismatchException;
import oracle.olapi.data.source.SQLCursorManager;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.SpecifiedCursorManager;
import oracle.olapi.metadata.MetadataProvider;
import oracle.olapi.metadata.XMLFileFetcher;
import oracle.olapi.transaction.Transaction;
import oracle.olapi.transaction.TransactionProvider;
import oracle.olapi.transaction.TransactionalObjectInvalidException;
import oracle.olapi.version.Version;
import oracle.sql.NUMBER;

public class ExpressDataProvider
extends DataProvider {
    private static String MDM_COMPATIBILITY_MODE = "MdmCompatibilityMode";
    private static String XML_METADATA_FILE = "XMLMetadataFile";
    private static String METADATA_READER_MODE = "MetadataReaderMode";
    private static String AW_ONLY = "10103AWONLY";
    private static String AW_OWNER = "AWOwner";
    private static String AW_NAME = "AWName";
    public static final String CURSOR_BLOCK_CACHE_SIZE = "CursorBlockCacheSize";
    private DataProviderInterface _dataProviderInterface;
    private List _openDefinitionManagers;
    private ExceptionDefinitionWriter exceptionWriter = null;
    private OracleConnection _jdbc_connection;
    private Properties _props;
    private ConnectionInterface _connectionInterface;
    private Version _serverVersion;
    private MetadataProvider _defaultMetadataProvider = null;
    private MetadataProviderInterface _metadataProviderInterface = null;
    private Locale _locale;
    static HashMap _serverInterfaceMap = new HashMap();
    private ExpressGenerationInfoListener _generationInfoListener = null;

    public ExpressDataProvider(OracleConnection oracleConnection, TransactionProvider transactionProvider) {
        super(transactionProvider, new ExpressFundamentalIdProvider());
        this._jdbc_connection = oracleConnection;
        this._locale = Locale.getDefault();
        this._openDefinitionManagers = new ArrayList();
        this._props = new Properties();
        OlapiTracer.init();
    }

    public ExpressDataProvider(OracleConnection oracleConnection, TransactionProvider transactionProvider, Locale locale) {
        super(transactionProvider, new ExpressFundamentalIdProvider());
        this._jdbc_connection = oracleConnection;
        this._locale = locale;
        this._openDefinitionManagers = new ArrayList();
        this._props = new Properties();
        OlapiTracer.init();
    }

    public ExpressDataProvider(OracleConnection oracleConnection, TransactionProvider transactionProvider, Properties properties) {
        super(transactionProvider, new ExpressFundamentalIdProvider());
        this._jdbc_connection = oracleConnection;
        this._locale = Locale.getDefault();
        this._openDefinitionManagers = new ArrayList();
        this._props = properties;
        OlapiTracer.init();
    }

    public ExpressDataProvider(OracleConnection oracleConnection, TransactionProvider transactionProvider, Locale locale, Properties properties) {
        super(transactionProvider, new ExpressFundamentalIdProvider());
        this._jdbc_connection = oracleConnection;
        this._locale = locale;
        this._openDefinitionManagers = new ArrayList();
        this._props = properties;
        OlapiTracer.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws SQLException {
        NUMBER nUMBER;
        if (null == this._jdbc_connection) {
            throw new OlapiException("BOOT_FAIL", "data provider initialization failed because jdbc connection is null");
        }
        boolean bl = false;
        try {
            if (!this._jdbc_connection.isClosed()) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            throw new OlapiException("BOOT_FAIL", "data provider initialization failed because jdbc connection is not open");
        }
        ServerInterfaceStub serverInterfaceStub = null;
        long l = 0L;
        String string = null;
        String string2 = System.getProperty("selectedAW");
        if (null != string2) {
            if (null == this._props.get(METADATA_READER_MODE)) {
                this._props.put(METADATA_READER_MODE, AW_ONLY);
            }
            if (null == this._props.get(AW_OWNER) && null == this._props.get(AW_NAME)) {
                nUMBER = string2.split("\\.");
                this._props.put("AWOwner", nUMBER[0]);
                this._props.put("AWName", nUMBER[1]);
            }
        }
        TypeMapHelper.setTypeMap(this._jdbc_connection);
        if (_serverInterfaceMap.get(this._jdbc_connection) == null) {
            nUMBER = null;
            String string3 = null;
            OracleCallableStatement oracleCallableStatement = null;
            boolean bl2 = false;
            try {
                oracleCallableStatement = (OracleCallableStatement)this._jdbc_connection.prepareCall("{ ? = call OlapiBootstrap2(?, ?, ?) }");
                oracleCallableStatement.registerOutParameter(1, 2);
                oracleCallableStatement.setString(2, "10.2.0.3.0");
                oracleCallableStatement.registerOutParameter(3, 1);
                oracleCallableStatement.registerOutParameter(4, 1);
                oracleCallableStatement.execute();
                nUMBER = oracleCallableStatement.getNUMBER(1);
                string3 = oracleCallableStatement.getString(3);
                string = "ORAOLAP" + oracleCallableStatement.getString(4);
            }
            catch (Exception exception) {
                bl2 = true;
            }
            finally {
                if (null != oracleCallableStatement) {
                    oracleCallableStatement.close();
                }
            }
            if (bl2) {
                try {
                    oracleCallableStatement = (OracleCallableStatement)this._jdbc_connection.prepareCall("{ ? = call OlapiBootstrap(?) }");
                    oracleCallableStatement.registerOutParameter(1, 2);
                    oracleCallableStatement.registerOutParameter(2, 1);
                    oracleCallableStatement.execute();
                    nUMBER = oracleCallableStatement.getNUMBER(1);
                    string3 = oracleCallableStatement.getString(2);
                }
                catch (Exception exception) {
                    throw (SQLException)exception;
                }
                finally {
                    if (null != oracleCallableStatement) {
                        oracleCallableStatement.close();
                    }
                }
                try {
                    oracleCallableStatement = (OracleCallableStatement)this._jdbc_connection.prepareCall("{ ? = call OlapiHandshake(?) }");
                    oracleCallableStatement.registerOutParameter(1, -5);
                    oracleCallableStatement.registerOutParameter(2, 1);
                    oracleCallableStatement.execute();
                    l = oracleCallableStatement.getLong(1);
                    string = "ORAOLAP" + oracleCallableStatement.getString(2);
                }
                catch (Exception exception) {
                    string = "ORAOLAP9.2.0.1.0";
                }
                finally {
                    if (null != oracleCallableStatement) {
                        oracleCallableStatement.close();
                    }
                }
            }
            if (null == nUMBER || nUMBER.isZero() || null == string3) {
                throw new OlapiException("BOOT_FAIL", "olapi bootstrap failure");
            }
            serverInterfaceStub = new ServerInterfaceStub(this._jdbc_connection, string, nUMBER, string3, new RpcProperties(this._props));
            _serverInterfaceMap.put(this._jdbc_connection, serverInterfaceStub);
        }
        this.connect();
    }

    public boolean isServerVersionLaterThan(int[] nArray) {
        return this.getServerVersion().isSameOrLaterThan(nArray);
    }

    public Version getServerVersion() {
        if (null == this._serverVersion) {
            this.initializeServerVersion();
        }
        return this._serverVersion.getClientCompatibleVersion();
    }

    public final int[] getOraolapServerVersionArray() {
        return this.getServerVersion().getVersionArray();
    }

    private final synchronized void initializeServerVersion() {
        if (null != this._serverVersion) {
            return;
        }
        MetadataProviderInterface metadataProviderInterface = this.getMetadataProviderInterface();
        InterfaceStub interfaceStub = (InterfaceStub)((Object)metadataProviderInterface);
        String string = interfaceStub.getServerVsnnum();
        try {
            StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
            streamTokenizer.resetSyntax();
            streamTokenizer.wordChars(97, 122);
            streamTokenizer.wordChars(65, 90);
            int n = streamTokenizer.nextToken();
            streamTokenizer.resetSyntax();
            streamTokenizer.wordChars(48, 57);
            streamTokenizer.whitespaceChars(46, 46);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            n = streamTokenizer.nextToken();
            while (n != -1) {
                switch (n) {
                    case -3: {
                        arrayList.add(new Integer(streamTokenizer.sval));
                        break;
                    }
                    default: {
                        arrayList.add(new Integer(n));
                    }
                }
                n = streamTokenizer.nextToken();
            }
            int[] nArray = new int[arrayList.size()];
            for (int i = 0; i < nArray.length; ++i) {
                Integer n2 = (Integer)arrayList.get(i);
                nArray[i] = n2;
            }
            this._serverVersion = new Version(nArray);
        }
        catch (IOException iOException) {
            throw new UnknownServerVersionException(string);
        }
    }

    private void connect() {
        try {
            this._props.put(ConnectionParameterTypeEnum.VERSION.toString(), this.getClientVersion());
            this._props.put("OraOlapVersion", Version.getClientVersion().getVersionString());
            InterfaceStub interfaceStub = (InterfaceStub)((Object)this.getServerInterface(this._jdbc_connection));
            this._props.put("RpcCompression", new Long(interfaceStub.getRpcProperties().getRpcCompression()).toString());
            PropertyStruct[] propertyStructArray = ConnectionParameterInfo._propertiesToPropertySequence(this._props);
            StringHolder stringHolder = new StringHolder();
            try {
                this._connectionInterface = this.getServerInterface(this._jdbc_connection).connect(ExpressDataProvider._getHostName(), this._locale.getLanguage(), this._locale.getCountry(), this._locale.getVariant(), propertyStructArray, stringHolder);
            }
            catch (ExpressException expressException) {
                throw new ExpressServerException(expressException);
            }
            catch (UnknownHostException unknownHostException) {
            }
            catch (RemoteAPIVersionMismatchException remoteAPIVersionMismatchException) {
                throw new InvalidVersionConnectionFailureException();
            }
            catch (RemoteAuthenticationException remoteAuthenticationException) {
            }
            catch (RemoteTaskInterruptedException remoteTaskInterruptedException) {
                throw new TaskInterruptedException(remoteTaskInterruptedException.toString());
            }
        }
        catch (InvalidVersionConnectionFailureException invalidVersionConnectionFailureException) {
            // empty catch block
        }
    }

    private void _checkVersion() throws InvalidVersionConnectionFailureException {
        VersionInfoStruct versionInfoStruct = null;
        try {
            versionInfoStruct = this.getServerInterface(this._jdbc_connection).getVersionInfo();
        }
        catch (ExpressException expressException) {
            throw new ExpressServerException(expressException);
        }
        if (versionInfoStruct.majorVersion != 9 || versionInfoStruct.minorVersion < 2) {
            throw new InvalidVersionConnectionFailureException();
        }
    }

    private String getClientVersion() {
        StringBuffer stringBuffer = new StringBuffer();
        this.getServerInterface(this._jdbc_connection);
        StringBuffer stringBuffer2 = stringBuffer.append(9).append(".");
        this.getServerInterface(this._jdbc_connection);
        String string = stringBuffer2.append(2).toString();
        return string;
    }

    private static String _getHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }

    private DataProviderInterface _getDataProviderInterface() throws ObjectClosedException {
        if (!this.isOpen()) {
            throw new ObjectClosedException();
        }
        if (this._dataProviderInterface == null) {
            this._dataProviderInterface = DataProviderInterfaceHelper.narrow(this._connectionInterface);
        }
        return this._dataProviderInterface;
    }

    private ServerInterface getServerInterface(OracleConnection oracleConnection) {
        return (ServerInterface)_serverInterfaceMap.get(oracleConnection);
    }

    public OracleConnection getConnection() {
        return this._jdbc_connection;
    }

    public ConnectionInterface getConnectionInterface() {
        return this._connectionInterface;
    }

    public CursorManager[] createCursorManagers(Source[] sourceArray, int[] nArray, CursorInfoSpecification[] cursorInfoSpecificationArray, Properties properties) {
        return this.createCursorManagers(sourceArray, nArray, cursorInfoSpecificationArray, properties, 0L);
    }

    public final CursorManager[] createCursorManagers(Source[] sourceArray, int[] nArray, CursorInfoSpecification[] cursorInfoSpecificationArray, long l) {
        return this.createCursorManagers(sourceArray, nArray, cursorInfoSpecificationArray, null, l);
    }

    public final CursorManager[] createCursorManagers(Source[] sourceArray, int[] nArray, CursorInfoSpecification[] cursorInfoSpecificationArray, Properties properties, long l) {
        if (!this.isServerVersionLaterThan(new int[]{10, 0, 0, 0, 0})) {
            throw new UnsupportedOperationException();
        }
        long l2 = l;
        ExpressGenerationInfoListener expressGenerationInfoListener = this.getGenerationInfoListener();
        if (null != expressGenerationInfoListener) {
            l2 |= expressGenerationInfoListener.getGenerationInfoTypeForCreateCursorManager();
        }
        CursorManager[] cursorManagerArray = null;
        try {
            if (sourceArray[0].getDataProvider() != this) {
                throw new DataProviderMismatchException();
            }
            if (cursorInfoSpecificationArray[0].getTransaction() != this.getTransactionProvider().getCurrentTransactionForDataRead()) {
                throw new TransactionalObjectInvalidException();
            }
            DefinitionManagerSince9202 definitionManagerSince9202 = this.getCurrentDefinitionManagerSince9202();
            cursorManagerArray = definitionManagerSince9202.createCursorManagers(sourceArray, nArray, cursorInfoSpecificationArray, l2, properties);
        }
        catch (RuntimeException runtimeException) {
            ExceptionDefinitionWriter.dispatch(sourceArray[0], runtimeException);
            throw runtimeException;
        }
        if (null != expressGenerationInfoListener) {
            for (int i = 0; i < sourceArray.length; ++i) {
                expressGenerationInfoListener.notifyOfCreateCursorManager((BaseCursorManager)((Object)cursorManagerArray[i]));
            }
        }
        return cursorManagerArray;
    }

    public final SpecifiedCursorManager createCursorManager(CursorManagerSpecification cursorManagerSpecification, Source[] sourceArray, Properties properties) throws CursorManagerSpecificationExpiredException, DataProviderMismatchException, ExpressServerException, ObjectClosedException, TransactionalObjectInvalidException {
        return this.internalCreateCursorManager(cursorManagerSpecification, sourceArray, properties, 0L);
    }

    public final SpecifiedCursorManager createCursorManager(CursorManagerSpecification cursorManagerSpecification, Source[] sourceArray, long l) throws CursorManagerSpecificationExpiredException, DataProviderMismatchException, ExpressServerException, ObjectClosedException, TransactionalObjectInvalidException {
        return this.internalCreateCursorManager(cursorManagerSpecification, sourceArray, null, l);
    }

    private SpecifiedCursorManager internalCreateCursorManager(CursorManagerSpecification cursorManagerSpecification, Source[] sourceArray, Properties properties, long l) throws CursorManagerSpecificationExpiredException, DataProviderMismatchException, ExpressServerException, ObjectClosedException, TransactionalObjectInvalidException {
        Source[] sourceArray2 = sourceArray;
        if (null == sourceArray2) {
            sourceArray2 = new Source[]{};
        }
        if (this.isServerVersionLaterThan(new int[]{9, 2, 0, 4, 0})) {
            CursorManagerSpecification[] cursorManagerSpecificationArray = new CursorManagerSpecification[]{cursorManagerSpecification};
            Source[][] sourceArray3 = new Source[][]{sourceArray};
            SpecifiedCursorManager[] specifiedCursorManagerArray = this.createCursorManagers(cursorManagerSpecificationArray, sourceArray3, properties, l);
            return specifiedCursorManagerArray[0];
        }
        Source source = cursorManagerSpecification.getRootCursorSpecification().getSource();
        CursorInputTemplate cursorInputTemplate = new CursorInputTemplate(source, sourceArray2, ExpressSpecifiedCursorManager.calculateInputSourceTypes(sourceArray2), this.getTransactionProvider().getCurrentTransactionForDataRead());
        if (!this.isServerVersionLaterThan(new int[]{9, 2, 0, 3, 0})) {
            return this.createCursorManagerPrior9202(cursorManagerSpecification, cursorInputTemplate);
        }
        long l2 = l;
        ExpressGenerationInfoListener expressGenerationInfoListener = this.getGenerationInfoListener();
        if (null != expressGenerationInfoListener) {
            l2 |= expressGenerationInfoListener.getGenerationInfoTypeForCreateCursorManager();
        }
        ExpressSpecifiedCursorManager expressSpecifiedCursorManager = this.createCursorManagerSince9202(cursorManagerSpecification, cursorInputTemplate, l2);
        if (null != expressGenerationInfoListener) {
            expressGenerationInfoListener.notifyOfCreateCursorManager(expressSpecifiedCursorManager);
        }
        return expressSpecifiedCursorManager;
    }

    private SpecifiedCursorManager createCursorManagerPrior9202(CursorManagerSpecification cursorManagerSpecification, CursorInputTemplate cursorInputTemplate) throws CursorManagerSpecificationExpiredException, DataProviderMismatchException, ExpressServerException, ObjectClosedException, TransactionalObjectInvalidException {
        Source source = cursorInputTemplate.getSource();
        try {
            Transaction transaction;
            if (source.getDataProvider() != this) {
                throw new DataProviderMismatchException();
            }
            Transaction transaction2 = cursorManagerSpecification.getTransaction();
            if (!transaction2.equals(transaction = this.getTransactionProvider().getCurrentTransactionForDataRead())) {
                throw new TransactionalObjectInvalidException();
            }
            DefinitionManagerPrior9202 definitionManagerPrior9202 = new DefinitionManagerPrior9202(source, transaction2, this, cursorInputTemplate);
            definitionManagerPrior9202.init();
            return definitionManagerPrior9202.createCursorManager(cursorManagerSpecification, cursorInputTemplate, 0L);
        }
        catch (RuntimeException runtimeException) {
            ExceptionDefinitionWriter.dispatch(source, runtimeException);
            throw runtimeException;
        }
    }

    private ExpressSpecifiedCursorManager createCursorManagerSince9202(CursorManagerSpecification cursorManagerSpecification, CursorInputTemplate cursorInputTemplate, long l) throws CursorManagerSpecificationExpiredException, DataProviderMismatchException, ExpressServerException, ObjectClosedException, TransactionalObjectInvalidException {
        Source source = cursorInputTemplate.getSource();
        try {
            if (source.getDataProvider() != this) {
                throw new DataProviderMismatchException();
            }
            if (cursorManagerSpecification.getTransaction() != this.getTransactionProvider().getCurrentTransactionForDataRead()) {
                throw new TransactionalObjectInvalidException();
            }
            DefinitionManagerSince9202 definitionManagerSince9202 = this.getCurrentDefinitionManagerSince9202();
            return definitionManagerSince9202.createCursorManager(cursorManagerSpecification, cursorInputTemplate, l);
        }
        catch (RuntimeException runtimeException) {
            ExceptionDefinitionWriter.dispatch(source, runtimeException);
            throw runtimeException;
        }
    }

    DefinitionManagerSince9202 getDefinitionManagerForTransaction(ExpressDataReadTransaction expressDataReadTransaction) {
        DefinitionManagerSince9202 definitionManagerSince9202 = (DefinitionManagerSince9202)expressDataReadTransaction.getDefinitionManager();
        if (null == definitionManagerSince9202) {
            definitionManagerSince9202 = new DefinitionManagerSince9202(expressDataReadTransaction, this);
            definitionManagerSince9202.init();
            expressDataReadTransaction.setDefinitionManager(definitionManagerSince9202);
        }
        return definitionManagerSince9202;
    }

    private DefinitionManagerSince9202 getCurrentDefinitionManagerSince9202() throws TransactionalObjectInvalidException {
        Transaction transaction = this.getTransactionProvider().getCurrentTransactionForDataRead();
        ExpressDataReadTransaction expressDataReadTransaction = null;
        try {
            expressDataReadTransaction = (ExpressDataReadTransaction)transaction;
        }
        catch (ClassCastException classCastException) {
            throw new TransactionalObjectInvalidException();
        }
        return this.getDefinitionManagerForTransaction(expressDataReadTransaction);
    }

    boolean areParametersSupported() {
        return this.isServerVersionLaterThan(new int[]{10, 0, 0, 0, 0});
    }

    public final boolean isOpen() {
        boolean bl = false;
        try {
            bl = !this._jdbc_connection.isClosed();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return bl;
    }

    final DefinitionManagerInterface _createDefinitionManagerInterface() {
        try {
            DefinitionManagerInterface definitionManagerInterface = this._getDataProviderInterface().createDfnMgrWithNoArgs();
            return definitionManagerInterface;
        }
        catch (ExpressException expressException) {
            throw new ExpressServerException(expressException);
        }
        catch (UnmatchedInputsException unmatchedInputsException) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < unmatchedInputsException.ids.length; ++i) {
                arrayList.add(unmatchedInputsException.ids[i]);
            }
            throw new oracle.olapi.data.source.UnmatchedInputsException(arrayList);
        }
        catch (RemoteObjectClosedException remoteObjectClosedException) {
            throw new ObjectClosedException(remoteObjectClosedException.toString());
        }
        catch (RemoteTaskInterruptedException remoteTaskInterruptedException) {
            throw new TaskInterruptedException(remoteTaskInterruptedException.toString());
        }
    }

    final DefinitionManagerInterface _createDefinitionManagerInterface(DefinitionUnion[] definitionUnionArray, short[] sArray, SourceType[] sourceTypeArray) {
        try {
            DefinitionManagerInterface definitionManagerInterface = this._getDataProviderInterface().createDefinitionManager(definitionUnionArray, sArray, SourceType.getTypeIdentifiers(sourceTypeArray));
            return definitionManagerInterface;
        }
        catch (ExpressException expressException) {
            throw new ExpressServerException(expressException);
        }
        catch (UnmatchedInputsException unmatchedInputsException) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < unmatchedInputsException.ids.length; ++i) {
                arrayList.add(unmatchedInputsException.ids[i]);
            }
            throw new oracle.olapi.data.source.UnmatchedInputsException(arrayList);
        }
        catch (RemoteObjectClosedException remoteObjectClosedException) {
            throw new ObjectClosedException(remoteObjectClosedException.toString());
        }
        catch (RemoteTaskInterruptedException remoteTaskInterruptedException) {
            throw new TaskInterruptedException(remoteTaskInterruptedException.toString());
        }
    }

    final void _definitionManagerOpened(DefinitionManager definitionManager) {
        this._openDefinitionManagers.add(definitionManager);
    }

    final void _definitionManagerClosed(DefinitionManager definitionManager) {
        this._openDefinitionManagers.remove(definitionManager);
    }

    public synchronized void setExceptionDefinitionWriter(ExceptionDefinitionWriter exceptionDefinitionWriter) {
        this.exceptionWriter = exceptionDefinitionWriter;
    }

    public synchronized ExceptionDefinitionWriter getExceptionDefinitionWriter() {
        return this.exceptionWriter != null ? this.exceptionWriter : ExceptionDefinitionWriter.getDefaultInstance();
    }

    public synchronized MetadataProvider getDefaultMetadataProvider() {
        if (null == this._defaultMetadataProvider) {
            String string = this._props.getProperty(XML_METADATA_FILE);
            XMLFileFetcher xMLFileFetcher = null;
            if (null != string) {
                xMLFileFetcher = new XMLFileFetcher(string);
            }
            oracle.olapi.metadata.mdm.MdmMetadataProvider mdmMetadataProvider = new oracle.olapi.metadata.mdm.MdmMetadataProvider(this, xMLFileFetcher);
            String string2 = this._props.getProperty(MDM_COMPATIBILITY_MODE);
            this._defaultMetadataProvider = null != string2 && string2.equals("9.2") ? new MdmMetadataProvider(mdmMetadataProvider) : mdmMetadataProvider;
        }
        return this._defaultMetadataProvider;
    }

    public final MetadataProviderInterface getMetadataProviderInterface() {
        if (null == this._metadataProviderInterface) {
            try {
                DatabaseInterface databaseInterface = this.getConnectionInterface().getDefaultDatabase();
                this._metadataProviderInterface = MetadataProviderInterfaceHelper.narrow(databaseInterface);
            }
            catch (RemoteObjectClosedException remoteObjectClosedException) {
                throw new ObjectClosedException(remoteObjectClosedException.toString());
            }
            catch (ExpressException expressException) {
                throw new ExpressServerException(expressException);
            }
        }
        return this._metadataProviderInterface;
    }

    public void close() {
        try {
            this._connectionInterface.close();
            this._connectionInterface = null;
            this._defaultMetadataProvider = null;
            this._metadataProviderInterface = null;
            _serverInterfaceMap.remove(this._jdbc_connection);
            this._jdbc_connection = null;
        }
        catch (ExpressException expressException) {
            // empty catch block
        }
    }

    public void setGenerationInfoListener(ExpressGenerationInfoListener expressGenerationInfoListener) {
        this._generationInfoListener = expressGenerationInfoListener;
    }

    public ExpressGenerationInfoListener getGenerationInfoListener() {
        return this._generationInfoListener;
    }

    public String getProperty(String string) {
        return this._props.getProperty(string);
    }

    public final SQLCursorManager[] createSQLCursorManagers(Source[] sourceArray) {
        return this.createSQLCursorManagers(sourceArray, 0L, false, false, null, null);
    }

    public final SQLCursorManager[] createSQLCursorManagers(Source[] sourceArray, String[] stringArray) {
        return this.createSQLCursorManagers(sourceArray, 0L, false, true, stringArray, null);
    }

    public final SQLCursorManager[] createSQLCursorManagers(Source[] sourceArray, boolean bl, String[] stringArray) {
        return this.createSQLCursorManagers(sourceArray, 0L, bl, true, stringArray, null);
    }

    public final SQLCursorManager[] createSQLCursorManagers(Source[] sourceArray, long l, boolean bl, boolean bl2, String[] stringArray) throws DataProviderMismatchException, ExpressServerException, ObjectClosedException, TransactionalObjectInvalidException {
        return this.createSQLCursorManagers(sourceArray, l, bl, bl2, stringArray, null);
    }

    public final SQLCursorManager[] createSQLCursorManagers(Source[] sourceArray, long l, boolean bl, boolean bl2, String[] stringArray, Properties properties) throws DataProviderMismatchException, ExpressServerException, ObjectClosedException, TransactionalObjectInvalidException {
        int n = sourceArray.length;
        if (0 == n) {
            return new SQLCursorManager[0];
        }
        if (bl2 && (null == stringArray || stringArray.length != n)) {
            throw new IllegalArgumentException();
        }
        if (!this.isServerVersionLaterThan(new int[]{9, 2, 0, 4, 0})) {
            throw new UnsupportedOperationException();
        }
        for (int i = 0; i < n; ++i) {
            if (sourceArray[i].getDataProvider() == this) continue;
            throw new DataProviderMismatchException();
        }
        DefinitionManagerSince9202 definitionManagerSince9202 = this.getCurrentDefinitionManagerSince9202();
        long l2 = l;
        ExpressGenerationInfoListener expressGenerationInfoListener = this.getGenerationInfoListener();
        if (null != expressGenerationInfoListener) {
            l2 = l | expressGenerationInfoListener.getGenerationInfoTypeForCreateCursorManager();
        }
        SQLCursorManager[] sQLCursorManagerArray = null;
        sQLCursorManagerArray = definitionManagerSince9202.createSQLCursorManagers(sourceArray, l2, bl, bl2, stringArray, properties);
        if (null != expressGenerationInfoListener) {
            for (int i = 0; i < n; ++i) {
                expressGenerationInfoListener.notifyOfCreateCursorManager((BaseCursorManager)((Object)sQLCursorManagerArray[i]));
            }
        }
        return sQLCursorManagerArray;
    }

    public final SpecifiedCursorManager[] createCursorManagers(CursorManagerSpecification[] cursorManagerSpecificationArray, Source[][] sourceArray) throws DataProviderMismatchException, ExpressServerException, ObjectClosedException, TransactionalObjectInvalidException {
        return this.createCursorManagers(cursorManagerSpecificationArray, sourceArray, null, 0L);
    }

    public final SpecifiedCursorManager[] createCursorManagers(CursorManagerSpecification[] cursorManagerSpecificationArray, Source[][] sourceArray, Properties properties) {
        return this.createCursorManagers(cursorManagerSpecificationArray, sourceArray, properties, 0L);
    }

    public final SpecifiedCursorManager[] createCursorManagers(CursorManagerSpecification[] cursorManagerSpecificationArray, Source[][] sourceArray, long l) {
        return this.createCursorManagers(cursorManagerSpecificationArray, sourceArray, null, l);
    }

    public final SpecifiedCursorManager[] createCursorManagers(CursorManagerSpecification[] cursorManagerSpecificationArray, Source[][] sourceArray, Properties properties, long l) throws DataProviderMismatchException, ExpressServerException, ObjectClosedException, TransactionalObjectInvalidException {
        int n = cursorManagerSpecificationArray.length;
        if (0 == n) {
            return new ExpressSpecifiedCursorManager[0];
        }
        if (sourceArray.length != n) {
            throw new IllegalArgumentException();
        }
        if (!this.isServerVersionLaterThan(new int[]{9, 2, 0, 4, 0})) {
            throw new UnsupportedOperationException();
        }
        Transaction transaction = this.getTransactionProvider().getCurrentTransactionForDataRead();
        for (int i = 0; i < n; ++i) {
            CursorManagerSpecification cursorManagerSpecification = cursorManagerSpecificationArray[i];
            Source source = cursorManagerSpecification.getRootCursorSpecification().getSource();
            if (source.getDataProvider() != this) {
                throw new DataProviderMismatchException();
            }
            if (!cursorManagerSpecification.getTransaction().equals(transaction)) {
                throw new TransactionalObjectInvalidException();
            }
            if (null != sourceArray[i]) continue;
            sourceArray[i] = new Source[0];
        }
        DefinitionManagerSince9202 definitionManagerSince9202 = this.getCurrentDefinitionManagerSince9202();
        long l2 = l;
        ExpressGenerationInfoListener expressGenerationInfoListener = this.getGenerationInfoListener();
        if (null != expressGenerationInfoListener) {
            l2 = l | expressGenerationInfoListener.getGenerationInfoTypeForCreateCursorManager();
        }
        CursorInputTemplate[] cursorInputTemplateArray = new CursorInputTemplate[n];
        for (int i = 0; i < n; ++i) {
            CursorInputTemplate cursorInputTemplate;
            Source source = cursorManagerSpecificationArray[i].getRootCursorSpecification().getSource();
            cursorInputTemplateArray[i] = cursorInputTemplate = new CursorInputTemplate(source, sourceArray[i], ExpressSpecifiedCursorManager.calculateInputSourceTypes(sourceArray[i]), transaction);
        }
        SpecifiedCursorManager[] specifiedCursorManagerArray = definitionManagerSince9202.createOLAPICursorManagers(cursorManagerSpecificationArray, cursorInputTemplateArray, l2, properties);
        if (null != expressGenerationInfoListener) {
            for (int i = 0; i < n; ++i) {
                expressGenerationInfoListener.notifyOfCreateCursorManager((BaseCursorManager)((Object)specifiedCursorManagerArray[i]));
            }
        }
        return specifiedCursorManagerArray;
    }

    public final String getShortXMLTag() {
        return "Short";
    }

    public final String getIntegerXMLTag() {
        return "Long";
    }

    public final String getLongXMLTag() {
        return "LongLong";
    }

    public final String getFloatXMLTag() {
        return "Float";
    }

    public final String getDoubleXMLTag() {
        return "Double";
    }

    public final String getStringXMLTag() {
        return "Wstring";
    }

    public final String getBooleanXMLTag() {
        return "Boolean";
    }

    public final String getDateXMLTag() {
        return "Date";
    }

    public boolean supportsBulkSend() {
        return this.isServerVersionLaterThan(new int[]{9, 2, 0, 7, 0}) && !this.isServerVersionLaterThan(new int[]{10, 0, 0, 0, 0}) || this.isServerVersionLaterThan(new int[]{10, 1, 0, 5, 0}) && !this.isServerVersionLaterThan(new int[]{10, 2, 0, 0, 0});
    }

    public void bulkSendMetadata() {
        if (!this.supportsBulkSend()) {
            return;
        }
        Transaction transaction = this.getTransactionProvider().getCurrentTransactionForDataRead();
        DefinitionManagerSince9202 definitionManagerSince9202 = new DefinitionManagerSince9202(transaction, this);
        definitionManagerSince9202.init();
        definitionManagerSince9202.bulkSendMetadata();
        definitionManagerSince9202.rollback();
    }
}

