/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data.full;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import oracle.express.ErrorDescription;
import oracle.express.ExpressServerException;
import oracle.express.ObjectClosedException;
import oracle.express.TaskInterruptedException;
import oracle.express.idl.ExpressModule.ExpressException;
import oracle.express.idl.ExpressModule.RemoteObjectClosedException;
import oracle.express.idl.ExpressModule.RemoteTaskInterruptedException;
import oracle.express.idl.ExpressOlapiDataCursorModule.CursorManagerInterface;
import oracle.express.idl.ExpressOlapiDataCursorModule.CursorSpecifierStruct;
import oracle.express.idl.ExpressOlapiDataSourceModule.DefinitionManagerInterface;
import oracle.express.idl.ExpressOlapiDataSourceModule.UnmatchedInputsException;
import oracle.express.idl.util.InterfaceStub;
import oracle.express.olapi.data.SourceIdentifierProvider;
import oracle.express.olapi.data.full.BaseCursorManager;
import oracle.express.olapi.data.full.CursorInputTemplate;
import oracle.express.olapi.data.full.CursorSpecifierSequenceBuilder;
import oracle.express.olapi.data.full.ExpressDataProvider;
import oracle.express.olapi.data.full.ExpressNotCommittableException;
import oracle.express.olapi.data.full.ExpressSpecifiedCursorManager;
import oracle.express.olapi.data.full.SourceConverter;
import oracle.express.olapi.data.full.SourceToStructureConverter;
import oracle.express.olapi.data.full.SourceToXMLConverter;
import oracle.olapi.UnsupportedOperationException;
import oracle.olapi.data.cursor.NoDataAvailableException;
import oracle.olapi.data.cursor.SourceIdentifier;
import oracle.olapi.data.source.CursorInfoSpecification;
import oracle.olapi.data.source.CursorLock;
import oracle.olapi.data.source.CursorLockException;
import oracle.olapi.data.source.CursorManagerSpecification;
import oracle.olapi.data.source.CursorSpecification;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.metadata.InvalidMetadataException;
import oracle.olapi.transaction.NotCommittableException;
import oracle.olapi.transaction.Transaction;
import oracle.olapi.transaction.UpdateAwareParticipant;
import org.omg.CORBA.NO_IMPLEMENT;

public abstract class DefinitionManager
implements SourceIdentifierProvider,
CursorLock,
UpdateAwareParticipant {
    boolean m_Open = true;
    Transaction m_Transaction;
    ExpressDataProvider m_ExpressDataProvider;
    Map m_IDToDefinitionMap;
    List m_OpenCursorManagers;
    DefinitionManagerInterface m_DefinitionManagerInterface;
    Transaction m_PreparedSubtransaction;
    SourceConverter m_SourceConverter;
    private long m_definitionManagerID = -1L;

    DefinitionManager(Transaction transaction, ExpressDataProvider expressDataProvider) throws ObjectClosedException, ExpressServerException {
        this.m_Transaction = transaction;
        this.m_ExpressDataProvider = expressDataProvider;
        this.m_IDToDefinitionMap = new HashMap();
        this.m_OpenCursorManagers = new ArrayList();
        this.m_Transaction.registerUpdateAwareParticipant(this);
        this.m_ExpressDataProvider._definitionManagerOpened(this);
        this.m_SourceConverter = null;
    }

    void init() {
        if (this.sendDefinitionsViaXML()) {
            this.setSourceConverter(SourceToXMLConverter.createSourceToXMLConverter(this.getExpressDataProvider().getServerVersion(), this));
        } else {
            this.setSourceConverter(new SourceToStructureConverter(this));
        }
    }

    void _closed() {
        this.setOpen(false);
        this.getExpressDataProvider()._definitionManagerClosed(this);
        this.getTransaction().unregisterUpdateAwareParticipant(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _cursorManagerClosed(BaseCursorManager baseCursorManager) {
        List list = this.getOpenCursorManagers();
        synchronized (list) {
            this.getOpenCursorManagers().remove(baseCursorManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void _cursorManagerOpened(BaseCursorManager baseCursorManager) {
        List list = this.getOpenCursorManagers();
        synchronized (list) {
            this.getOpenCursorManagers().add(baseCursorManager);
        }
    }

    static CursorSpecifierStruct[] _cursorSpecificationToCursorSpecifierSequence(CursorSpecification cursorSpecification) {
        ArrayList arrayList = new ArrayList();
        cursorSpecification.acceptVisitor(new CursorSpecifierSequenceBuilder(), arrayList);
        CursorSpecifierStruct[] cursorSpecifierStructArray = new CursorSpecifierStruct[arrayList.size()];
        return arrayList.toArray(cursorSpecifierStructArray);
    }

    static final CursorSpecifierStruct[] _cursorManagerSpecificationToCursorSpecifierSequence(CursorManagerSpecification cursorManagerSpecification) {
        return DefinitionManager._cursorSpecificationToCursorSpecifierSequence(cursorManagerSpecification.getRootCursorSpecification());
    }

    static final CursorSpecifierStruct[] _cursorInfoSpecificationToCursorSpecifierSequence(int n, CursorInfoSpecification cursorInfoSpecification) {
        CursorSpecification cursorSpecification = null;
        try {
            cursorSpecification = (CursorSpecification)cursorInfoSpecification;
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException();
        }
        if (n >= 1) {
            cursorSpecification.setDefaultFetchSize(n);
        } else if (n == -1) {
            cursorSpecification.setDefaultFetchSize(Integer.MAX_VALUE);
        } else {
            throw new IllegalArgumentException();
        }
        return DefinitionManager._cursorSpecificationToCursorSpecifierSequence(cursorSpecification);
    }

    DefinitionManagerInterface _getDefinitionManagerInterface() throws ObjectClosedException {
        if (!this.isOpen()) {
            throw new ObjectClosedException();
        }
        return this.m_DefinitionManagerInterface;
    }

    protected DefinitionManagerInterface getDefinitionManagerInterface() {
        return this.m_DefinitionManagerInterface;
    }

    protected void setDefinitionManagerInterface(DefinitionManagerInterface definitionManagerInterface) {
        this.m_DefinitionManagerInterface = definitionManagerInterface;
    }

    public abstract void commit(Transaction var1);

    public final void commitSubtransaction() {
        this.setPreparedSubtransaction(null);
    }

    public final ExpressSpecifiedCursorManager createCursorManager(CursorManagerSpecification cursorManagerSpecification, CursorInputTemplate cursorInputTemplate, long l) throws ObjectClosedException, ExpressServerException {
        return this.createCursorManager(cursorManagerSpecification, cursorInputTemplate, l, null);
    }

    public final ExpressSpecifiedCursorManager createCursorManager(CursorManagerSpecification cursorManagerSpecification, CursorInputTemplate cursorInputTemplate, long l, Properties properties) throws ObjectClosedException, ExpressServerException {
        Source source = cursorInputTemplate.getSource();
        ArrayList arrayList = new ArrayList();
        long[] lArray = new long[1];
        CursorManagerInterface cursorManagerInterface = this.createCursorManagerInterface(cursorManagerSpecification, source.getDefinition(), cursorInputTemplate, l, arrayList, lArray, properties);
        long l2 = lArray[0];
        ExpressSpecifiedCursorManager expressSpecifiedCursorManager = new ExpressSpecifiedCursorManager(source, cursorManagerSpecification, cursorManagerInterface, l2, this, cursorInputTemplate, arrayList);
        this._cursorManagerOpened(expressSpecifiedCursorManager);
        return expressSpecifiedCursorManager;
    }

    abstract CursorManagerInterface createCursorManagerInterface(CursorManagerSpecification var1, SourceDefinition var2, CursorInputTemplate var3, long var4, List var6, long[] var7, Properties var8) throws ObjectClosedException, ExpressServerException;

    public final Transaction getCurrentReadTransaction() {
        return this.getExpressDataProvider().getTransactionProvider().getCurrentTransactionForMetadataRead();
    }

    abstract long getCursorManagerID(CursorManagerInterface var1);

    public final ExpressDataProvider getExpressDataProvider() {
        return this.m_ExpressDataProvider;
    }

    private Map getIDToDefinitionMap() {
        return this.m_IDToDefinitionMap;
    }

    protected List getOpenCursorManagers() {
        return this.m_OpenCursorManagers;
    }

    private void setOpenCursorManagers(List list) {
        this.m_OpenCursorManagers = list;
    }

    private Transaction getPreparedSubtransaction() {
        return this.m_PreparedSubtransaction;
    }

    private void setPreparedSubtransaction(Transaction transaction) {
        this.m_PreparedSubtransaction = transaction;
    }

    public final SourceIdentifier getSourceIdentifier(String string) {
        SourceDefinition sourceDefinition = (SourceDefinition)this.getIDToDefinitionMap().get(string);
        return sourceDefinition.getSource();
    }

    public final SourceIdentifier getSourceIdentifier(String string, String string2) {
        return this.getExpressDataProvider().getMetadataProvider(string).getSource(string2);
    }

    protected SourceConverter getSourceConverter() {
        return this.m_SourceConverter;
    }

    private void setSourceConverter(SourceConverter sourceConverter) {
        this.m_SourceConverter = sourceConverter;
    }

    public final Transaction getTransaction() {
        return this.m_Transaction;
    }

    protected void setTransaction(Transaction transaction) {
        this.m_Transaction = transaction;
    }

    public final boolean isOpen() {
        if (this.m_Open) {
            this.setOpen(this.getExpressDataProvider().isOpen());
        }
        return this.m_Open;
    }

    public void prepare(Transaction transaction) throws NotCommittableException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void prepareSubtransaction(Transaction transaction) throws NotCommittableException {
        Object object;
        this.setPreparedSubtransaction(transaction);
        if (this.getOpenCursorManagers().isEmpty()) {
            return;
        }
        SourceConverter sourceConverter = this.getSourceConverter();
        sourceConverter.reset((InterfaceStub)((Object)this.getDefinitionManagerInterface()), transaction);
        try {
            object = this.getOpenCursorManagers().iterator();
            while (object.hasNext()) {
                BaseCursorManager baseCursorManager = (BaseCursorManager)object.next();
                baseCursorManager.createDefinitionSequence(transaction, sourceConverter);
            }
        }
        catch (CursorLockException cursorLockException) {
            sourceConverter.recover();
            throw new NotCommittableException(cursorLockException.toString());
        }
        object = sourceConverter.getCursorManagerIDArray();
        if (0 == ((Object)object).length) {
            return;
        }
        boolean bl = false;
        try {
            bl = this.localPrepare();
        }
        catch (ExpressException expressException) {
            throw new ExpressNotCommittableException(expressException);
        }
        catch (RemoteObjectClosedException remoteObjectClosedException) {
            this._closed();
        }
        catch (NO_IMPLEMENT nO_IMPLEMENT) {
            this._closed();
        }
        catch (Exception exception) {
            this.translateException(exception);
        }
        List list = this.getOpenCursorManagers();
        synchronized (list) {
            Iterator iterator = this.getOpenCursorManagers().iterator();
            while (iterator.hasNext()) {
                ExpressSpecifiedCursorManager expressSpecifiedCursorManager;
                BaseCursorManager baseCursorManager = (BaseCursorManager)iterator.next();
                if (!(baseCursorManager instanceof ExpressSpecifiedCursorManager) || !sourceConverter.cursorManagerWasSent((expressSpecifiedCursorManager = (ExpressSpecifiedCursorManager)baseCursorManager).getCursorManagerID())) continue;
                if (bl) {
                    expressSpecifiedCursorManager._structureUpdated();
                    continue;
                }
                expressSpecifiedCursorManager._dataUpdated();
            }
        }
    }

    public final void rollback() {
        try {
            this._getDefinitionManagerInterface().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._closed();
    }

    public final void rollbackSubtransaction(Transaction transaction) {
        if (this.getPreparedSubtransaction() == transaction) {
            try {
                this._getDefinitionManagerInterface().rollback();
            }
            catch (ExpressException expressException) {
            }
            catch (RemoteObjectClosedException remoteObjectClosedException) {
                this._closed();
            }
            catch (NO_IMPLEMENT nO_IMPLEMENT) {
                this._closed();
            }
        }
    }

    protected abstract boolean localPrepare() throws oracle.olapi.data.source.UnmatchedInputsException, ExpressException, RemoteTaskInterruptedException, RemoteObjectClosedException, UnmatchedInputsException, oracle.express.idl.ExpressModule.InvalidMetadataException;

    void setOpen(boolean bl) {
        this.m_Open = bl;
    }

    long getDefinitionManagerID() {
        if (-1L == this.m_definitionManagerID) {
            this.m_definitionManagerID = this.getDefinitionManagerInterface().getInternalID();
        }
        return this.m_definitionManagerID;
    }

    protected abstract boolean sendDefinitionsViaXML();

    protected void translateException(Exception exception, boolean bl) {
        new ExceptionTranslator(this, bl).translateException(exception);
    }

    protected void translateException(Exception exception) {
        this.translateException(exception, true);
    }

    protected static class ExceptionTranslator {
        private DefinitionManager _defMgr;
        private boolean _okToClose = true;

        ExceptionTranslator(DefinitionManager definitionManager, boolean bl) {
            this._defMgr = definitionManager;
            this._okToClose = bl;
        }

        protected void instanceClosed() {
            if (this._okToClose) {
                this._defMgr._closed();
            }
        }

        public void translateException(Exception exception) {
            if (exception instanceof ExpressException) {
                this.translateExpressException((ExpressException)exception);
            } else if (exception instanceof RemoteObjectClosedException) {
                this.translateRemoteObjectClosedException((RemoteObjectClosedException)exception);
            } else if (exception instanceof RemoteTaskInterruptedException) {
                this.translateRemoteTaskInterruptedException((RemoteTaskInterruptedException)exception);
            } else if (exception instanceof UnmatchedInputsException) {
                this.translateUnmatchedInputsException((UnmatchedInputsException)exception);
            } else if (exception instanceof oracle.express.idl.ExpressModule.InvalidMetadataException) {
                this.translateInvalidMetadataException((oracle.express.idl.ExpressModule.InvalidMetadataException)exception);
            } else if (exception instanceof NO_IMPLEMENT) {
                this.translateNO_IMPLEMENT((NO_IMPLEMENT)((Object)exception));
            } else {
                this.translateUnknownException(exception);
            }
        }

        public void translateExpressException(ExpressException expressException) {
            ExpressException expressException2 = expressException;
            ExpressServerException expressServerException = new ExpressServerException(expressException2);
            ErrorDescription errorDescription = (ErrorDescription)expressServerException.getErrorStack().getErrorDescriptions().get(0);
            if (errorDescription.getErrorType() == 1) {
                throw new NoDataAvailableException();
            }
            throw expressServerException;
        }

        public void translateRemoteObjectClosedException(RemoteObjectClosedException remoteObjectClosedException) {
            this.instanceClosed();
            throw new ObjectClosedException(remoteObjectClosedException.toString());
        }

        public void translateRemoteTaskInterruptedException(RemoteTaskInterruptedException remoteTaskInterruptedException) {
            throw new TaskInterruptedException(remoteTaskInterruptedException.toString());
        }

        public void translateUnmatchedInputsException(UnmatchedInputsException unmatchedInputsException) {
            UnmatchedInputsException unmatchedInputsException2 = unmatchedInputsException;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < unmatchedInputsException2.ids.length; ++i) {
                arrayList.add(unmatchedInputsException2.ids[i]);
            }
            throw new oracle.olapi.data.source.UnmatchedInputsException(arrayList);
        }

        public void translateInvalidMetadataException(oracle.express.idl.ExpressModule.InvalidMetadataException invalidMetadataException) {
            throw new InvalidMetadataException(invalidMetadataException);
        }

        public void translateNO_IMPLEMENT(NO_IMPLEMENT nO_IMPLEMENT) {
            this.instanceClosed();
            throw new ObjectClosedException(nO_IMPLEMENT.toString());
        }

        public void translateUnknownException(Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(exception.toString());
        }
    }
}

