/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data.full;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import oracle.express.olapi.data.CursorTreeManager;
import oracle.olapi.data.cursor.CursorInput;
import oracle.olapi.data.cursor.SourceType;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.Parameter;
import oracle.olapi.data.source.ParameterVisitor;

public class CursorInputParameter
extends Parameter {
    private List m_CursorInputs = null;
    private List m_CursorTreeManagers = null;
    private SourceType m_SourceType = null;

    CursorInputParameter(DataProvider dataProvider, SourceType sourceType) {
        super(dataProvider);
        this.m_SourceType = sourceType;
        this.m_CursorInputs = new ArrayList();
        this.m_CursorTreeManagers = new ArrayList();
    }

    public final Object acceptVisitor(ParameterVisitor parameterVisitor, Object object) {
        return null;
    }

    public final List getCursorInputs() {
        return this.m_CursorInputs;
    }

    public final List getCursorTreeManagers() {
        return this.m_CursorTreeManagers;
    }

    private final Object getDefaultValue() {
        if (this.getSourceType() == SourceType.NUMBER_SOURCE) {
            return new Short(0);
        }
        if (this.getSourceType() == SourceType.DATE_SOURCE) {
            return new Date();
        }
        if (this.getSourceType() == SourceType.BOOLEAN_SOURCE) {
            return new Boolean(false);
        }
        if (this.getSourceType() == SourceType.STRING_SOURCE) {
            return new String("");
        }
        return null;
    }

    public final SourceType getSourceType() {
        return this.m_SourceType;
    }

    public final Object getValueObject() {
        if (this.getCursorInputs().size() > 0) {
            return ((CursorInput)this.getCursorInputs().get(0)).getCurrentValue();
        }
        return this.getDefaultValue();
    }

    public final Object getValueForCursor(CursorTreeManager cursorTreeManager) {
        CursorInput cursorInput = null;
        if (this.getCursorInputs().size() == this.getCursorTreeManagers().size() + 1) {
            cursorInput = (CursorInput)this.getCursorInputs().get(this.getCursorInputs().size() - 1);
        } else {
            for (int i = 0; i < this.getCursorTreeManagers().size(); ++i) {
                if (this.getCursorTreeManagers().get(i) != cursorTreeManager) continue;
                cursorInput = (CursorInput)this.getCursorInputs().get(i);
                break;
            }
        }
        if (cursorInput != null) {
            return cursorInput.getCurrentValue();
        }
        return this.getDefaultValue();
    }

    public final void addCursorInput(CursorInput cursorInput) {
        this.m_CursorInputs.add(cursorInput);
    }

    public final void addCursorTreeManager(CursorTreeManager cursorTreeManager) {
        this.m_CursorTreeManagers.add(cursorTreeManager);
    }

    public final void clearCursorInputs() {
        this.m_CursorInputs.clear();
        this.m_CursorTreeManagers.clear();
    }
}

