/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data.full;

import java.util.List;
import oracle.express.ExpressServerException;
import oracle.express.ObjectClosedException;
import oracle.express.idl.ExpressModule.ExpressException;
import oracle.express.idl.ExpressModule.RemoteObjectClosedException;
import oracle.express.idl.ExpressOlapiDataCursorModule.CursorManagerInterface;
import oracle.express.idl.util.WstringHolder;
import oracle.express.olapi.data.full.DefinitionManager;
import oracle.express.olapi.data.full.ExpressGenerationInfoListener;
import oracle.express.olapi.data.full.SourceConverter;
import oracle.olapi.data.source.Source;
import oracle.olapi.transaction.Transaction;
import org.omg.CORBA.NO_IMPLEMENT;

public abstract class BaseCursorManager {
    private boolean _open = false;
    private Transaction _transaction = null;
    private CursorManagerInterface _cursorManagerInterface = null;
    private Source _rootSource;
    private long _cursorManagerID = -1L;
    private DefinitionManager _definitionManager = null;
    private List m_Parameters = null;

    protected BaseCursorManager(Source source, CursorManagerInterface cursorManagerInterface, long l, DefinitionManager definitionManager, List list) {
        this.setSource(source);
        this.setOpen(true);
        this.setTransaction(definitionManager.getTransaction());
        this.setDefinitionManager(definitionManager);
        this.setCursorManagerID(l);
        this.setCursorManagerInterface(cursorManagerInterface);
        this.m_Parameters = list;
    }

    protected List getParameters() {
        return this.m_Parameters;
    }

    public final boolean isOpen() {
        if (this._open) {
            this._open = this.getDefinitionManager().isOpen();
        }
        return this._open;
    }

    private final void setOpen(boolean bl) {
        this._open = bl;
    }

    protected final Transaction getTransaction() {
        return this._transaction;
    }

    private final void setTransaction(Transaction transaction) {
        this._transaction = transaction;
    }

    protected final CursorManagerInterface getCursorManagerInterface() throws ObjectClosedException {
        if (!this.isOpen()) {
            throw new ObjectClosedException();
        }
        return this._cursorManagerInterface;
    }

    final void setCursorManagerInterface(CursorManagerInterface cursorManagerInterface) {
        this._cursorManagerInterface = cursorManagerInterface;
    }

    public final Source getSource() {
        return this._rootSource;
    }

    private final void setSource(Source source) {
        this._rootSource = source;
    }

    protected final long getCursorManagerID() {
        return this._cursorManagerID;
    }

    private final void setCursorManagerID(long l) {
        this._cursorManagerID = l;
    }

    protected final DefinitionManager getDefinitionManager() {
        return this._definitionManager;
    }

    private final void setDefinitionManager(DefinitionManager definitionManager) {
        this._definitionManager = definitionManager;
    }

    protected void _closed() {
        this.setOpen(false);
        this.getDefinitionManager()._cursorManagerClosed(this);
    }

    public final void close() throws ExpressServerException {
        if (!this.isOpen()) {
            return;
        }
        try {
            ExpressGenerationInfoListener expressGenerationInfoListener = this.getDefinitionManager().getExpressDataProvider().getGenerationInfoListener();
            if (null != expressGenerationInfoListener) {
                expressGenerationInfoListener.notifyOfClose(this);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.getCursorManagerInterface().close();
        }
        catch (ExpressException expressException) {
            throw new ExpressServerException(expressException);
        }
        catch (NO_IMPLEMENT nO_IMPLEMENT) {
            // empty catch block
        }
        this._closed();
    }

    protected abstract void localCreateDefinitionSequence(Transaction var1, SourceConverter var2);

    final void createDefinitionSequence(Transaction transaction, SourceConverter sourceConverter) {
        this.localCreateDefinitionSequence(transaction, sourceConverter);
    }

    public final String getGenerationInfo(long l) {
        if (!this.isOpen()) {
            return "";
        }
        try {
            WstringHolder wstringHolder = new WstringHolder();
            this.getCursorManagerInterface().getGenerationInfo(l, wstringHolder);
            return wstringHolder.value;
        }
        catch (RemoteObjectClosedException remoteObjectClosedException) {
            return "Remote object is closed.";
        }
        catch (NO_IMPLEMENT nO_IMPLEMENT) {
            return "";
        }
    }
}

