/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import oracle.express.idl.ExpressOlapiDataCursorModule.CursorValue2Union;
import oracle.express.idl.ExpressOlapiDataCursorModule.CursorValueUnion;
import oracle.express.idl.ExpressOlapiModule.Data2Union;
import oracle.express.idl.ExpressOlapiModule.DataUnion;
import oracle.express.olapi.data.CursorBlock;
import oracle.express.olapi.data.CursorBlockManager;
import oracle.express.olapi.data.CursorBlockProvider;
import oracle.express.olapi.data.CursorValidationContext;
import oracle.express.olapi.data.ExpressCursor;
import oracle.express.olapi.data.InvalidCursorBlockException;
import oracle.express.olapi.data.full.CursorInputParameter;
import oracle.olapi.data.cursor.NoDataAvailableException;
import oracle.olapi.data.source.Parameter;

public class CursorTreeManager {
    private ExpressCursor[] _idToCursorTable;
    private CursorBlockProvider _cursorBlockProvider;
    private CursorBlock _currentCursorBlock;
    private boolean _valid;
    private Parameter[] _parameters;
    private Set _invalidBlocks;

    public CursorTreeManager(int n, CursorBlockProvider cursorBlockProvider, Parameter[] parameterArray) {
        this._idToCursorTable = new ExpressCursor[n];
        this._cursorBlockProvider = cursorBlockProvider;
        this._currentCursorBlock = null;
        this._parameters = parameterArray;
        this._invalidBlocks = new HashSet();
        this.setInvalid();
    }

    private Set getInvalidBlocks() {
        return this._invalidBlocks;
    }

    private ExpressCursor[] getCursorTable() {
        return this._idToCursorTable;
    }

    public final Parameter[] getParameters() {
        return this._parameters;
    }

    public final void registerCursor(int n, ExpressCursor expressCursor) {
        this.getCursorTable()[n] = expressCursor;
    }

    public final ExpressCursor getCursor(int n) {
        return this.getCursorTable()[n];
    }

    public final int getNumCursors() {
        return this.getCursorTable().length;
    }

    public final boolean isValid() {
        return this._valid;
    }

    public final void setInvalid() {
        this._valid = false;
    }

    private void setValid() {
        this._valid = true;
    }

    public final CursorBlock getCurrentCursorBlock() {
        return this._currentCursorBlock;
    }

    private void setCurrentCursorBlock(CursorBlock cursorBlock) {
        this._currentCursorBlock = cursorBlock;
    }

    public final CursorBlockProvider getCursorBlockProvider() {
        return this._cursorBlockProvider;
    }

    public final CursorBlockManager getCursorBlockManager() {
        return this.getCursorBlockProvider().getCursorBlockManager();
    }

    public final void revalidate() {
        if (this.isValid()) {
            return;
        }
        Set set = this.getInvalidBlocks();
        set.clear();
        if (this.getCurrentCursorBlock() != null) {
            if (this.validateWithBlock(this.getCurrentCursorBlock(), set)) {
                this.setValid();
                return;
            }
            set.add(this.getCurrentCursorBlock());
        }
        CursorBlock cursorBlock = this.getCursorBlockProvider().getCursorBlock(this, set);
        this.setCurrentCursorBlock(cursorBlock);
        this.setValid();
        this.checkEmpty();
    }

    public final boolean validateWithBlock(CursorBlock cursorBlock, Set set) {
        if (set.contains(cursorBlock)) {
            return false;
        }
        if (!cursorBlock.matchesParameterValues(this, this.getParameters())) {
            return false;
        }
        if (cursorBlock.isEmpty()) {
            return true;
        }
        CursorValidationContext cursorValidationContext = new CursorValidationContext(this, cursorBlock);
        for (int i = 0; i < this.getCursorTable().length; ++i) {
            ExpressCursor expressCursor = this.getCursorTable()[i];
            boolean bl = true;
            try {
                bl = expressCursor.validateWithBlock(cursorValidationContext);
            }
            catch (InvalidCursorBlockException invalidCursorBlockException) {
                bl = false;
            }
            if (bl) continue;
            return false;
        }
        cursorValidationContext.commitState();
        return true;
    }

    public static final Object getParameterValueObject(CursorTreeManager cursorTreeManager, Parameter parameter) {
        Object object = null;
        object = parameter instanceof CursorInputParameter && cursorTreeManager != null ? ((CursorInputParameter)parameter).getValueForCursor(cursorTreeManager) : parameter.getValueObject();
        return object;
    }

    public static final CursorValueUnion[] getParameterValues(CursorTreeManager cursorTreeManager, Parameter[] parameterArray) {
        if (parameterArray == null) {
            return new CursorValueUnion[0];
        }
        CursorValueUnion[] cursorValueUnionArray = new CursorValueUnion[parameterArray.length];
        for (int i = 0; i < parameterArray.length; ++i) {
            Serializable serializable;
            Object object = CursorTreeManager.getParameterValueObject(cursorTreeManager, parameterArray[i]);
            DataUnion dataUnion = new DataUnion();
            if (object instanceof String) {
                dataUnion.wstringValue((String)object);
            } else if (object instanceof Boolean) {
                dataUnion.booleanValue((Boolean)object);
            } else if (object instanceof Short) {
                dataUnion.shortValue((Short)object);
            } else if (object instanceof Integer) {
                dataUnion.longValue((Integer)object);
            } else if (object instanceof Float) {
                dataUnion.floatValue(((Float)object).floatValue());
            } else if (object instanceof Double) {
                dataUnion.doubleValue((Double)object);
            } else {
                serializable = (Date)object;
                long l = ((Date)serializable).getTime();
                int n = (int)(l / 1000L);
                dataUnion.dateValue(n);
            }
            serializable = new CursorValueUnion();
            ((CursorValueUnion)serializable).literal(dataUnion);
            cursorValueUnionArray[i] = serializable;
        }
        return cursorValueUnionArray;
    }

    public static final CursorValue2Union[] getParameterValues2(CursorTreeManager cursorTreeManager, Parameter[] parameterArray) {
        if (parameterArray == null) {
            return new CursorValue2Union[0];
        }
        CursorValue2Union[] cursorValue2UnionArray = new CursorValue2Union[parameterArray.length];
        for (int i = 0; i < parameterArray.length; ++i) {
            Object object = CursorTreeManager.getParameterValueObject(cursorTreeManager, parameterArray[i]);
            Data2Union data2Union = new Data2Union();
            if (object instanceof String) {
                data2Union.wstringValue((String)object);
            } else if (object instanceof Boolean) {
                data2Union.booleanValue((Boolean)object);
            } else if (object instanceof Short) {
                data2Union.shortValue((Short)object);
            } else if (object instanceof Integer) {
                data2Union.longValue((Integer)object);
            } else if (object instanceof Float) {
                data2Union.floatValue(((Float)object).floatValue());
            } else if (object instanceof Double) {
                data2Union.doubleValue((Double)object);
            } else {
                data2Union.dateValue((Date)object);
            }
            CursorValue2Union cursorValue2Union = new CursorValue2Union();
            cursorValue2Union.literal(data2Union);
            cursorValue2UnionArray[i] = cursorValue2Union;
        }
        return cursorValue2UnionArray;
    }

    public boolean checkEmpty() {
        boolean bl = this.getCurrentCursorBlock() == null;
        boolean bl2 = false;
        if (!bl) {
            bl2 = this.getCurrentCursorBlock().matchesParameterValues(this, this.getParameters());
        }
        if (!bl && this.getCurrentCursorBlock().isEmpty() && bl2) {
            throw new NoDataAvailableException();
        }
        if (!bl2) {
            this.setInvalid();
        }
        return bl2;
    }
}

