/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data;

import oracle.express.idl.ExpressOlapiDataCursorModule.DataBlock2Struct;
import oracle.express.idl.ExpressOlapiDataCursorModule.MultiplierBlockStruct;
import oracle.express.idl.ExpressOlapiDataCursorModule.ParentStartEndBlock2Union;
import oracle.express.olapi.data.CursorStructureVisitor;
import oracle.express.olapi.data.CursorTreeManager;
import oracle.express.olapi.data.CursorValidationContext;
import oracle.express.olapi.data.DependencyGroupUser;
import oracle.express.olapi.data.ExpressCursor;
import oracle.olapi.data.cursor.NotSpecifiedException;
import oracle.olapi.data.cursor.SourceIdentifier;

public abstract class CursorStructure {
    private int _id;
    private SourceIdentifier _sourceIdentifier;
    private boolean _extentCalculationSpecified;
    private boolean _parentStartCalculationSpecified;
    private boolean _parentEndCalculationSpecified;
    private int _defaultFetchSize;

    CursorStructure(int n, SourceIdentifier sourceIdentifier, boolean bl, boolean bl2, boolean bl3, int n2) {
        this._id = n;
        this._sourceIdentifier = sourceIdentifier;
        this._extentCalculationSpecified = bl;
        this._parentStartCalculationSpecified = bl2;
        this._parentEndCalculationSpecified = bl3;
        this._defaultFetchSize = n2;
    }

    protected final int _getId() {
        return this._id;
    }

    final SourceIdentifier _getSourceIdentifier() {
        return this._sourceIdentifier;
    }

    final int _getDefaultFetchSize() {
        return this._defaultFetchSize;
    }

    abstract void _setPosition(long var1, ExpressCursor var3);

    abstract boolean _next(CursorTreeManager var1);

    abstract boolean _nextOrReset(CursorTreeManager var1);

    abstract boolean _hasNext(CursorTreeManager var1);

    abstract long _getExtent(CursorTreeManager var1);

    private int getIndexForParentStartEnd(ParentStartEndBlock2Union parentStartEndBlock2Union, CursorValidationContext cursorValidationContext) {
        int n = -1;
        n = parentStartEndBlock2Union.discriminator() == 0 ? (int)parentStartEndBlock2Union.dataBlock().exteriorDependencyGroupIndex : (int)parentStartEndBlock2Union.multiplierBlock().exteriorDependencyGroupIndex;
        int n2 = DependencyGroupUser.getDependencyGroupIndex(n, cursorValidationContext, true);
        return n2;
    }

    private long _getParentStartEndValue(ParentStartEndBlock2Union parentStartEndBlock2Union, CursorTreeManager cursorTreeManager) {
        int n = this.getIndexForParentStartEnd(parentStartEndBlock2Union, new CursorValidationContext(cursorTreeManager, cursorTreeManager.getCurrentCursorBlock()));
        long l = -1L;
        l = parentStartEndBlock2Union.discriminator() == 0 ? this._getParentStartEndValue(parentStartEndBlock2Union.dataBlock(), n) : this._getParentStartEndValue(parentStartEndBlock2Union.multiplierBlock(), n);
        return l;
    }

    private long _getParentStartEndValue(DataBlock2Struct dataBlock2Struct, int n) {
        return dataBlock2Struct.values.literals().longValues()[n];
    }

    private long _getParentStartEndValue(MultiplierBlockStruct multiplierBlockStruct, int n) {
        return n * multiplierBlockStruct.factor + multiplierBlockStruct.offset;
    }

    final long _getParentStart(CursorTreeManager cursorTreeManager) {
        if (!this._parentStartCalculationSpecified) {
            throw new NotSpecifiedException();
        }
        ParentStartEndBlock2Union parentStartEndBlock2Union = cursorTreeManager.getCurrentCursorBlock().getParentStartBlock(this._getId());
        return this._getParentStartEndValue(parentStartEndBlock2Union, cursorTreeManager);
    }

    final long _getParentEnd(CursorTreeManager cursorTreeManager) {
        if (!this._parentEndCalculationSpecified) {
            throw new NotSpecifiedException();
        }
        ParentStartEndBlock2Union parentStartEndBlock2Union = cursorTreeManager.getCurrentCursorBlock().getParentEndBlock(this._getId());
        return this._getParentStartEndValue(parentStartEndBlock2Union, cursorTreeManager);
    }

    private boolean validateParentStartEnd(ParentStartEndBlock2Union parentStartEndBlock2Union, CursorValidationContext cursorValidationContext) {
        int n = this.getIndexForParentStartEnd(parentStartEndBlock2Union, cursorValidationContext);
        boolean bl = false;
        bl = parentStartEndBlock2Union.discriminator() == 0 ? n >= 0 && n < parentStartEndBlock2Union.dataBlock().values.literals().longValues().length : true;
        return bl;
    }

    private boolean validateParentStart(CursorValidationContext cursorValidationContext) {
        if (!this._parentStartCalculationSpecified) {
            return true;
        }
        ParentStartEndBlock2Union parentStartEndBlock2Union = cursorValidationContext.getCursorBlock().getParentStartBlock(this._getId());
        return this.validateParentStartEnd(parentStartEndBlock2Union, cursorValidationContext);
    }

    private boolean validateParentEnd(CursorValidationContext cursorValidationContext) {
        if (!this._parentEndCalculationSpecified) {
            return true;
        }
        ParentStartEndBlock2Union parentStartEndBlock2Union = cursorValidationContext.getCursorBlock().getParentEndBlock(this._getId());
        return this.validateParentStartEnd(parentStartEndBlock2Union, cursorValidationContext);
    }

    boolean validateWithBlock(CursorValidationContext cursorValidationContext) {
        if (!this.validateParentStart(cursorValidationContext)) {
            return false;
        }
        return this.validateParentEnd(cursorValidationContext);
    }

    final int _getFetchSize(CursorTreeManager cursorTreeManager) throws NotSpecifiedException {
        if (this._defaultFetchSize == -1) {
            throw new NotSpecifiedException();
        }
        return cursorTreeManager.getCursor(this._getId()).getFetchSizeDirect();
    }

    final void _setFetchSize(int n, CursorTreeManager cursorTreeManager) throws NotSpecifiedException {
        if (this._defaultFetchSize == -1) {
            throw new NotSpecifiedException();
        }
        cursorTreeManager.getCursor(this._getId()).setFetchSizeDirect(n);
    }

    public abstract int getIndex(CursorValidationContext var1);

    abstract Object _acceptVisitor(CursorStructureVisitor var1, Object var2);
}

