/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data;

import oracle.express.olapi.data.CompoundCursorStructure;
import oracle.express.olapi.data.CursorBlockManager;
import oracle.express.olapi.data.CursorStructure;
import oracle.express.olapi.data.CursorStructureVisitor;
import oracle.express.olapi.data.CursorTreeManager;
import oracle.express.olapi.data.ExpressCompoundCursor;
import oracle.express.olapi.data.ExpressCursor;
import oracle.express.olapi.data.ExpressValueCursor;
import oracle.express.olapi.data.ValueCursorStructure;
import oracle.olapi.data.cursor.Cursor;
import oracle.olapi.data.source.Parameter;

public final class CursorFactory {
    private CursorFactory() {
    }

    static final ExpressCursor _createExpressCursor(CursorStructure cursorStructure, ExpressCompoundCursor expressCompoundCursor, CursorTreeManager cursorTreeManager) {
        return (ExpressCursor)cursorStructure._acceptVisitor(CursorFactoryCursorStructureVisitor.getInstance(), new CursorFactoryCursorStructureVisitor.Context(expressCompoundCursor, cursorTreeManager));
    }

    public static final CursorTreeManager createCursorTreeManager(int n, CursorBlockManager cursorBlockManager, Parameter[] parameterArray) {
        return new CursorTreeManager(n, cursorBlockManager._getCursorBlockProvider(), parameterArray);
    }

    public static final Cursor createCursor(CursorStructure cursorStructure, CursorTreeManager cursorTreeManager) {
        return CursorFactory._createExpressCursor(cursorStructure, null, cursorTreeManager);
    }

    public static final Cursor createCursor(CursorStructure cursorStructure, int n, CursorBlockManager cursorBlockManager, Parameter[] parameterArray) {
        CursorTreeManager cursorTreeManager = CursorFactory.createCursorTreeManager(n, cursorBlockManager, parameterArray);
        return CursorFactory.createCursor(cursorStructure, cursorTreeManager);
    }

    private static final class CursorFactoryCursorStructureVisitor
    extends CursorStructureVisitor {
        private static CursorFactoryCursorStructureVisitor _sInstance;

        private CursorFactoryCursorStructureVisitor() {
        }

        public static CursorFactoryCursorStructureVisitor getInstance() {
            if (_sInstance == null) {
                _sInstance = new CursorFactoryCursorStructureVisitor();
            }
            return _sInstance;
        }

        public final Object visitCompoundCursorStructure(CompoundCursorStructure compoundCursorStructure, Object object) {
            Context context = (Context)object;
            return new ExpressCompoundCursor(compoundCursorStructure, context.getParentCursor(), context.getCursorTreeManager());
        }

        public final Object visitValueCursorStructure(ValueCursorStructure valueCursorStructure, Object object) {
            Context context = (Context)object;
            return new ExpressValueCursor(valueCursorStructure, context.getParentCursor(), context.getCursorTreeManager());
        }

        public static final class Context {
            private ExpressCompoundCursor _parentCursor;
            private CursorTreeManager _cursorTreeManager;

            public Context(ExpressCompoundCursor expressCompoundCursor, CursorTreeManager cursorTreeManager) {
                this._parentCursor = expressCompoundCursor;
                this._cursorTreeManager = cursorTreeManager;
            }

            public final ExpressCompoundCursor getParentCursor() {
                return this._parentCursor;
            }

            public final CursorTreeManager getCursorTreeManager() {
                return this._cursorTreeManager;
            }
        }
    }
}

