/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data;

import java.util.Set;
import oracle.express.idl.ExpressOlapiDataCursorModule.CompoundCursorBlockStruct;
import oracle.express.idl.ExpressOlapiDataCursorModule.DataBlock2Struct;
import oracle.express.idl.ExpressOlapiDataCursorModule.DependencyBlockUnion;
import oracle.express.idl.ExpressOlapiDataCursorModule.IncludedDependencyBlockStruct;
import oracle.express.idl.ExpressOlapiDataCursorModule.ValueCursorBlockStruct;
import oracle.express.olapi.data.CursorBlock;
import oracle.express.olapi.data.CursorBlockCache;
import oracle.express.olapi.data.CursorBlockFetcher;
import oracle.express.olapi.data.CursorBlockProvider;
import oracle.express.olapi.data.CursorTreeManager;
import oracle.express.olapi.data.FIFOCursorBlockCache;
import oracle.express.olapi.data.PrimaryCursorBlockProvider;
import oracle.express.olapi.data.SecondaryCursorBlockProvider;
import oracle.express.olapi.data.SourceIdentifierProvider;
import oracle.olapi.ArraySet;
import oracle.olapi.data.cursor.NoDataAvailableException;

public final class CursorBlockManager {
    private SourceIdentifierProvider _sourceIdentifierProvider;
    private SecondaryCursorBlockProvider _cursorBlockProvider;
    private boolean[] _idToHasBlockTable;
    private Set[] _idToExteriorDependentIdsTable;
    private boolean _initialized = false;

    public CursorBlockManager(SourceIdentifierProvider sourceIdentifierProvider, CursorBlockFetcher cursorBlockFetcher, CursorBlock cursorBlock, int n) {
        this(sourceIdentifierProvider, cursorBlockFetcher, cursorBlock, new FIFOCursorBlockCache(n));
    }

    public CursorBlockManager(SourceIdentifierProvider sourceIdentifierProvider, CursorBlockFetcher cursorBlockFetcher, CursorBlock cursorBlock, CursorBlockCache cursorBlockCache) {
        this._sourceIdentifierProvider = sourceIdentifierProvider;
        this._cursorBlockProvider = this.createCursorBlockProvider(cursorBlockFetcher, cursorBlock, cursorBlockCache);
        this.initialize(cursorBlock);
    }

    public void initialize(CursorBlock cursorBlock) {
        if (!this.isInitialized() && cursorBlock != null) {
            this._createHandlers(cursorBlock);
        }
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    private SecondaryCursorBlockProvider createCursorBlockProvider(CursorBlockFetcher cursorBlockFetcher, CursorBlock cursorBlock, CursorBlockCache cursorBlockCache) {
        PrimaryCursorBlockProvider primaryCursorBlockProvider = new PrimaryCursorBlockProvider(cursorBlockFetcher, this);
        SecondaryCursorBlockProvider secondaryCursorBlockProvider = new SecondaryCursorBlockProvider(cursorBlockCache, primaryCursorBlockProvider, cursorBlock);
        return secondaryCursorBlockProvider;
    }

    public boolean hasBlock(int n) {
        if (this.isInitialized()) {
            return this._idToHasBlockTable[n];
        }
        throw new NoDataAvailableException();
    }

    public void die() {
        this._cursorBlockProvider.die();
    }

    public void dataUpdated() {
        this._cursorBlockProvider.flush();
        this._idToExteriorDependentIdsTable = null;
    }

    public void dataUpdated(CursorBlock cursorBlock) {
        if (cursorBlock == null) {
            this.dataUpdated();
        } else {
            this._cursorBlockProvider.flush(cursorBlock);
            this._createHandlers(cursorBlock);
        }
    }

    final CursorBlockProvider _getCursorBlockProvider() {
        return this._cursorBlockProvider;
    }

    final SourceIdentifierProvider _getSourceIdentifierProvider() {
        return this._sourceIdentifierProvider;
    }

    final Set _getExteriorDependentIds(int n, CursorTreeManager cursorTreeManager) {
        if (this._idToExteriorDependentIdsTable == null) {
            this._createHandlers(this._cursorBlockProvider.getAnyCursorBlock(cursorTreeManager));
        }
        if (this.isInitialized()) {
            return this._idToExteriorDependentIdsTable[n];
        }
        throw new NoDataAvailableException();
    }

    private void _createHandlers(CursorBlock cursorBlock) {
        int n;
        ValueCursorBlockStruct valueCursorBlockStruct;
        IncludedDependencyBlockStruct includedDependencyBlockStruct;
        DependencyBlockUnion[] dependencyBlockUnionArray;
        int n2 = cursorBlock.getIdTableSize();
        if (n2 == 0) {
            return;
        }
        this._initialized = true;
        this._idToExteriorDependentIdsTable = new Set[n2];
        for (int i = 0; i < n2; ++i) {
            this._idToExteriorDependentIdsTable[i] = new ArraySet();
        }
        DataBlock2Struct[] dataBlock2StructArray = cursorBlock.getDataBlocks();
        for (int i = 0; i < dataBlock2StructArray.length; ++i) {
            DataBlock2Struct dataBlock2Struct = dataBlock2StructArray[i];
            if (dataBlock2Struct.exteriorDependencyGroupIndex == -1) continue;
            dependencyBlockUnionArray = cursorBlock.getDependencyGroups()[dataBlock2Struct.exteriorDependencyGroupIndex];
            for (int j = 0; j < dependencyBlockUnionArray.length; ++j) {
                DependencyBlockUnion dependencyBlockUnion = dependencyBlockUnionArray[j];
                if (dependencyBlockUnion.discriminator() != 1) continue;
                includedDependencyBlockStruct = dependencyBlockUnion.includedDependencyBlock();
                valueCursorBlockStruct = cursorBlock.getValueCursorBlocks()[includedDependencyBlockStruct.dependencyBlock.valueCursorBlockIndex];
                if (valueCursorBlockStruct.indexBlock.id == dataBlock2Struct.id) continue;
                this._idToExteriorDependentIdsTable[valueCursorBlockStruct.indexBlock.id].add(new Integer(dataBlock2Struct.id));
            }
        }
        CompoundCursorBlockStruct[] compoundCursorBlockStructArray = cursorBlock.getCompoundCursorBlocks();
        for (n = 0; n < compoundCursorBlockStructArray.length; ++n) {
            int n3;
            dependencyBlockUnionArray = compoundCursorBlockStructArray[n];
            DependencyBlockUnion[] dependencyBlockUnionArray2 = cursorBlock.getDependencyGroups()[dependencyBlockUnionArray.interiorDependencyGroupIndex];
            for (n3 = 0; n3 < dependencyBlockUnionArray2.length; ++n3) {
                includedDependencyBlockStruct = dependencyBlockUnionArray2[n3].includedDependencyBlock();
                valueCursorBlockStruct = cursorBlock.getValueCursorBlocks()[includedDependencyBlockStruct.dependencyBlock.valueCursorBlockIndex];
                this._idToExteriorDependentIdsTable[dependencyBlockUnionArray.indexBlock.id].addAll(this._idToExteriorDependentIdsTable[valueCursorBlockStruct.indexBlock.id]);
            }
            for (n3 = 0; n3 < dependencyBlockUnionArray2.length; ++n3) {
                includedDependencyBlockStruct = dependencyBlockUnionArray2[n3].includedDependencyBlock();
                valueCursorBlockStruct = cursorBlock.getValueCursorBlocks()[includedDependencyBlockStruct.dependencyBlock.valueCursorBlockIndex];
                Set set = this._idToExteriorDependentIdsTable[dependencyBlockUnionArray.indexBlock.id];
                Integer n4 = new Integer(valueCursorBlockStruct.indexBlock.id);
                set.remove(n4);
            }
        }
        this._idToHasBlockTable = new boolean[n2];
        for (n = 0; n < n2; ++n) {
            boolean bl = true;
            CompoundCursorBlockStruct compoundCursorBlockStruct = cursorBlock.getCompoundCursorBlock(n);
            if (compoundCursorBlockStruct == null) {
                ValueCursorBlockStruct valueCursorBlockStruct2 = cursorBlock.getValueCursorBlock(n);
                bl = valueCursorBlockStruct2 != null;
            }
            this._idToHasBlockTable[n] = bl;
        }
    }
}

