/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data;

import java.io.Serializable;
import java.util.Date;
import oracle.express.idl.ExpressOlapiDataCursorModule.CompoundCursorBlockStruct;
import oracle.express.idl.ExpressOlapiDataCursorModule.CursorBlock2Struct;
import oracle.express.idl.ExpressOlapiDataCursorModule.CursorBlockStruct;
import oracle.express.idl.ExpressOlapiDataCursorModule.CursorValue2Union;
import oracle.express.idl.ExpressOlapiDataCursorModule.CursorValueUnion;
import oracle.express.idl.ExpressOlapiDataCursorModule.CursorValues2Union;
import oracle.express.idl.ExpressOlapiDataCursorModule.CursorValuesUnion;
import oracle.express.idl.ExpressOlapiDataCursorModule.DataBlock2Struct;
import oracle.express.idl.ExpressOlapiDataCursorModule.DataBlockStruct;
import oracle.express.idl.ExpressOlapiDataCursorModule.DependencyBlockUnion;
import oracle.express.idl.ExpressOlapiDataCursorModule.IncludedDependencyBlockStruct;
import oracle.express.idl.ExpressOlapiDataCursorModule.ParentStartEndBlock2Union;
import oracle.express.idl.ExpressOlapiDataCursorModule.ParentStartEndBlockUnion;
import oracle.express.idl.ExpressOlapiDataCursorModule.ValueCursorBlockStruct;
import oracle.express.idl.ExpressOlapiModule.Data2SequenceUnion;
import oracle.express.idl.ExpressOlapiModule.Data2Union;
import oracle.express.idl.ExpressOlapiModule.DataSequenceUnion;
import oracle.express.idl.ExpressOlapiModule.DataUnion;
import oracle.express.olapi.data.CursorTreeManager;
import oracle.olapi.data.cursor.NoDataAvailableException;
import oracle.olapi.data.source.Parameter;

public final class CursorBlock {
    private CursorBlockStruct _cursorBlockStruct_old;
    private CursorValueUnion[] _paramValues_old;
    private CursorBlock2Struct _cursorBlockStruct;
    private ValueCursorBlockStruct[] _idToValueCursorBlockTable;
    private CompoundCursorBlockStruct[] _idToCompoundCursorBlockTable;
    private DataBlock2Struct[] _idToDataBlockTable;
    private ParentStartEndBlock2Union[] _idToParentStartBlockTable;
    private ParentStartEndBlock2Union[] _idToParentEndBlockTable;
    private int _idTableSize;
    private CursorValue2Union[] _paramValues;
    private boolean _initialized = false;

    public CursorBlock(CursorBlockStruct cursorBlockStruct, CursorValueUnion[] cursorValueUnionArray) {
        this._cursorBlockStruct_old = cursorBlockStruct;
        this._paramValues_old = cursorValueUnionArray;
        if (this._paramValues_old != null) {
            this._paramValues = new CursorValue2Union[this._paramValues_old.length];
            for (int i = 0; i < this._paramValues.length; ++i) {
                this._paramValues[i] = this.convert(this._paramValues_old[i]);
            }
        }
        this._idTableSize = 0;
        DataBlockStruct[] dataBlockStructArray = cursorBlockStruct.dataBlocks;
        for (int i = 0; i < dataBlockStructArray.length; ++i) {
            short s = dataBlockStructArray[i].id;
            if (s < this._idTableSize) continue;
            this._idTableSize = s + 1;
        }
        if (this._idTableSize > 0) {
            this.initializeLookupTables(false);
        }
    }

    public CursorBlock(CursorBlock2Struct cursorBlock2Struct, CursorValue2Union[] cursorValue2UnionArray) {
        this._cursorBlockStruct = cursorBlock2Struct;
        this._paramValues = cursorValue2UnionArray;
        this._idTableSize = 0;
        DataBlock2Struct[] dataBlock2StructArray = cursorBlock2Struct.dataBlocks;
        for (int i = 0; i < dataBlock2StructArray.length; ++i) {
            short s = dataBlock2StructArray[i].id;
            if (s < this._idTableSize) continue;
            this._idTableSize = s + 1;
        }
        if (this._idTableSize > 0) {
            this.initializeLookupTables(true);
        }
    }

    private DataBlock2Struct convert(DataBlockStruct dataBlockStruct) {
        DataBlock2Struct dataBlock2Struct = new DataBlock2Struct();
        dataBlock2Struct.id = dataBlockStruct.id;
        CursorValuesUnion cursorValuesUnion = dataBlockStruct.values;
        CursorValues2Union cursorValues2Union = new CursorValues2Union();
        switch (cursorValuesUnion.discriminator()) {
            case 0: {
                DataSequenceUnion dataSequenceUnion = cursorValuesUnion.literals();
                Data2SequenceUnion data2SequenceUnion = new Data2SequenceUnion();
                switch (dataSequenceUnion.discriminator()) {
                    case 0: {
                        data2SequenceUnion.shortValues(dataSequenceUnion.shortValues());
                        break;
                    }
                    case 1: {
                        data2SequenceUnion.longValues(dataSequenceUnion.longValues());
                        break;
                    }
                    case 2: {
                        data2SequenceUnion.longlongValues(dataSequenceUnion.longlongValues());
                        break;
                    }
                    case 3: {
                        data2SequenceUnion.floatValues(dataSequenceUnion.floatValues());
                        break;
                    }
                    case 4: {
                        data2SequenceUnion.doubleValues(dataSequenceUnion.doubleValues());
                        break;
                    }
                    case 5: {
                        data2SequenceUnion.wstringValues(dataSequenceUnion.wstringValues());
                        break;
                    }
                    case 6: {
                        data2SequenceUnion.booleanValues(dataSequenceUnion.booleanValues());
                        break;
                    }
                    case 7: {
                        int[] nArray = dataSequenceUnion.dateValues();
                        Date[] dateArray = new Date[nArray.length];
                        for (int i = 0; i < nArray.length; ++i) {
                            dateArray[i] = new Date((long)nArray[i] * 1000L);
                        }
                        data2SequenceUnion.dateValues(dateArray);
                        break;
                    }
                    case 8: {
                        DataUnion[] dataUnionArray = dataSequenceUnion.dataUnionValues();
                        Data2Union[] data2UnionArray = new Data2Union[dataUnionArray.length];
                        block27: for (int i = 0; i < dataUnionArray.length; ++i) {
                            data2UnionArray[i] = new Data2Union();
                            switch (dataUnionArray[i].discriminator()) {
                                case 0: {
                                    data2UnionArray[i].shortValue(dataUnionArray[i].shortValue());
                                    continue block27;
                                }
                                case 1: {
                                    data2UnionArray[i].longValue(dataUnionArray[i].longValue());
                                    continue block27;
                                }
                                case 2: {
                                    data2UnionArray[i].longlongValue(dataUnionArray[i].longlongValue());
                                    continue block27;
                                }
                                case 3: {
                                    data2UnionArray[i].floatValue(dataUnionArray[i].floatValue());
                                    continue block27;
                                }
                                case 4: {
                                    data2UnionArray[i].doubleValue(dataUnionArray[i].doubleValue());
                                    continue block27;
                                }
                                case 5: {
                                    data2UnionArray[i].wstringValue(dataUnionArray[i].wstringValue());
                                    continue block27;
                                }
                                case 6: {
                                    data2UnionArray[i].booleanValue(dataUnionArray[i].booleanValue());
                                    continue block27;
                                }
                                case 7: {
                                    data2UnionArray[i].dateValue(new Date(dataUnionArray[i].dateValue() * 1000));
                                }
                            }
                        }
                        data2SequenceUnion.dataUnionValues(data2UnionArray);
                    }
                }
                cursorValues2Union.literals(data2SequenceUnion);
                break;
            }
            case 1: {
                cursorValues2Union.transientSourceIds(cursorValuesUnion.transientSourceIds());
                break;
            }
            case 2: {
                cursorValues2Union.persistentSourceIds(cursorValuesUnion.persistentSourceIds());
            }
        }
        dataBlock2Struct.values = cursorValues2Union;
        dataBlock2Struct.naMask = dataBlockStruct.naMask;
        dataBlock2Struct.exteriorDependencyGroupIndex = dataBlockStruct.exteriorDependencyGroupIndex;
        return dataBlock2Struct;
    }

    private CursorValue2Union convert(CursorValueUnion cursorValueUnion) {
        CursorValue2Union cursorValue2Union = new CursorValue2Union();
        switch (cursorValueUnion.discriminator()) {
            case 0: {
                DataUnion dataUnion = cursorValueUnion.literal();
                Data2Union data2Union = new Data2Union();
                switch (dataUnion.discriminator()) {
                    case 0: {
                        data2Union.shortValue(dataUnion.shortValue());
                        break;
                    }
                    case 1: {
                        data2Union.longValue(dataUnion.longValue());
                        break;
                    }
                    case 2: {
                        data2Union.longlongValue(dataUnion.longlongValue());
                        break;
                    }
                    case 3: {
                        data2Union.floatValue(dataUnion.floatValue());
                        break;
                    }
                    case 4: {
                        data2Union.doubleValue(dataUnion.doubleValue());
                        break;
                    }
                    case 5: {
                        data2Union.wstringValue(dataUnion.wstringValue());
                        break;
                    }
                    case 6: {
                        data2Union.booleanValue(dataUnion.booleanValue());
                        break;
                    }
                    case 7: {
                        data2Union.dateValue(new Date((long)dataUnion.dateValue() * 1000L));
                    }
                }
                cursorValue2Union.literal(data2Union);
                break;
            }
            case 1: {
                cursorValue2Union.transientSourceId(cursorValueUnion.transientSourceId());
                break;
            }
            case 2: {
                cursorValue2Union.persistentSourceId(cursorValueUnion.persistentSourceId());
            }
        }
        return cursorValue2Union;
    }

    private void initializeLookupTables(boolean bl) {
        Object object;
        Serializable serializable;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        DataBlock2Struct[] dataBlock2StructArray;
        CompoundCursorBlockStruct[] compoundCursorBlockStructArray;
        int n;
        this._initialized = true;
        if (!bl) {
            this._cursorBlockStruct = new CursorBlock2Struct();
            this._cursorBlockStruct.valueCursorBlocks = this._cursorBlockStruct_old.valueCursorBlocks;
            this._cursorBlockStruct.compoundCursorBlocks = this._cursorBlockStruct_old.compoundCursorBlocks;
            this._cursorBlockStruct.dependencyGroups = this._cursorBlockStruct_old.dependencyGroups;
        }
        this._idToValueCursorBlockTable = new ValueCursorBlockStruct[this._idTableSize];
        ValueCursorBlockStruct[] valueCursorBlockStructArray = this._cursorBlockStruct.valueCursorBlocks;
        for (n = 0; n < valueCursorBlockStructArray.length; ++n) {
            this._idToValueCursorBlockTable[compoundCursorBlockStructArray.indexBlock.id] = compoundCursorBlockStructArray = valueCursorBlockStructArray[n];
        }
        this._idToCompoundCursorBlockTable = new CompoundCursorBlockStruct[this._idTableSize];
        compoundCursorBlockStructArray = this._cursorBlockStruct.compoundCursorBlocks;
        for (n = 0; n < compoundCursorBlockStructArray.length; ++n) {
            dataBlock2StructArray = compoundCursorBlockStructArray[n];
            this._idToCompoundCursorBlockTable[dataBlock2StructArray.indexBlock.id] = dataBlock2StructArray;
        }
        this._idToDataBlockTable = new DataBlock2Struct[this._idTableSize];
        if (bl) {
            dataBlock2StructArray = this._cursorBlockStruct.dataBlocks;
        } else {
            object5 = this._cursorBlockStruct_old.dataBlocks;
            dataBlock2StructArray = new DataBlock2Struct[((DataBlockStruct[])object5).length];
            for (n = 0; n < dataBlock2StructArray.length; ++n) {
                dataBlock2StructArray[n] = this.convert(object5[n]);
            }
            this._cursorBlockStruct.dataBlocks = dataBlock2StructArray;
        }
        for (n = 0; n < dataBlock2StructArray.length; ++n) {
            this._idToDataBlockTable[object5.id] = object5 = dataBlock2StructArray[n];
        }
        this._idToParentStartBlockTable = new ParentStartEndBlock2Union[this._idTableSize];
        if (bl) {
            object5 = this._cursorBlockStruct.parentStartBlocks;
        } else {
            object4 = this._cursorBlockStruct_old.parentStartBlocks;
            object5 = new ParentStartEndBlock2Union[((ParentStartEndBlockUnion[])object4).length];
            for (n = 0; n < ((DataBlockStruct[])object5).length; ++n) {
                object3 = object4[n];
                object2 = new ParentStartEndBlock2Union();
                switch (((ParentStartEndBlockUnion)object3).discriminator()) {
                    case 0: {
                        serializable = this.convert(((ParentStartEndBlockUnion)object3).dataBlock());
                        ((ParentStartEndBlock2Union)object2).dataBlock((DataBlock2Struct)serializable);
                        break;
                    }
                    case 1: {
                        ((ParentStartEndBlock2Union)object2).multiplierBlock(((ParentStartEndBlockUnion)object3).multiplierBlock());
                    }
                }
                object5[n] = object2;
            }
        }
        block21: for (n = 0; n < ((DataBlockStruct[])object5).length; ++n) {
            object4 = object5[n];
            switch (((ParentStartEndBlock2Union)object4).discriminator()) {
                case 0: {
                    this._idToParentStartBlockTable[((ParentStartEndBlock2Union)object4).dataBlock().id] = object4;
                    continue block21;
                }
                case 1: {
                    this._idToParentStartBlockTable[((ParentStartEndBlock2Union)object4).multiplierBlock().id] = object4;
                }
            }
        }
        this._idToParentEndBlockTable = new ParentStartEndBlock2Union[this._idTableSize];
        if (bl) {
            object4 = this._cursorBlockStruct.parentEndBlocks;
        } else {
            object3 = this._cursorBlockStruct_old.parentEndBlocks;
            object4 = new ParentStartEndBlock2Union[((ParentStartEndBlockUnion[])object3).length];
            for (n = 0; n < ((Object)object4).length; ++n) {
                object2 = object3[n];
                serializable = new ParentStartEndBlock2Union();
                switch (((ParentStartEndBlockUnion)object2).discriminator()) {
                    case 0: {
                        object = this.convert(((ParentStartEndBlockUnion)object2).dataBlock());
                        ((ParentStartEndBlock2Union)serializable).dataBlock((DataBlock2Struct)object);
                        break;
                    }
                    case 1: {
                        ((ParentStartEndBlock2Union)serializable).multiplierBlock(((ParentStartEndBlockUnion)object2).multiplierBlock());
                    }
                }
                object4[n] = serializable;
            }
        }
        block23: for (n = 0; n < ((Object)object4).length; ++n) {
            object3 = object4[n];
            switch (((ParentStartEndBlock2Union)object3).discriminator()) {
                case 0: {
                    this._idToParentEndBlockTable[((ParentStartEndBlock2Union)object3).dataBlock().id] = object3;
                    continue block23;
                }
                case 1: {
                    this._idToParentEndBlockTable[((ParentStartEndBlock2Union)object3).multiplierBlock().id] = object3;
                }
            }
        }
        object3 = this._cursorBlockStruct.dependencyGroups;
        for (n = 0; n < ((Object)object3).length; ++n) {
            object2 = object3[n];
            for (int i = 0; i < ((Object)object2).length; ++i) {
                int n2;
                object = object2[i];
                if (((DependencyBlockUnion)object).discriminator() != 1) continue;
                IncludedDependencyBlockStruct includedDependencyBlockStruct = ((DependencyBlockUnion)object2[i]).includedDependencyBlock();
                ValueCursorBlockStruct valueCursorBlockStruct = this.getValueCursorBlocks()[includedDependencyBlockStruct.dependencyBlock.valueCursorBlockIndex];
                int[] nArray = new int[valueCursorBlockStruct.indexBlock.physicalExtents.length];
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    nArray[n2] = n2;
                }
                includedDependencyBlockStruct.spans = nArray;
                n2 = i;
                while (n2 >= 0) {
                    IncludedDependencyBlockStruct includedDependencyBlockStruct2 = ((DependencyBlockUnion)object2[n2]).includedDependencyBlock();
                    ValueCursorBlockStruct valueCursorBlockStruct2 = this.getValueCursorBlocks()[includedDependencyBlockStruct2.dependencyBlock.valueCursorBlockIndex];
                    for (int j = 0; j < nArray.length; ++j) {
                        nArray[j] = valueCursorBlockStruct2.indexBlock.physicalExtents[nArray[j]];
                    }
                    n2 = includedDependencyBlockStruct2.dependencyBlock.dependentIndex;
                }
            }
        }
    }

    public final ValueCursorBlockStruct getValueCursorBlock(int n) {
        if (this.isInitialized()) {
            return this._idToValueCursorBlockTable[n];
        }
        throw new NoDataAvailableException();
    }

    public final ValueCursorBlockStruct[] getValueCursorBlocks() {
        return this._cursorBlockStruct.valueCursorBlocks;
    }

    public final CompoundCursorBlockStruct getCompoundCursorBlock(int n) {
        if (this.isInitialized()) {
            return this._idToCompoundCursorBlockTable[n];
        }
        throw new NoDataAvailableException();
    }

    public final CompoundCursorBlockStruct[] getCompoundCursorBlocks() {
        return this._cursorBlockStruct.compoundCursorBlocks;
    }

    public final DataBlock2Struct getDataBlock(int n) {
        if (this.isInitialized()) {
            return this._idToDataBlockTable[n];
        }
        throw new NoDataAvailableException();
    }

    public final DataBlock2Struct[] getDataBlocks() {
        return this._cursorBlockStruct.dataBlocks;
    }

    public final ParentStartEndBlock2Union getParentStartBlock(int n) {
        if (this.isInitialized()) {
            return this._idToParentStartBlockTable[n];
        }
        throw new NoDataAvailableException();
    }

    public final ParentStartEndBlock2Union getParentEndBlock(int n) {
        if (this.isInitialized()) {
            return this._idToParentEndBlockTable[n];
        }
        throw new NoDataAvailableException();
    }

    public final DependencyBlockUnion[][] getDependencyGroups() {
        return this._cursorBlockStruct.dependencyGroups;
    }

    public final int getIdTableSize() {
        return this._idTableSize;
    }

    public final boolean isEmpty() {
        return this.getIdTableSize() == 0;
    }

    public final boolean matchesParameterValues(CursorTreeManager cursorTreeManager, Parameter[] parameterArray) {
        if (parameterArray == null && this._paramValues == null || parameterArray == null && 0 == this._paramValues.length) {
            return true;
        }
        if (parameterArray.length != this._paramValues.length) {
            return false;
        }
        try {
            for (int i = 0; i < parameterArray.length; ++i) {
                if (CursorBlock.isEqual(cursorTreeManager, parameterArray[i], this._paramValues[i])) continue;
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return true;
    }

    private static boolean isEqual(CursorTreeManager cursorTreeManager, Parameter parameter, CursorValue2Union cursorValue2Union) {
        Data2Union data2Union = cursorValue2Union.literal();
        Object object = CursorTreeManager.getParameterValueObject(cursorTreeManager, parameter);
        switch (data2Union.discriminator()) {
            case 0: {
                return ((Short)object).shortValue() == data2Union.shortValue();
            }
            case 1: {
                return ((Integer)object).intValue() == data2Union.longValue();
            }
            case 2: {
                return ((Long)object).longValue() == data2Union.longlongValue();
            }
            case 3: {
                return ((Float)object).floatValue() == data2Union.floatValue();
            }
            case 4: {
                return ((Double)object).doubleValue() == data2Union.doubleValue();
            }
            case 5: {
                return (String)object == data2Union.wstringValue();
            }
            case 6: {
                return ((Boolean)object).booleanValue() == data2Union.booleanValue();
            }
            case 7: {
                return ((Date)object).getTime() == data2Union.dateValue().getTime();
            }
        }
        return false;
    }

    private boolean isInitialized() {
        return this._initialized;
    }
}

