/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.mdm;

import java.util.HashMap;
import java.util.Map;
import oracle.express.mdm.MdmAttribute;
import oracle.express.mdm.MdmDimensionMemberType;
import oracle.express.mdm.MdmLevel;
import oracle.express.mdm.MdmLevelHierarchy;
import oracle.express.mdm.MdmListDimension;
import oracle.express.mdm.MdmMeasure;
import oracle.express.mdm.MdmMeasureMemberType;
import oracle.express.mdm.MdmMetadataProvider;
import oracle.express.mdm.MdmObject;
import oracle.express.mdm.MdmSchema;
import oracle.express.mdm.MdmStandardMemberType;
import oracle.express.mdm.MdmTimeMemberType;
import oracle.express.mdm.MdmUnionHierarchy;
import oracle.express.mdm.MdmValueHierarchy;
import oracle.olapi.metadata.mdm.MdmDimension;
import oracle.olapi.metadata.mdm.MdmMeasureDimension;
import oracle.olapi.metadata.mdm.MdmObjectVisitor;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmStandardDimension;
import oracle.olapi.metadata.mdm.MdmTimeDimension;

final class MdmObjectConverter
implements MdmObjectVisitor {
    private Map m_ConversionMap = new HashMap();
    private MdmMetadataProvider m_MdmMetadataProvider = null;

    MdmObjectConverter(MdmMetadataProvider mdmMetadataProvider) {
        this.m_MdmMetadataProvider = mdmMetadataProvider;
    }

    Map getConversionMap() {
        return this.m_ConversionMap;
    }

    MdmMetadataProvider getMdmMetadataProvider() {
        return this.m_MdmMetadataProvider;
    }

    MdmObject convertMdmObject(oracle.olapi.metadata.mdm.MdmObject mdmObject) {
        MdmObject mdmObject2 = (MdmObject)this.getConversionMap().get(mdmObject);
        if (null == mdmObject2) {
            mdmObject2 = (MdmObject)mdmObject.acceptVisitor(this, null);
            this.getConversionMap().put(mdmObject, mdmObject2);
        }
        return mdmObject2;
    }

    public Object visitMdmAttribute(oracle.olapi.metadata.mdm.MdmAttribute mdmAttribute, Object object) {
        return new MdmAttribute(mdmAttribute, this.getMdmMetadataProvider());
    }

    public Object visitMdmMeasure(oracle.olapi.metadata.mdm.MdmMeasure mdmMeasure, Object object) {
        return new MdmMeasure(mdmMeasure, this.getMdmMetadataProvider());
    }

    public Object visitMdmLevelHierarchy(oracle.olapi.metadata.mdm.MdmLevelHierarchy mdmLevelHierarchy, Object object) {
        MdmDimensionMemberType mdmDimensionMemberType = this.createMemberType(mdmLevelHierarchy);
        return new MdmLevelHierarchy(mdmLevelHierarchy, mdmDimensionMemberType, this.getMdmMetadataProvider());
    }

    public Object visitMdmValueHierarchy(oracle.olapi.metadata.mdm.MdmValueHierarchy mdmValueHierarchy, Object object) {
        MdmDimensionMemberType mdmDimensionMemberType = this.createMemberType(mdmValueHierarchy);
        return new MdmValueHierarchy(mdmValueHierarchy, mdmDimensionMemberType, this.getMdmMetadataProvider());
    }

    public Object visitMdmLevel(oracle.olapi.metadata.mdm.MdmLevel mdmLevel, Object object) {
        MdmDimensionMemberType mdmDimensionMemberType = this.createMemberType(mdmLevel);
        return new MdmLevel(mdmLevel, mdmDimensionMemberType, this.getMdmMetadataProvider());
    }

    public Object visitMdmMeasureDimension(MdmMeasureDimension mdmMeasureDimension, Object object) {
        MdmMeasureMemberType mdmMeasureMemberType = new MdmMeasureMemberType();
        return new MdmListDimension(mdmMeasureDimension, mdmMeasureMemberType, this.getMdmMetadataProvider());
    }

    public Object visitMdmStandardDimension(MdmStandardDimension mdmStandardDimension, Object object) {
        MdmStandardMemberType mdmStandardMemberType = new MdmStandardMemberType();
        if (mdmStandardDimension.is92ListDimension()) {
            return new MdmListDimension(mdmStandardDimension, mdmStandardMemberType, this.getMdmMetadataProvider());
        }
        return new MdmUnionHierarchy(mdmStandardDimension, mdmStandardMemberType, this.getMdmMetadataProvider());
    }

    public Object visitMdmTimeDimension(MdmTimeDimension mdmTimeDimension, Object object) {
        MdmTimeMemberType mdmTimeMemberType = new MdmTimeMemberType();
        if (mdmTimeDimension.is92ListDimension()) {
            return new MdmListDimension(mdmTimeDimension, mdmTimeMemberType, this.getMdmMetadataProvider());
        }
        return new MdmUnionHierarchy(mdmTimeDimension, mdmTimeMemberType, this.getMdmMetadataProvider());
    }

    public Object visitMdmSchema(oracle.olapi.metadata.mdm.MdmSchema mdmSchema, Object object) {
        return new MdmSchema(mdmSchema, this.getMdmMetadataProvider());
    }

    private MdmDimensionMemberType createMemberType(MdmDimension mdmDimension) {
        Object var2_2 = null;
        MdmPrimaryDimension mdmPrimaryDimension = mdmDimension.getPrimaryDimension();
        if (mdmPrimaryDimension instanceof MdmStandardDimension) {
            return new MdmStandardMemberType();
        }
        if (mdmPrimaryDimension instanceof MdmTimeDimension) {
            return new MdmTimeMemberType();
        }
        return new MdmMeasureMemberType();
    }
}

