/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.idl.util;

import java.math.BigDecimal;
import oracle.express.idl.util.InterfaceStub;
import oracle.express.idl.util.OlapiException;
import oracle.express.idl.util.OlapiStreamable;
import oracle.express.idl.util.OlapiTracer;
import oracle.sql.NUMBER;

public class LongHelper {
    private LongHelper() {
    }

    public static long SQL2Java(InterfaceStub interfaceStub, BigDecimal bigDecimal) {
        long l = bigDecimal.longValue();
        OlapiTracer.log("LongHelper.SQL2Java: sqllong = " + bigDecimal + ", jlong = " + l);
        return l;
    }

    public static BigDecimal Java2SQL(InterfaceStub interfaceStub, long l) {
        OlapiTracer.enter("LongHelper.Java2SQL");
        OlapiTracer.log("jlong = " + l);
        BigDecimal bigDecimal = null;
        try {
            bigDecimal = NUMBER.toBigDecimal((byte[])NUMBER.toBytes((long)l));
            OlapiTracer.log("sqllong = " + bigDecimal);
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("LongHelper.Java2SQL");
        return bigDecimal;
    }

    public static long SQL2Java(InterfaceStub interfaceStub, OlapiStreamable olapiStreamable) {
        OlapiTracer.enter("LongHelper.SQL2Java");
        long l = 0L;
        try {
            byte[] byArray = new byte[olapiStreamable.read()];
            byte by = (byte)olapiStreamable.read();
            olapiStreamable.read(byArray);
            if (1 == by) {
                byArray[0] = (byte)(byArray[0] | 0x80);
            }
            l = NUMBER.toLong((byte[])byArray);
            OlapiTracer.log("jlong = " + l);
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("LongHelper.SQL2Java");
        return l;
    }

    public static void Java2SQL(InterfaceStub interfaceStub, OlapiStreamable olapiStreamable, long l) {
        OlapiTracer.enter("LongHelper.Java2SQL");
        OlapiTracer.log("jlong = " + l);
        try {
            byte[] byArray = NUMBER.toBytes((long)l);
            olapiStreamable.write(byArray.length);
            if (byArray[0] >= 0) {
                olapiStreamable.write(0);
            } else {
                olapiStreamable.write(1);
                byArray[0] = (byte)(byArray[0] & 0x7F);
            }
            olapiStreamable.write(byArray);
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("LongHelper.Java2SQL");
    }

    public static long SQL2Java92010(BigDecimal bigDecimal) {
        return LongHelper.SQL2Java(null, bigDecimal);
    }

    public static BigDecimal Java2SQL92010(long l) {
        return LongHelper.Java2SQL(null, l);
    }
}

