/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.idl.util;

import oracle.express.idl.util.InterfaceStub;
import oracle.express.idl.util.OlapiException;
import oracle.express.idl.util.OlapiStreamable;
import oracle.express.idl.util.OlapiTracer;
import oracle.sql.NUMBER;

public class IntegerHelper {
    private IntegerHelper() {
    }

    public static int SQL2Java(InterfaceStub interfaceStub, Integer n) {
        int n2 = n;
        OlapiTracer.log("IntegerHelper.SQL2Java: sqlint = " + n + ", jint = " + n2);
        return n2;
    }

    public static Integer Java2SQL(InterfaceStub interfaceStub, int n) {
        Integer n2 = new Integer(n);
        OlapiTracer.log("IntegerHelper.Java2SQL: jint = " + n + ", sqlint = " + n2);
        return n2;
    }

    public static int SQL2Java(InterfaceStub interfaceStub, OlapiStreamable olapiStreamable) {
        OlapiTracer.enter("IntegerHelper.SQL2Java");
        int n = 0;
        try {
            byte[] byArray = new byte[olapiStreamable.read()];
            byte by = (byte)olapiStreamable.read();
            olapiStreamable.read(byArray);
            if (1 == by) {
                byArray[0] = (byte)(byArray[0] | 0x80);
            }
            n = NUMBER.toInt((byte[])byArray);
            OlapiTracer.log("jint = " + n);
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("IntegerHelper.SQL2Java");
        return n;
    }

    public static void Java2SQL(InterfaceStub interfaceStub, OlapiStreamable olapiStreamable, int n) {
        OlapiTracer.enter("IntegerHelper.Java2SQL");
        OlapiTracer.log("jint = " + n);
        try {
            byte[] byArray = NUMBER.toBytes((int)n);
            olapiStreamable.write(byArray.length);
            if (byArray[0] >= 0) {
                olapiStreamable.write(0);
            } else {
                olapiStreamable.write(1);
                byArray[0] = (byte)(byArray[0] & 0x7F);
            }
            olapiStreamable.write(byArray);
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("IntegerHelper.Java2SQL");
    }

    public static int SQL2Java92010(Integer n) {
        return IntegerHelper.SQL2Java(null, n);
    }

    public static Integer Java2SQL92010(int n) {
        return IntegerHelper.Java2SQL(null, n);
    }
}

