/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.idl.util;

import java.sql.Timestamp;
import java.util.Date;
import oracle.express.idl.util.InterfaceStub;
import oracle.express.idl.util.LongHelper;
import oracle.express.idl.util.OlapiException;
import oracle.express.idl.util.OlapiStreamable;
import oracle.express.idl.util.OlapiTracer;

public class DateHelper {
    private DateHelper() {
    }

    public static Date SQL2Java(InterfaceStub interfaceStub, Timestamp timestamp) {
        Timestamp timestamp2 = timestamp;
        OlapiTracer.log("DateHelper.SQL2Java: sqldate = " + timestamp + ", jdate = " + timestamp2);
        return timestamp2;
    }

    public static Timestamp Java2SQL(InterfaceStub interfaceStub, Date date) {
        Timestamp timestamp = new Timestamp(date.getTime());
        OlapiTracer.log("DateHelper.Java2SQL: jdate = " + date + ", sqldate = " + timestamp);
        return timestamp;
    }

    public static Date SQL2Java(InterfaceStub interfaceStub, OlapiStreamable olapiStreamable) {
        OlapiTracer.enter("DateHelper.SQL2Java");
        Date date = null;
        try {
            date = new Date(LongHelper.SQL2Java(interfaceStub, olapiStreamable) * 1000L);
            OlapiTracer.log("jdate = " + date);
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("DateHelper.SQL2Java");
        return date;
    }

    public static void Java2SQL(InterfaceStub interfaceStub, OlapiStreamable olapiStreamable, Date date) {
        OlapiTracer.enter("DateHelper.Java2SQL");
        OlapiTracer.log("jdate = " + date);
        try {
            LongHelper.Java2SQL(interfaceStub, olapiStreamable, date.getTime() / 1000L);
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("DateHelper.Java2SQL");
    }
}

