/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.aw;

import oracle.express.aw.AWHelper;
import oracle.express.aw.AWMetadataLookup;
import oracle.express.olapi.data.full.ExpressDataProvider;
import oracle.express.spl.NAValueException;
import oracle.olapi.metadata.mdm.MdmLevel;
import oracle.olapi.metadata.mdm.MdmLevelHierarchy;
import oracle.olapi.metadata.mtm.MtmInvalidMetadataException;

public class AWHelperCF
extends AWHelper {
    private ExpressDataProvider dp = null;

    public AWHelperCF(AWMetadataLookup aWMetadataLookup) {
        super(aWMetadataLookup);
        this.dp = aWMetadataLookup.getDataProvider();
    }

    public String getHierarchyName(MdmLevelHierarchy mdmLevelHierarchy) {
        String string = mdmLevelHierarchy.getID();
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return "";
        }
        String string2 = string.substring(n + 1);
        return string2;
    }

    public String getLevelName(MdmLevel mdmLevel) throws MtmInvalidMetadataException {
        MdmLevelHierarchy mdmLevelHierarchy = mdmLevel.getLevelHierarchy();
        int n = this.findLevelPosition(mdmLevel);
        if (n < 0) {
            return null;
        }
        String string = this.getAWName(mdmLevelHierarchy);
        String string2 = this.getHierarchyName(mdmLevelHierarchy);
        String string3 = this.evaluateDMLFunction("__AWG.GETLEVELPOS", new String[]{this.quote(string), this.quote(string2), Integer.toString(n)});
        return string3;
    }

    public String getFamilyRelation(MdmLevelHierarchy mdmLevelHierarchy) throws MtmInvalidMetadataException {
        String string = this.getAWName(mdmLevelHierarchy);
        return this.evaluateDMLFunctionWithQuotedArgument("__AWG.GETFAMILYREL", string);
    }

    public String getHierarchyDimension(MdmLevelHierarchy mdmLevelHierarchy) throws MtmInvalidMetadataException {
        String string = this.getAWName(mdmLevelHierarchy);
        return this.evaluateDMLFunctionWithQuotedArgument("__AWG.GETHIERDIM", string);
    }

    public String getLevelDimension(MdmLevelHierarchy mdmLevelHierarchy) throws MtmInvalidMetadataException {
        String string = this.getAWName(mdmLevelHierarchy);
        return this.evaluateDMLFunctionWithQuotedArgument("__AWG.GETLEVELDIM", string);
    }

    public String getLevelRelation(MdmLevelHierarchy mdmLevelHierarchy) throws MtmInvalidMetadataException {
        String string = this.getAWName(mdmLevelHierarchy);
        return this.evaluateDMLFunctionWithQuotedArgument("__AWG.GETLEVELREL", string);
    }

    public String getParentRelation(MdmLevelHierarchy mdmLevelHierarchy) throws MtmInvalidMetadataException {
        String string = this.getAWName(mdmLevelHierarchy);
        return this.evaluateDMLFunctionWithQuotedArgument("__AWG.GETPARENTREL", string);
    }

    public String getTimeSpan(MdmLevelHierarchy mdmLevelHierarchy) throws MtmInvalidMetadataException {
        String string = this.getAWName(mdmLevelHierarchy);
        return this.evaluateDMLFunctionWithQuotedArgument("__AWG.GETTIMESPAN", string);
    }

    public String getEnddate(MdmLevelHierarchy mdmLevelHierarchy) throws MtmInvalidMetadataException {
        String string = this.getAWName(mdmLevelHierarchy);
        return this.evaluateDMLFunctionWithQuotedArgument("__AWG.GETENDDATE", string);
    }

    protected boolean initialize() {
        boolean bl = false;
        try {
            if (this.dp.isServerVersionLaterThan(new int[]{9, 2, 0, 3}) && !this.dp.isServerVersionLaterThan(new int[]{9, 2, 0, 6})) {
                bl = true;
            } else if (this.dp.isServerVersionLaterThan(new int[]{10, 1, 0, 2}) && !this.dp.isServerVersionLaterThan(new int[]{10, 1, 1})) {
                bl = true;
            }
            if (!bl) {
                return false;
            }
            this.spl.executeCommand("BADLINE=YES");
            this.defineObject("__AWG.SAVED.DIMVAL", "INT");
            this.defineProgram("__AWG.ATTACH", "", new String[]{"ARG _AW TEXT", "IF NOT AW(ATTACHED _AW)", "THEN AW ATTACH &_AW RO"});
            this.defineProgram("__AWG.STOREVAL", "", new String[]{"ARG _DIMVAL INT", "__AWG.SAVED.DIMVAL = _DIMVAL", "return NA"});
            this.defineProgram("__AWG.GETROLE", "TEXT", new String[]{"ARG _NAME TEXT", "ARG _ROLE TEXT", "RETURN BLANKSTRIP(LIMIT(NAME TO OBJ(PRP 'AW$PARENT_NAME') eq _NAME AND OBJ(PRP 'AW$ROLE') eq _ROLE) BOTH)"});
            this.defineProgram("__AWG.GETATTR", "TEXT", new String[]{"ARG _NAME TEXT", "ARG _ATTR TEXT", "RETURN BLANKSTRIP(LIMIT(NAME TO OBJ(PRP 'AW$PARENT_NAME') eq _NAME AND OBJ(PRP 'AW$ROLE') eq 'ATTRDEF' AND OBJ(PRP 'AW$TYPE') eq _ATTR) BOTH)"});
            this.defineProgram("__AWG.GETLEVELREL", "TEXT", new String[]{"ARG _NAME TEXT", "RETURN NAFILL(__AWG.GETROLE(_NAME, 'MEMBER_LEVELREL') '')"});
            this.defineProgram("__AWG.GETLEVELDIM", "TEXT", new String[]{"ARG _NAME TEXT", "VRB _REL TEXT", "_REL = __AWG.GETLEVELREL(_NAME)", "RETURN IF _REL EQ '' THEN '' ELSE OBJ(DATA _REL)"});
            this.defineProgram("__AWG.GETHIERDIM", "TEXT", new String[]{"ARG _NAME TEXT", "RETURN NAFILL(__AWG.GETROLE(_NAME, 'HIERLIST') '')"});
            this.defineProgram("__AWG.GETENDDATE", "TEXT", new String[]{"ARG _NAME TEXT", "VRB _VALUE TEXT", "_VALUE = NAFILL(__AWG.GETATTR(_NAME, 'END_DATE'), '')", "IF _VALUE EQ ''", "THEN RETURN NAFILL(__AWG.GETATTR(_NAME, 'End Date'), '')", "RETURN _VALUE"});
            this.defineProgram("__AWG.GETTIMESPAN", "TEXT", new String[]{"ARG _NAME TEXT", "VRB _VALUE TEXT", "_VALUE = NAFILL(__AWG.GETATTR(_NAME, 'TIME_SPAN'), '')", "IF _VALUE EQ ''", "THEN RETURN NAFILL(__AWG.GETATTR(_NAME, 'Time Span'), '')", "RETURN _VALUE"});
            this.defineProgram("__AWG.GETFAMILYREL", "TEXT", new String[]{"ARG _NAME TEXT", "RETURN NAFILL(__AWG.GETROLE(_NAME, 'MEMBER_FAMILYREL') '')"});
            this.defineProgram("__AWG.GETPARENTREL", "TEXT", new String[]{"ARG _NAME TEXT", "RETURN NAFILL(__AWG.GETROLE(_NAME, 'MEMBER_PARENTREL') '')"});
            this.defineProgram("__AWG.GETLEVELPOS", "TEXT", new String[]{"ARG _DIMENSION TEXT", "ARG _HIERARCHY TEXT", "ARG _N INT", "VRB _LEVELVS TEXT", "VRB _HIERDIM TEXT", "TRAP ON ERROR NOPRINT", "_LEVELVS = __AWG.GETROLE(_DIMENSION, 'HIER_LEVELS')", "_HIERDIM = __AWG.GETHIERDIM(_DIMENSION)", "IF _LEVELVS EQ NA OR _HIERDIM EQ ''", "THEN RETURN ''", "TEMPSTAT &_HIERDIM", "DO", "  LIMIT &_HIERDIM TO _HIERARCHY", "  RETURN STATVAL(_LEVELVS STATLEN(_LEVELVS)-_N)", "DOEND", "ERROR:", "RETURN ''"});
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    protected void defineProgram(String string, String string2, String[] stringArray) {
        this.defineObject(string, (string2 != null ? string2 : "") + " PROGRAM");
        this.defineBlock("PROGRAM", stringArray);
    }

    protected void defineObject(String string, String string2) {
        try {
            if (this.spl.evaluateBooleanExpression("exists('" + string + "') eq FALSE")) {
                this.spl.executeCommand("DEFINE " + string + " " + string2 + " AW EXPRESS");
            }
        }
        catch (NAValueException nAValueException) {
            // empty catch block
        }
    }

    protected void defineBlock(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(400);
        stringBuffer.append(string);
        if (stringArray != null && stringArray.length > 0) {
            stringBuffer.append(" JOINLINES(-\n");
            for (int i = 0; i < stringArray.length; ++i) {
                this.appendQuotedLine(stringBuffer, stringArray[i]);
            }
            stringBuffer.append(")");
        }
        this.spl.executeCommand(stringBuffer.toString());
    }

    protected void appendQuotedLine(StringBuffer stringBuffer, String string) {
        stringBuffer.append("'");
        int n = -1;
        int n2 = 0;
        while ((n2 = string.indexOf(39, ++n)) >= 0) {
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append("\\'");
            n = n2;
        }
        stringBuffer.append(string.substring(n));
        stringBuffer.append("'");
    }
}

