/*
 * Decompiled with CFR 0.152.
 */
package antlr.preprocessor;

import antlr.ANTLRException;
import antlr.TokenStreamException;
import antlr.Tool;
import antlr.collections.impl.IndexedVector;
import antlr.preprocessor.Grammar;
import antlr.preprocessor.GrammarFile;
import antlr.preprocessor.Option;
import antlr.preprocessor.Preprocessor;
import antlr.preprocessor.PreprocessorLexer;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hierarchy {
    protected Grammar LexerRoot = null;
    protected Grammar ParserRoot = null;
    protected Grammar TreeParserRoot = null;
    protected Hashtable symbols;
    protected Hashtable files;
    protected Tool antlrTool;

    public Hierarchy(Tool tool) {
        this.antlrTool = tool;
        this.LexerRoot = new Grammar(tool, "Lexer", null, null);
        this.ParserRoot = new Grammar(tool, "Parser", null, null);
        this.TreeParserRoot = new Grammar(tool, "TreeParser", null, null);
        this.symbols = new Hashtable(10);
        this.files = new Hashtable(10);
        this.LexerRoot.setPredefined(true);
        this.ParserRoot.setPredefined(true);
        this.TreeParserRoot.setPredefined(true);
        this.symbols.put(this.LexerRoot.getName(), this.LexerRoot);
        this.symbols.put(this.ParserRoot.getName(), this.ParserRoot);
        this.symbols.put(this.TreeParserRoot.getName(), this.TreeParserRoot);
    }

    public void addGrammar(Grammar grammar) {
        grammar.setHierarchy(this);
        this.symbols.put(grammar.getName(), grammar);
        GrammarFile grammarFile = this.getFile(grammar.getFileName());
        grammarFile.addGrammar(grammar);
    }

    public void addGrammarFile(GrammarFile grammarFile) {
        this.files.put(grammarFile.getName(), grammarFile);
    }

    public void expandGrammarsInFile(String string) {
        GrammarFile grammarFile = this.getFile(string);
        Enumeration enumeration = grammarFile.getGrammars().elements();
        while (enumeration.hasMoreElements()) {
            Grammar grammar = (Grammar)enumeration.nextElement();
            grammar.expandInPlace();
        }
        grammarFile.setMergedHeaderAction(this.mergedImportStatements(grammarFile));
    }

    private String mergedImportStatements(GrammarFile grammarFile) {
        String string = null;
        String string2 = "";
        Vector<String> vector = new Vector<String>();
        Object object = this.files.keys();
        while (object.hasMoreElements()) {
            string2 = (String)object.nextElement();
            this.getImportStatements(vector, ((GrammarFile)this.files.get(string2)).getHeaderAction());
        }
        object = grammarFile.getHeaderAction();
        if (object != null) {
            Object object2;
            int n = -1;
            Matcher matcher = Pattern.compile("([^//])import[\\p{Space}]([^;])+;").matcher((CharSequence)object);
            n = matcher.find() ? matcher.start() : (((Matcher)(object2 = Pattern.compile("package[\\p{Space}]([^;])+;").matcher((CharSequence)object))).find() ? ((Matcher)object2).end() : ((String)object).lastIndexOf("}"));
            object = ((String)object).replaceAll("([^//])import\\p{Space}([^;])+;", "");
            string = ((String)object).substring(0, n);
            for (String string3 : vector) {
                string = string + "\n" + string3;
            }
            string = string + "\n" + ((String)object).substring(n + 1);
        } else if (!vector.isEmpty()) {
            string = "header \n{\n";
            for (String string4 : vector) {
                string = string + "\n" + string4;
            }
            string = "\n}\n";
        }
        return string;
    }

    private void getImportStatements(Vector<String> vector, String string) {
        Pattern pattern = Pattern.compile("([^//])import\\p{Space}([^;])+;");
        Vector<String> vector2 = new Vector<String>();
        boolean bl = false;
        if (string == null) {
            return;
        }
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            bl = false;
            vector2.clear();
            String string2 = matcher.group();
            for (int i = 0; i < vector.size(); ++i) {
                String string3 = vector.get(i);
                if (!this.hasImportConflict(string3, string2)) continue;
                String string4 = string3.substring(string3.lastIndexOf(".") + 1, string3.length() - 1);
                String string5 = string2.substring(string2.lastIndexOf(".") + 1, string2.length() - 1);
                if (!string4.equals("*") && string5.equals("*")) {
                    vector2.add(string3);
                    if (!vector.contains(string2)) {
                        vector.add(string2);
                    }
                }
                bl = true;
            }
            vector.removeAll(vector2);
            if (bl) continue;
            vector.add(string2);
        }
    }

    private boolean hasImportConflict(String string, String string2) {
        int n = 0;
        if ((string = string.replaceAll("\\p{Space}", "").replace(";", "")).equals(string2 = string2.replaceAll("\\p{Space}", "").replace(";", ""))) {
            return true;
        }
        for (n = 0; n < string.length() && string2.length() > n && string.charAt(n) == string2.charAt(n); ++n) {
        }
        if (n == string2.length() && string.length() > n || n > string2.length() && string.length() == n) {
            return false;
        }
        String string3 = string.substring(n);
        String string4 = string2.substring(n);
        return string3.trim().equalsIgnoreCase("*") && string4.trim().indexOf(".") == -1 || string3.trim().indexOf(".") == -1 && string4.trim().equalsIgnoreCase("*");
    }

    public Grammar findRoot(Grammar grammar) {
        if (grammar.getSuperGrammarName() == null) {
            return grammar;
        }
        Grammar grammar2 = grammar.getSuperGrammar();
        if (grammar2 == null) {
            return grammar;
        }
        return this.findRoot(grammar2);
    }

    public GrammarFile getFile(String string) {
        return (GrammarFile)this.files.get(string);
    }

    public Grammar getGrammar(String string) {
        return (Grammar)this.symbols.get(string);
    }

    public static String optionsToString(IndexedVector indexedVector) {
        String string = "options {" + System.getProperty("line.separator");
        Enumeration enumeration = indexedVector.elements();
        while (enumeration.hasMoreElements()) {
            string = string + (Option)enumeration.nextElement() + System.getProperty("line.separator");
        }
        string = string + "}" + System.getProperty("line.separator") + System.getProperty("line.separator");
        return string;
    }

    public void readGrammarFile(String string) throws FileNotFoundException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        this.addGrammarFile(new GrammarFile(this.antlrTool, string));
        PreprocessorLexer preprocessorLexer = new PreprocessorLexer(bufferedReader);
        preprocessorLexer.setFilename(string);
        Preprocessor preprocessor = new Preprocessor(preprocessorLexer);
        preprocessor.setTool(this.antlrTool);
        preprocessor.setFilename(string);
        try {
            preprocessor.grammarFile(this, string, null);
        }
        catch (TokenStreamException tokenStreamException) {
            this.antlrTool.toolError("Token stream error reading grammar(s):\n" + tokenStreamException);
        }
        catch (ANTLRException aNTLRException) {
            this.antlrTool.toolError("error reading grammar(s):\n" + aNTLRException);
        }
    }

    public void readGrammarFile(Grammar grammar, String string) throws FileNotFoundException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        this.addGrammarFile(new GrammarFile(this.antlrTool, string));
        PreprocessorLexer preprocessorLexer = new PreprocessorLexer(bufferedReader);
        preprocessorLexer.setFilename(string);
        Preprocessor preprocessor = new Preprocessor(preprocessorLexer);
        preprocessor.setTool(this.antlrTool);
        preprocessor.setFilename(string);
        try {
            preprocessor.grammarFile(this, string, grammar);
        }
        catch (TokenStreamException tokenStreamException) {
            this.antlrTool.toolError("Token stream error reading grammar(s):\n" + tokenStreamException);
        }
        catch (ANTLRException aNTLRException) {
            this.antlrTool.toolError("error reading grammar(s):\n" + aNTLRException);
        }
    }

    public boolean verifyThatHierarchyIsComplete() {
        Grammar grammar;
        boolean bl = true;
        Enumeration enumeration = this.symbols.elements();
        while (enumeration.hasMoreElements()) {
            Grammar grammar2;
            grammar = (Grammar)enumeration.nextElement();
            if (grammar.getSuperGrammarName() == null || (grammar2 = grammar.getSuperGrammar()) != null) continue;
            this.antlrTool.toolError("grammar " + grammar.getSuperGrammarName() + " not defined");
            bl = false;
            this.symbols.remove(grammar.getName());
        }
        if (!bl) {
            return false;
        }
        enumeration = this.symbols.elements();
        while (enumeration.hasMoreElements()) {
            grammar = (Grammar)enumeration.nextElement();
            if (grammar.getSuperGrammarName() == null) continue;
            grammar.setType(this.findRoot(grammar).getName());
        }
        return true;
    }

    public Tool getTool() {
        return this.antlrTool;
    }

    public void setTool(Tool tool) {
        this.antlrTool = tool;
    }
}

