/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNMergeInfoInheritance;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaCombiner;
import org.tmatesoft.svn.core.internal.io.fs.FSCommitEditor;
import org.tmatesoft.svn.core.internal.io.fs.FSEntry;
import org.tmatesoft.svn.core.internal.io.fs.FSErrors;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSFileRevisionsFinder;
import org.tmatesoft.svn.core.internal.io.fs.FSHooks;
import org.tmatesoft.svn.core.internal.io.fs.FSLocationsFinder;
import org.tmatesoft.svn.core.internal.io.fs.FSLog;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTranslateReporter;
import org.tmatesoft.svn.core.internal.io.fs.FSUpdateContext;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNMergeInfoManager;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNFileRevisionHandler;
import org.tmatesoft.svn.core.io.ISVNLocationEntryHandler;
import org.tmatesoft.svn.core.io.ISVNLocationSegmentHandler;
import org.tmatesoft.svn.core.io.ISVNLockHandler;
import org.tmatesoft.svn.core.io.ISVNReplayHandler;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.ISVNSession;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import org.tmatesoft.svn.core.io.SVNCapability;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.util.SVNLogType;

public class FSRepository
extends SVNRepository
implements ISVNReporter {
    private File myReposRootDir;
    private FSUpdateContext myReporterContext;
    private FSLocationsFinder myLocationsFinder;
    private FSFS myFSFS;
    private SVNMergeInfoManager myMergeInfoManager;
    private FSLog myLogDriver;

    protected FSRepository(SVNURL location, ISVNSession options) {
        super(location, options);
    }

    public FSFS getFSFS() {
        return this.myFSFS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testConnection() throws SVNException {
        try {
            this.openRepository();
        }
        finally {
            this.closeRepository();
        }
    }

    public File getRepositoryRootDir() {
        return this.myReposRootDir;
    }

    public int getReposFormat() {
        return this.myFSFS.getReposFormat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLatestRevision() throws SVNException {
        try {
            this.openRepository();
            long l = this.myFSFS.getYoungestRevision();
            return l;
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getDatedRevision(Date date) throws SVNException {
        if (date == null) {
            return this.getLatestRevision();
        }
        try {
            this.openRepository();
            long l = this.myFSFS.getDatedRevision(date);
            return l;
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVNProperties getRevisionProperties(long revision, SVNProperties properties) throws SVNException {
        FSRepository.assertValidRevision(revision);
        try {
            this.openRepository();
            properties = properties == null ? new SVNProperties() : properties;
            properties.putAll(this.myFSFS.getRevisionProperties(revision));
        }
        finally {
            this.closeRepository();
        }
        return properties;
    }

    @Override
    public void setRevisionPropertyValue(long revision, String propertyName, SVNPropertyValue propertyValue) throws SVNException {
        this.setRevisionPropertyValue(revision, propertyName, propertyValue, false);
    }

    public void setRevisionPropertyValue(long revision, String propertyName, SVNPropertyValue propertyValue, boolean bypassHooks) throws SVNException {
        this.setRevisionPropertyValue(revision, propertyName, propertyValue, bypassHooks, bypassHooks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRevisionPropertyValue(long revision, String propertyName, SVNPropertyValue propertyValue, boolean bypassPreRevpropHook, boolean bypassPostRevpropHook) throws SVNException {
        FSRepository.assertValidRevision(revision);
        try {
            this.openRepository();
            FSRepositoryUtil.validateProperty(propertyName, propertyValue);
            String userName = this.getUserName();
            SVNProperties revProps = this.myFSFS.getRevisionProperties(revision);
            SVNPropertyValue oldValue = revProps.getSVNPropertyValue(propertyName);
            String action = null;
            action = propertyValue == null ? "D" : (oldValue == null ? "A" : "M");
            byte[] bytes = SVNPropertyValue.getPropertyAsBytes(propertyValue);
            if (FSHooks.isHooksEnabled() && !bypassPreRevpropHook) {
                FSHooks.runPreRevPropChangeHook(this.myReposRootDir, propertyName, bytes, userName, revision, action);
            }
            this.myFSFS.setRevisionProperty(revision, propertyName, propertyValue);
            if (FSHooks.isHooksEnabled() && !bypassPostRevpropHook) {
                FSHooks.runPostRevPropChangeHook(this.myReposRootDir, propertyName, bytes, userName, revision, action);
            }
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVNPropertyValue getRevisionPropertyValue(long revision, String propertyName) throws SVNException {
        FSRepository.assertValidRevision(revision);
        if (propertyName == null) {
            return null;
        }
        try {
            this.openRepository();
            SVNPropertyValue sVNPropertyValue = this.myFSFS.getRevisionProperties(revision).getSVNPropertyValue(propertyName);
            return sVNPropertyValue;
        }
        finally {
            this.closeRepository();
        }
    }

    @Override
    public SVNNodeKind checkPath(String path, long revision) throws SVNException {
        try {
            this.openRepository();
            if (!SVNRepository.isValidRevision(revision)) {
                revision = this.myFSFS.getYoungestRevision();
            }
            String repositoryPath = this.getRepositoryPath(path);
            FSRevisionRoot root = this.myFSFS.createRevisionRoot(revision);
            SVNNodeKind sVNNodeKind = root.checkNodeKind(repositoryPath);
            return sVNNodeKind;
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NOT_DIRECTORY) {
                SVNNodeKind sVNNodeKind = SVNNodeKind.NONE;
                return sVNNodeKind;
            }
            throw e;
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFile(String path, long revision, SVNProperties properties, OutputStream contents) throws SVNException {
        try {
            this.openRepository();
            if (!SVNRepository.isValidRevision(revision)) {
                revision = this.myFSFS.getYoungestRevision();
            }
            String repositoryPath = this.getRepositoryPath(path);
            FSRevisionRoot root = this.myFSFS.createRevisionRoot(revision);
            if (contents != null) {
                InputStream fileStream = null;
                try {
                    fileStream = root.getFileStreamForPath(new SVNDeltaCombiner(), repositoryPath);
                    FSRepositoryUtil.copy(fileStream, contents, this.getCanceller());
                }
                catch (Throwable throwable) {
                    SVNFileUtil.closeFile(fileStream);
                    throw throwable;
                }
                SVNFileUtil.closeFile(fileStream);
            }
            if (properties != null) {
                FSRevisionNode revNode = root.getRevisionNode(repositoryPath);
                if (revNode.getFileMD5Checksum() != null) {
                    properties.put("svn:entry:checksum", revNode.getFileMD5Checksum());
                }
                if (revision >= 0L) {
                    properties.put("svn:entry:revision", Long.toString(revision));
                }
                properties.putAll(this.collectProperties(revNode));
            }
            long l = revision;
            return l;
        }
        finally {
            this.closeRepository();
        }
    }

    @Override
    public long getDir(String path, long revision, SVNProperties properties, ISVNDirEntryHandler handler) throws SVNException {
        return this.getDir(path, revision, properties, -1, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVNDirEntry getDir(String path, long revision, boolean includeCommitMessages, Collection entries) throws SVNException {
        try {
            SVNDirEntry parentDirEntry;
            this.openRepository();
            if (!SVNRepository.isValidRevision(revision)) {
                revision = this.myFSFS.getYoungestRevision();
            }
            String repositoryPath = this.getRepositoryPath(path);
            SVNURL parentURL = this.getLocation().appendPath(path, false);
            FSRevisionRoot root = this.myFSFS.createRevisionRoot(revision);
            FSRevisionNode parent = root.getRevisionNode(repositoryPath);
            if (entries != null) {
                entries.addAll(this.getDirEntries(parent, parentURL, -1));
            }
            SVNDirEntry sVNDirEntry = parentDirEntry = this.buildDirEntry(new FSEntry(parent.getId(), parent.getType(), ""), parentURL, parent, -1);
            return sVNDirEntry;
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getDir(String path, long revision, SVNProperties properties, int entryFields, ISVNDirEntryHandler handler) throws SVNException {
        try {
            this.openRepository();
            if (!SVNRepository.isValidRevision(revision)) {
                revision = this.myFSFS.getYoungestRevision();
            }
            String repositoryPath = this.getRepositoryPath(path);
            FSRevisionRoot root = this.myFSFS.createRevisionRoot(revision);
            FSRevisionNode parent = root.getRevisionNode(repositoryPath);
            if (handler != null) {
                SVNURL parentURL = this.getLocation().appendPath(path, false);
                Collection entriesCollection = this.getDirEntries(parent, parentURL, entryFields);
                for (SVNDirEntry entry : entriesCollection) {
                    handler.handleDirEntry(entry);
                }
            }
            if (properties != null) {
                properties.putAll(this.collectProperties(parent));
            }
            long l = revision;
            return l;
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int getFileRevisionsImpl(String path, long startRevision, long endRevision, boolean includeMergedRevisions, ISVNFileRevisionHandler handler) throws SVNException {
        try {
            int fileRevsNumber;
            this.openRepository();
            path = this.getRepositoryPath(path);
            long latestRevision = -1L;
            if (FSRepository.isInvalidRevision(startRevision)) {
                startRevision = latestRevision = this.myFSFS.getYoungestRevision();
            }
            if (FSRepository.isInvalidRevision(endRevision)) {
                if (FSRepository.isInvalidRevision(latestRevision)) {
                    latestRevision = this.myFSFS.getYoungestRevision();
                }
                endRevision = latestRevision;
            }
            FSFileRevisionsFinder finder = new FSFileRevisionsFinder(this.myFSFS);
            int n = fileRevsNumber = finder.getFileRevisions(path, startRevision, endRevision, includeMergedRevisions, handler);
            return n;
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long logImpl(String[] targetPaths, long startRevision, long endRevision, boolean discoverChangedPaths, boolean strictNode, long limit, boolean includeMergedRevisions, String[] revPropNames, ISVNLogEntryHandler handler) throws SVNException {
        try {
            boolean isDescendingOrder;
            SVNErrorMessage err;
            this.openRepository();
            if (targetPaths == null || targetPaths.length == 0) {
                targetPaths = new String[]{"/"};
            }
            String[] absPaths = new String[targetPaths.length];
            for (int i = 0; i < targetPaths.length; ++i) {
                absPaths[i] = this.getRepositoryPath(targetPaths[i]);
            }
            long youngestRev = this.myFSFS.getYoungestRevision();
            if (FSRepository.isInvalidRevision(startRevision)) {
                startRevision = youngestRev;
            }
            if (FSRepository.isInvalidRevision(endRevision)) {
                endRevision = youngestRev;
            }
            long histStart = startRevision;
            long histEnd = endRevision;
            if (startRevision > youngestRev) {
                err = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "No such revision {0}", new Long(startRevision));
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            if (endRevision > youngestRev) {
                err = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "No such revision {0}", new Long(endRevision));
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            boolean bl = isDescendingOrder = startRevision >= endRevision;
            if (isDescendingOrder) {
                histStart = endRevision;
                histEnd = startRevision;
            }
            FSLog logDriver = this.getLogDriver(absPaths, limit, histStart, histEnd, isDescendingOrder, discoverChangedPaths, strictNode, includeMergedRevisions, revPropNames, handler);
            long l = logDriver.runLog();
            return l;
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int getLocationsImpl(String path, long pegRevision, long[] revisions, ISVNLocationEntryHandler handler) throws SVNException {
        FSRepository.assertValidRevision(pegRevision);
        for (int i = 0; i < revisions.length; ++i) {
            FSRepository.assertValidRevision(revisions[i]);
        }
        try {
            this.openRepository();
            path = this.getRepositoryPath(path);
            FSLocationsFinder locationsFinder = this.getLocationsFinder();
            int n = locationsFinder.traceNodeLocations(path, pegRevision, revisions, handler);
            return n;
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long getLocationSegmentsImpl(String path, long pegRevision, long startRevision, long endRevision, ISVNLocationSegmentHandler handler) throws SVNException {
        try {
            this.openRepository();
            path = this.getRepositoryPath(path);
            FSLocationsFinder locationsFinder = this.getLocationsFinder();
            long l = locationsFinder.getNodeLocationSegments(path, pegRevision, startRevision, endRevision, handler);
            return l;
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replay(long lowRevision, long highRevision, boolean sendDeltas, ISVNEditor editor) throws SVNException {
        try {
            this.openRepository();
            FSRevisionRoot root = this.myFSFS.createRevisionRoot(highRevision);
            String basePath = this.getRepositoryPath("");
            FSRepositoryUtil.replay(this.myFSFS, root, basePath, lowRevision, sendDeltas, editor);
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVNDirEntry info(String path, long revision) throws SVNException {
        try {
            SVNDirEntry entry;
            FSRevisionRoot root;
            this.openRepository();
            path = this.getRepositoryPath(path);
            if (FSRepository.isInvalidRevision(revision)) {
                revision = this.myFSFS.getYoungestRevision();
            }
            if ((root = this.myFSFS.createRevisionRoot(revision)).checkNodeKind(path) == SVNNodeKind.NONE) {
                SVNDirEntry sVNDirEntry = null;
                return sVNDirEntry;
            }
            FSRevisionNode revNode = root.getRevisionNode(path);
            String fullPath = this.getFullPath(path);
            String parentFullPath = "/".equals(path) ? fullPath : SVNPathUtil.removeTail(fullPath);
            SVNURL url = this.getLocation().setPath(parentFullPath, false);
            String name = SVNPathUtil.tail(path);
            FSEntry fsEntry = new FSEntry(revNode.getId(), revNode.getType(), name);
            SVNDirEntry sVNDirEntry = entry = this.buildDirEntry(fsEntry, url, revNode, -1);
            return sVNDirEntry;
        }
        finally {
            this.closeRepository();
        }
    }

    @Override
    public ISVNEditor getCommitEditor(String logMessage, Map locks, boolean keepLocks, ISVNWorkspaceMediator mediator) throws SVNException {
        try {
            this.openRepository();
        }
        catch (SVNException svne) {
            this.closeRepository();
            throw svne;
        }
        String author = this.getUserName();
        FSCommitEditor commitEditor = new FSCommitEditor(this.getRepositoryPath(""), logMessage, author, locks, keepLocks, null, this.myFSFS, this);
        return commitEditor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVNLock getLock(String path) throws SVNException {
        try {
            SVNLock lock;
            this.openRepository();
            path = this.getRepositoryPath(path);
            SVNLock sVNLock = lock = this.myFSFS.getLockHelper(path, false);
            return sVNLock;
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVNLock[] getLocks(String path) throws SVNException {
        try {
            this.openRepository();
            path = this.getRepositoryPath(path);
            File digestFile = this.myFSFS.getDigestFileFromRepositoryPath(path);
            final ArrayList locks = new ArrayList();
            ISVNLockHandler handler = new ISVNLockHandler(){

                @Override
                public void handleLock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
                    locks.add(lock);
                }

                @Override
                public void handleUnlock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
                }
            };
            this.myFSFS.walkDigestFiles(digestFile, handler, false);
            SVNLock[] sVNLockArray = locks.toArray(new SVNLock[locks.size()]);
            return sVNLockArray;
        }
        finally {
            this.closeRepository();
        }
    }

    @Override
    public void lock(Map pathsToRevisions, String comment, boolean force, ISVNLockHandler handler) throws SVNException {
        this.lock(pathsToRevisions, comment, force, false, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Map pathsToRevisions, String comment, boolean force, boolean isDAVComment, ISVNLockHandler handler) throws SVNException {
        try {
            this.openRepository();
            for (String path : pathsToRevisions.keySet()) {
                SVNErrorMessage error;
                SVNLock lock;
                String reposPath;
                block6: {
                    Long revision = (Long)pathsToRevisions.get(path);
                    reposPath = this.getRepositoryPath(path);
                    long curRevision = revision == null || FSRepository.isInvalidRevision(revision) ? this.myFSFS.getYoungestRevision() : revision.longValue();
                    lock = null;
                    error = null;
                    try {
                        lock = this.myFSFS.lockPath(reposPath, null, this.getUserName(), comment, null, curRevision, force, isDAVComment);
                    }
                    catch (SVNException svne) {
                        error = svne.getErrorMessage();
                        if (FSErrors.isLockError(error)) break block6;
                        throw svne;
                    }
                }
                if (handler == null) continue;
                handler.handleLock(reposPath, lock, error);
            }
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(Map pathToTokens, boolean force, ISVNLockHandler handler) throws SVNException {
        try {
            this.openRepository();
            for (String path : pathToTokens.keySet()) {
                SVNErrorMessage error;
                String reposPath;
                String token;
                block6: {
                    token = (String)pathToTokens.get(path);
                    reposPath = this.getRepositoryPath(path);
                    error = null;
                    try {
                        this.myFSFS.unlockPath(reposPath, token, this.getUserName(), force, true);
                    }
                    catch (SVNException svne) {
                        error = svne.getErrorMessage();
                        if (FSErrors.isUnlockError(error)) break block6;
                        throw svne;
                    }
                }
                if (handler == null) continue;
                handler.handleUnlock(reposPath, new SVNLock(reposPath, token, null, null, null, null), error);
            }
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishReport() throws SVNException {
        try {
            this.myReporterContext.drive();
        }
        finally {
            this.myReporterContext.dispose();
        }
    }

    @Override
    public void abortReport() throws SVNException {
        if (this.myReporterContext != null) {
            this.myReporterContext.dispose();
        }
    }

    @Override
    public void closeSession() {
    }

    public static boolean isInvalidRevision(long revision) {
        return SVNRepository.isInvalidRevision(revision);
    }

    public static boolean isValidRevision(long revision) {
        return SVNRepository.isValidRevision(revision);
    }

    @Override
    public void setPath(String path, String lockToken, long revision, boolean startEmpty) throws SVNException {
        this.setPath(path, lockToken, revision, SVNDepth.INFINITY, startEmpty);
    }

    @Override
    public void deletePath(String path) throws SVNException {
        this.myReporterContext.writePathInfoToReportFile(path, null, null, -1L, false, SVNDepth.INFINITY);
    }

    @Override
    public void linkPath(SVNURL url, String path, String lockToken, long revision, boolean startEmpty) throws SVNException {
        this.linkPath(url, path, lockToken, revision, SVNDepth.INFINITY, startEmpty);
    }

    @Override
    public void linkPath(SVNURL url, String path, String lockToken, long revision, SVNDepth depth, boolean startEmpty) throws SVNException {
        String reposLinkPath;
        FSRepository.assertValidRevision(revision);
        if (depth == SVNDepth.EXCLUDE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.REPOS_BAD_ARGS, "Depth 'exclude' not supported for link");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        SVNURL reposRootURL = this.getRepositoryRoot(false);
        if (url.toDecodedString().indexOf(reposRootURL.toDecodedString()) == -1) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "''{0}''\nis not the same repository as\n''{1}''", new Object[]{url, reposRootURL});
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if ("".equals(reposLinkPath = url.toDecodedString().substring(reposRootURL.toDecodedString().length()))) {
            reposLinkPath = "/";
        }
        this.myReporterContext.writePathInfoToReportFile(path, reposLinkPath, lockToken, revision, startEmpty, depth);
    }

    @Override
    public void setPath(String path, String lockToken, long revision, SVNDepth depth, boolean startEmpty) throws SVNException {
        FSRepository.assertValidRevision(revision);
        this.myReporterContext.writePathInfoToReportFile(path, null, lockToken, revision, startEmpty, depth);
    }

    public FSTranslateReporter beginReport(long revision, SVNURL url, String target, boolean ignoreAncestry, boolean sendTextDeltas, boolean sendCopyFromArgs, SVNDepth depth, ISVNEditor editor) throws SVNException {
        this.openRepository();
        this.makeReporterContext(revision, target, url, depth, ignoreAncestry, sendTextDeltas, sendCopyFromArgs, editor);
        return new FSTranslateReporter(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(long revision, String target, SVNDepth depth, boolean sendCopyFromArgs, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        try {
            this.openRepository();
            this.makeReporterContext(revision, target, null, depth, false, true, sendCopyFromArgs, editor);
            reporter.report(this);
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(SVNURL url, long revision, String target, SVNDepth depth, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        try {
            this.openRepository();
            this.makeReporterContext(revision, target, url, depth, true, true, false, editor);
            reporter.report(this);
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void diff(SVNURL url, long targetRevision, long revision, String target, boolean ignoreAncestry, SVNDepth depth, boolean getContents, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        try {
            this.openRepository();
            this.makeReporterContext(targetRevision, target, url, depth, ignoreAncestry, getContents, false, editor);
            reporter.report(this);
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void status(long revision, String target, SVNDepth depth, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        try {
            this.openRepository();
            this.makeReporterContext(revision, target, null, depth, false, false, false, editor);
            reporter.report(this);
        }
        finally {
            this.closeRepository();
        }
    }

    @Override
    public boolean hasCapability(SVNCapability capability) throws SVNException {
        if (capability == SVNCapability.DEPTH || capability == SVNCapability.LOG_REVPROPS || capability == SVNCapability.PARTIAL_REPLAY || capability == SVNCapability.COMMIT_REVPROPS) {
            return true;
        }
        if (capability == SVNCapability.MERGE_INFO) {
            try {
                this.getMergeInfoImpl(new String[]{""}, 0L, SVNMergeInfoInheritance.EXPLICIT, false);
            }
            catch (SVNException svne) {
                SVNErrorCode code = svne.getErrorMessage().getErrorCode();
                if (code == SVNErrorCode.UNSUPPORTED_FEATURE) {
                    return false;
                }
                if (code == SVNErrorCode.FS_NOT_FOUND) {
                    return true;
                }
                throw svne;
            }
            return true;
        }
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN_CAPABILITY, "Don''t know anything about capability ''{0}''", capability);
        SVNErrorManager.error(err, SVNLogType.FSFS);
        return false;
    }

    void closeRepository() throws SVNException {
        if (this.myFSFS != null) {
            this.myFSFS.close();
        }
        this.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map getMergeInfoImpl(String[] paths, long revision, SVNMergeInfoInheritance inherit, boolean includeDescendants) throws SVNException {
        try {
            this.openRepository();
            if (!FSRepository.isValidRevision(revision)) {
                revision = this.myFSFS.getYoungestRevision();
            }
            FSRevisionRoot root = this.myFSFS.createRevisionRoot(revision);
            String[] absPaths = new String[paths.length];
            for (int i = 0; i < paths.length; ++i) {
                absPaths[i] = this.getRepositoryPath(paths[i]);
            }
            SVNMergeInfoManager mergeInfoManager = this.getMergeInfoManager();
            Map map = mergeInfoManager.getMergeInfo(absPaths, root, inherit, includeDescendants);
            return map;
        }
        finally {
            this.closeRepository();
        }
    }

    @Override
    protected ISVNEditor getCommitEditorInternal(Map locks, boolean keepLocks, SVNProperties revProps, ISVNWorkspaceMediator mediator) throws SVNException {
        try {
            this.openRepository();
        }
        catch (SVNException svne) {
            this.closeRepository();
            throw svne;
        }
        SVNProperties sVNProperties = revProps = revProps == null ? new SVNProperties() : revProps;
        if (!revProps.containsName("svn:author")) {
            revProps.put("svn:author", this.getUserName());
        }
        return new FSCommitEditor(this.getRepositoryPath(""), locks, keepLocks, null, this.myFSFS, this, revProps);
    }

    @Override
    protected void replayRangeImpl(long startRevision, long endRevision, long lowRevision, boolean sendDeltas, ISVNReplayHandler handler) throws SVNException {
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED);
        SVNErrorManager.error(err, SVNLogType.FSFS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long getDeletedRevisionImpl(String path, long pegRevision, long endRevision) throws SVNException {
        try {
            this.openRepository();
            long l = this.myFSFS.getDeletedRevision(path, pegRevision, endRevision);
            return l;
        }
        finally {
            this.closeRepository();
        }
    }

    private void openRepository() throws SVNException {
        try {
            this.openRepositoryRoot();
        }
        catch (SVNException svne) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_LOCAL_REPOS_OPEN_FAILED, "Unable to open repository ''{0}''", this.getLocation().toDecodedString());
            err.setChildErrorMessage(svne.getErrorMessage());
            SVNErrorManager.error(err.wrap("Unable to open an ra_local session to URL"), SVNLogType.FSFS);
        }
    }

    private void openRepositoryRoot() throws SVNException {
        String startPath;
        String rootPath;
        boolean hasCustomHostName;
        this.lock();
        String hostName = this.getLocation().getHost();
        boolean bl = hasCustomHostName = !"".equals(hostName) && !"localhost".equalsIgnoreCase(hostName);
        if (!SVNFileUtil.isWindows && hasCustomHostName) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "Local URL ''{0}'' contains unsupported hostname", this.getLocation().toDecodedString());
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if ((rootPath = FSFS.findRepositoryRoot(hasCustomHostName ? hostName : null, startPath = SVNEncodingUtil.uriDecode(this.getLocation().getURIEncodedPath()))) == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_LOCAL_REPOS_OPEN_FAILED, "Unable to open repository ''{0}''", this.getLocation().toDecodedString());
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        String dirPath = rootPath.replaceFirst("\\|", "\\:");
        this.myReposRootDir = hasCustomHostName ? new File("\\\\" + hostName, dirPath).getAbsoluteFile() : new File(dirPath).getAbsoluteFile();
        this.myFSFS = new FSFS(this.myReposRootDir);
        this.myFSFS.open();
        this.setRepositoryCredentials(this.myFSFS.getUUID(), this.getLocation().setPath(rootPath, false));
    }

    private Collection getDirEntries(FSRevisionNode parent, SVNURL parentURL, int entryFields) throws SVNException {
        Map entries = parent.getDirEntries(this.myFSFS);
        Set keys = entries.keySet();
        Iterator dirEntries = keys.iterator();
        LinkedList<SVNDirEntry> dirEntriesList = new LinkedList<SVNDirEntry>();
        while (dirEntries.hasNext()) {
            String name = (String)dirEntries.next();
            FSEntry repEntry = (FSEntry)entries.get(name);
            if (repEntry == null) continue;
            dirEntriesList.add(this.buildDirEntry(repEntry, parentURL, null, entryFields));
        }
        return dirEntriesList;
    }

    private SVNProperties collectProperties(FSRevisionNode revNode) throws SVNException {
        SVNProperties properties = new SVNProperties();
        SVNProperties versionedProps = revNode.getProperties(this.myFSFS);
        if (versionedProps != null && versionedProps.size() > 0) {
            properties.putAll(versionedProps);
        }
        SVNProperties metaprops = null;
        try {
            metaprops = this.myFSFS.compoundMetaProperties(revNode.getCreatedRevision());
        }
        catch (SVNException svne) {
            // empty catch block
        }
        if (metaprops != null && metaprops.size() > 0) {
            properties.putAll(metaprops);
        }
        return properties;
    }

    private SVNDirEntry buildDirEntry(FSEntry repEntry, SVNURL parentURL, FSRevisionNode entryNode, int entryFields) throws SVNException {
        entryNode = entryNode == null ? this.myFSFS.getRevisionNode(repEntry.getId()) : entryNode;
        SVNNodeKind kind = null;
        if ((entryFields & 1) != 0) {
            kind = repEntry.getType();
        }
        long size = 0L;
        if ((entryFields & 2) != 0 && entryNode.getType() == SVNNodeKind.FILE) {
            size = entryNode.getFileLength();
        }
        boolean hasProps = false;
        if ((entryFields & 4) != 0) {
            SVNProperties props = entryNode.getProperties(this.myFSFS);
            hasProps = props != null && props.size() > 0;
        }
        String lastAuthor = null;
        String log = null;
        Date lastCommitDate = null;
        long revision = -1L;
        if ((entryFields & 0x10) != 0 || (entryFields & 0x20) != 0 || (entryFields & 8) != 0 || (entryFields & 0x40) != 0) {
            revision = repEntry.getId().getRevision();
            SVNProperties revProps = this.myFSFS.getRevisionProperties(repEntry.getId().getRevision());
            if (revProps != null && revProps.size() > 0) {
                lastAuthor = revProps.getStringValue("svn:author");
                log = revProps.getStringValue("svn:log");
                String timeString = revProps.getStringValue("svn:date");
                lastCommitDate = timeString != null ? SVNDate.parseDateString(timeString) : null;
            }
        }
        SVNURL entryURL = parentURL.appendPath(repEntry.getName(), false);
        SVNDirEntry dirEntry = new SVNDirEntry(entryURL, this.getRepositoryRoot(false), repEntry.getName(), kind, size, hasProps, revision, lastCommitDate, lastAuthor, log);
        dirEntry.setRelativePath(repEntry.getName());
        return dirEntry;
    }

    private void makeReporterContext(long targetRevision, String target, SVNURL switchURL, SVNDepth depth, boolean ignoreAncestry, boolean textDeltas, boolean sendCopyFromArgs, ISVNEditor editor) throws SVNException {
        String fullTargetPath;
        if (depth == SVNDepth.EXCLUDE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.REPOS_BAD_ARGS, "Request depth 'exclude' not supported");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        String string = target = target == null ? "" : target;
        if (!FSRepository.isValidRevision(targetRevision)) {
            targetRevision = this.myFSFS.getYoungestRevision();
        }
        String switchPath = null;
        if (switchURL != null) {
            SVNURL reposRootURL = this.getRepositoryRoot(false);
            if (switchURL.toDecodedString().indexOf(reposRootURL.toDecodedString()) == -1) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "''{0}''\nis not the same repository as\n''{1}''", new Object[]{switchURL, this.getRepositoryRoot(false)});
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            if ("".equals(switchPath = switchURL.toDecodedString().substring(reposRootURL.toDecodedString().length()))) {
                switchPath = "/";
            }
        }
        String anchor = this.getRepositoryPath("");
        String string2 = fullTargetPath = switchPath != null ? switchPath : SVNPathUtil.getAbsolutePath(SVNPathUtil.append(anchor, target));
        if (this.myReporterContext == null) {
            this.myReporterContext = new FSUpdateContext(this, this.myFSFS, targetRevision, SVNFileUtil.createTempFile("report", ".tmp"), target, fullTargetPath, switchURL != null, depth, ignoreAncestry, textDeltas, sendCopyFromArgs, editor);
        } else {
            this.myReporterContext.reset(this, this.myFSFS, targetRevision, SVNFileUtil.createTempFile("report", ".tmp"), target, fullTargetPath, switchURL != null, depth, ignoreAncestry, textDeltas, sendCopyFromArgs, editor);
        }
    }

    private String getUserName() throws SVNException {
        if (this.getLocation().getUserInfo() != null && this.getLocation().getUserInfo().trim().length() > 0) {
            return this.getLocation().getUserInfo();
        }
        if (this.getAuthenticationManager() != null) {
            try {
                String realm = this.getRepositoryUUID(true);
                ISVNAuthenticationManager authManager = this.getAuthenticationManager();
                SVNAuthentication auth = authManager.getFirstAuthentication("svn.username", realm, this.getLocation());
                while (auth != null) {
                    String userName = auth.getUserName();
                    if (userName == null || "".equals(userName.trim())) {
                        userName = System.getProperty("user.name");
                    }
                    auth = new SVNUserNameAuthentication(userName, auth.isStorageAllowed(), this.getLocation(), false);
                    if (userName != null && !"".equals(userName.trim())) {
                        authManager.acknowledgeAuthentication(true, "svn.username", realm, null, auth);
                        return auth.getUserName();
                    }
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.AUTHN_CREDS_UNAVAILABLE, "Empty user name is not allowed");
                    authManager.acknowledgeAuthentication(false, "svn.username", realm, err, auth);
                    auth = authManager.getNextAuthentication("svn.username", realm, this.getLocation());
                }
                SVNErrorManager.cancel("Authentication cancelled", SVNLogType.FSFS);
            }
            catch (SVNCancelException e) {
                throw e;
            }
            catch (SVNAuthenticationException e) {
            }
            catch (SVNException e) {
                throw e;
            }
        }
        return System.getProperty("user.name");
    }

    private FSLocationsFinder getLocationsFinder() {
        if (this.myLocationsFinder == null) {
            this.myLocationsFinder = new FSLocationsFinder(this.getFSFS());
        } else {
            this.myLocationsFinder.reset(this.getFSFS());
        }
        return this.myLocationsFinder;
    }

    private SVNMergeInfoManager getMergeInfoManager() {
        if (this.myMergeInfoManager == null) {
            this.myMergeInfoManager = new SVNMergeInfoManager();
        }
        return this.myMergeInfoManager;
    }

    private FSLog getLogDriver(String[] absPaths, long limit, long histStart, long histEnd, boolean isDescendingOrder, boolean discoverChangedPaths, boolean strictNode, boolean includeMergedRevisions, String[] revPropNames, ISVNLogEntryHandler handler) {
        if (this.myLogDriver == null) {
            this.myLogDriver = new FSLog(this.myFSFS, absPaths, limit, histStart, histEnd, isDescendingOrder, discoverChangedPaths, strictNode, includeMergedRevisions, revPropNames, handler);
        } else {
            this.myLogDriver.reset(this.myFSFS, absPaths, limit, histStart, histEnd, isDescendingOrder, discoverChangedPaths, strictNode, includeMergedRevisions, revPropNames, handler);
        }
        return this.myLogDriver;
    }
}

