/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPAuthentication;
import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

class HTTPNegotiateAuthentication
extends HTTPAuthentication {
    private static volatile Boolean ourIsNegotiateSupported;
    private GSSManager myGSSManager = GSSManager.getInstance();
    private GSSContext myGSSContext;
    private Oid mySpnegoOid;
    private Subject mySubject;
    private byte[] myToken;
    private int myTokenLength;

    public HTTPNegotiateAuthentication(HTTPNegotiateAuthentication prevAuth) {
        if (prevAuth != null) {
            this.mySubject = prevAuth.mySubject;
        }
    }

    public HTTPNegotiateAuthentication() {
        this((HTTPNegotiateAuthentication)null);
    }

    public static synchronized boolean isSupported() {
        if (ourIsNegotiateSupported == null) {
            try {
                Oid spnegoOid = new Oid("1.3.6.1.5.5.2");
                ourIsNegotiateSupported = Arrays.asList(GSSManager.getInstance().getMechs()).contains(spnegoOid);
            }
            catch (GSSException gsse) {
                ourIsNegotiateSupported = Boolean.FALSE;
            }
        }
        return ourIsNegotiateSupported;
    }

    @Override
    public String getAuthenticationScheme() {
        return "Negotiate";
    }

    private String getServerPrincipalName() {
        return "HTTP@" + this.getChallengeParameter("host");
    }

    public void respondTo(String challenge) {
        if (challenge == null) {
            this.myToken = new byte[0];
            this.myTokenLength = 0;
        } else {
            this.myToken = new byte[(challenge.length() * 3 + 3) / 4];
            this.myTokenLength = SVNBase64.base64ToByteArray(new StringBuffer(challenge), this.myToken);
        }
    }

    private void initializeSubject() {
        if (this.mySubject != null) {
            return;
        }
        try {
            LoginContext ctx = new LoginContext("com.sun.security.jgss.krb5.initiate", new SVNKitCallbackHandler());
            ctx.login();
            this.mySubject = ctx.getSubject();
        }
        catch (LoginException loginException) {
            // empty catch block
        }
    }

    private void initializeContext() throws GSSException {
        if (this.mySpnegoOid == null) {
            this.mySpnegoOid = new Oid("1.3.6.1.5.5.2");
        }
        GSSName serverName = this.myGSSManager.createName(this.getServerPrincipalName(), GSSName.NT_HOSTBASED_SERVICE);
        this.myGSSContext = this.myGSSManager.createContext(serverName, this.mySpnegoOid, null, 0);
    }

    @Override
    public String authenticate() throws SVNException {
        if (!this.isStarted()) {
            this.initializeSubject();
        }
        PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

            public Object run() throws SVNException {
                byte[] outtoken;
                if (!HTTPNegotiateAuthentication.this.isStarted()) {
                    try {
                        HTTPNegotiateAuthentication.this.initializeContext();
                    }
                    catch (GSSException gsse) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Negotiate authentication failed: ''{0}''", gsse.getMajorString());
                        SVNErrorManager.error(err, SVNLogType.NETWORK);
                        return null;
                    }
                }
                try {
                    outtoken = HTTPNegotiateAuthentication.this.myGSSContext.initSecContext(HTTPNegotiateAuthentication.this.myToken, 0, HTTPNegotiateAuthentication.this.myTokenLength);
                }
                catch (GSSException gsse) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Negotiate authentication failed: ''{0}''", gsse.getMajorString());
                    SVNErrorManager.error(err, SVNLogType.NETWORK);
                    return null;
                }
                if (HTTPNegotiateAuthentication.this.myToken != null) {
                    return "Negotiate " + SVNBase64.byteArrayToBase64(outtoken);
                }
                return null;
            }
        };
        if (this.mySubject != null) {
            try {
                return (String)Subject.doAs(this.mySubject, action);
            }
            catch (PrivilegedActionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof SVNException) {
                    throw (SVNException)cause;
                }
                throw new RuntimeException(cause);
            }
        }
        try {
            return (String)action.run();
        }
        catch (Exception cause) {
            if (cause instanceof SVNException) {
                throw (SVNException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public boolean isStarted() {
        return this.myGSSContext != null;
    }

    public boolean needsLogin() {
        this.initializeSubject();
        return this.mySubject == null;
    }

    private class SVNKitCallbackHandler
    implements CallbackHandler {
        private SVNKitCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof NameCallback) {
                    ((NameCallback)callbacks[i]).setName(HTTPNegotiateAuthentication.this.getUserName());
                    continue;
                }
                if (!(callbacks[i] instanceof PasswordCallback)) continue;
                ((PasswordCallback)callbacks[i]).setPassword(HTTPNegotiateAuthentication.this.getPassword() == null ? null : HTTPNegotiateAuthentication.this.getPassword().toCharArray());
            }
        }
    }
}

