/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.text.ParseException;
import java.util.Collection;
import java.util.LinkedList;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPStatus;
import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.Attributes;

public class DAVProppatchHandler
extends BasicDAVHandler {
    private static final Collection NAMESPACES = new LinkedList();
    private StringBuffer myPropertyName;
    private StringBuffer myPropstatDescription;
    private StringBuffer myDescription;
    private boolean myPropstatContainsError;
    private boolean myResponseContainsError;
    private SVNErrorMessage myError;

    public static StringBuffer generatePropertyRequest(StringBuffer buffer, String name, SVNPropertyValue value) {
        SVNProperties props = new SVNProperties();
        props.put(name, value);
        return DAVProppatchHandler.generatePropertyRequest(buffer, props);
    }

    public static StringBuffer generatePropertyRequest(StringBuffer buffer, String name, byte[] value) {
        SVNProperties props = new SVNProperties();
        props.put(name, value);
        return DAVProppatchHandler.generatePropertyRequest(buffer, props);
    }

    public static StringBuffer generatePropertyRequest(StringBuffer xmlBuffer, SVNProperties properties) {
        SVNPropertyValue value;
        xmlBuffer = xmlBuffer == null ? new StringBuffer() : xmlBuffer;
        SVNXMLUtil.addXMLHeader(xmlBuffer);
        SVNXMLUtil.openNamespaceDeclarationTag("D", "propertyupdate", NAMESPACES, SVNXMLUtil.PREFIX_MAP, xmlBuffer);
        if (DAVProppatchHandler.hasNotNullValues(properties)) {
            SVNXMLUtil.openXMLTag("D", "set", 1, null, xmlBuffer);
            SVNXMLUtil.openXMLTag("D", "prop", 1, null, xmlBuffer);
            for (String name : properties.nameSet()) {
                value = properties.getSVNPropertyValue(name);
                if (value == null) continue;
                xmlBuffer = DAVProppatchHandler.appendProperty(xmlBuffer, name, value);
            }
            SVNXMLUtil.closeXMLTag("D", "prop", xmlBuffer);
            SVNXMLUtil.closeXMLTag("D", "set", xmlBuffer);
        }
        if (DAVProppatchHandler.hasNullValues(properties)) {
            SVNXMLUtil.openXMLTag("D", "remove", 1, null, xmlBuffer);
            SVNXMLUtil.openXMLTag("D", "prop", 1, null, xmlBuffer);
            for (String name : properties.nameSet()) {
                value = properties.getSVNPropertyValue(name);
                if (value != null) continue;
                xmlBuffer = DAVProppatchHandler.appendProperty(xmlBuffer, name, value);
            }
            SVNXMLUtil.closeXMLTag("D", "prop", xmlBuffer);
            SVNXMLUtil.closeXMLTag("D", "remove", xmlBuffer);
        }
        SVNXMLUtil.addXMLFooter("D", "propertyupdate", xmlBuffer);
        return xmlBuffer;
    }

    private static StringBuffer appendProperty(StringBuffer xmlBuffer, String name, SVNPropertyValue value) {
        String prefix = SVNProperty.isSVNProperty(name) ? "SS" : "SC";
        String tagName = SVNProperty.shortPropertyName(name);
        if (value == null) {
            return SVNXMLUtil.openXMLTag(prefix, tagName, 4, null, xmlBuffer);
        }
        SVNHashMap attrs = null;
        String stringValue = value.getString();
        boolean isXMLSafe = true;
        if (value.isBinary()) {
            CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
            decoder.onMalformedInput(CodingErrorAction.REPORT);
            decoder.onMalformedInput(CodingErrorAction.REPORT);
            try {
                stringValue = decoder.decode(ByteBuffer.wrap(value.getBytes())).toString();
            }
            catch (CharacterCodingException e) {
                isXMLSafe = false;
            }
        }
        if (stringValue != null) {
            isXMLSafe = SVNEncodingUtil.isXMLSafe(stringValue);
        }
        if (!isXMLSafe) {
            attrs = new SVNHashMap();
            String attrPrefix = (String)SVNXMLUtil.PREFIX_MAP.get("http://subversion.tigris.org/xmlns/dav/");
            attrs.put(attrPrefix + ":encoding", "base64");
            byte[] toDecode = null;
            if (stringValue != null) {
                try {
                    toDecode = stringValue.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    toDecode = stringValue.getBytes();
                }
            } else {
                toDecode = value.getBytes();
            }
            stringValue = SVNBase64.byteArrayToBase64(toDecode);
        }
        return SVNXMLUtil.openCDataTag(prefix, tagName, stringValue, attrs, xmlBuffer);
    }

    private static boolean hasNullValues(SVNProperties props) {
        if (props.isEmpty()) {
            return false;
        }
        return props.containsValue(null);
    }

    private static boolean hasNotNullValues(SVNProperties props) {
        if (props.isEmpty()) {
            return false;
        }
        if (!DAVProppatchHandler.hasNullValues(props)) {
            return true;
        }
        for (String propName : props.nameSet()) {
            if (props.getSVNPropertyValue(propName) == null) continue;
            return true;
        }
        return false;
    }

    public DAVProppatchHandler() {
        this.init();
    }

    public SVNErrorMessage getError() {
        return this.myError;
    }

    private StringBuffer getPropertyName() {
        if (this.myPropertyName == null) {
            this.myPropertyName = new StringBuffer();
        }
        return this.myPropertyName;
    }

    private StringBuffer getPropstatDescription() {
        if (this.myPropstatDescription == null) {
            this.myPropstatDescription = new StringBuffer();
        }
        return this.myPropstatDescription;
    }

    private StringBuffer getDescription() {
        if (this.myDescription == null) {
            this.myDescription = new StringBuffer();
        }
        return this.myDescription;
    }

    @Override
    protected void startElement(DAVElement parent, DAVElement element, Attributes attrs) throws SVNException {
        if (parent == DAVElement.PROP) {
            this.getPropertyName().setLength(0);
            if ("http://subversion.tigris.org/xmlns/dav/".equals(element.getNamespace())) {
                this.getPropertyName().append("svn:");
            } else if ("DAV:".equals(element.getNamespace())) {
                this.getPropertyName().append("DAV:");
            }
            this.getPropertyName().append(element.getName());
        } else if (element == DAVElement.PROPSTAT) {
            this.myPropstatContainsError = false;
        }
    }

    @Override
    protected void endElement(DAVElement parent, DAVElement element, StringBuffer cdata) throws SVNException {
        block14: {
            if (element == DAVElement.MULTISTATUS) {
                if (this.myResponseContainsError) {
                    String description = null;
                    description = this.getDescription().length() == 0 ? "The request response contained at least one error" : this.getDescription().toString();
                    this.myError = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, description);
                }
            } else if (element == DAVElement.RESPONSE_DESCRIPTION) {
                if (parent == DAVElement.PROPSTAT) {
                    this.getPropstatDescription().append(cdata);
                } else {
                    if (this.getDescription().length() != 0) {
                        this.getDescription().append('\n');
                    }
                    this.getDescription().append(cdata);
                }
            } else if (element == DAVElement.STATUS) {
                try {
                    HTTPStatus status = HTTPStatus.createHTTPStatus(cdata.toString());
                    if (parent != DAVElement.PROPSTAT) {
                        this.myResponseContainsError |= status.getCodeClass() != 2;
                        break block14;
                    }
                    this.myPropstatContainsError = status.getCodeClass() != 2;
                }
                catch (ParseException e) {
                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "The response contains a non-conforming HTTP status line"), SVNLogType.NETWORK);
                }
            } else if (element == DAVElement.PROPSTAT) {
                this.myResponseContainsError |= this.myPropstatContainsError;
                this.getDescription().append("Error setting property ");
                this.getDescription().append(this.getPropertyName());
                this.getDescription().append(":");
                this.getDescription().append(this.getPropstatDescription());
            }
        }
    }

    static {
        NAMESPACES.add("DAV:");
        NAMESPACES.add("http://subversion.tigris.org/xmlns/dav/");
        NAMESPACES.add("http://subversion.tigris.org/xmlns/svn/");
        NAMESPACES.add("http://subversion.tigris.org/xmlns/custom/");
    }
}

