/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Stack;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.dav.DAVBaselineInfo;
import org.tmatesoft.svn.core.internal.io.dav.DAVConnection;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.DAVProperties;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepository;
import org.tmatesoft.svn.core.internal.io.dav.DAVUtil;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVDeltaHandler;
import org.tmatesoft.svn.core.internal.io.dav.http.IHTTPConnectionFactory;
import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.core.internal.wc.IOExceptionWrapper;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DAVEditorHandler
extends BasicDAVDeltaHandler {
    protected static final DAVElement TARGET_REVISION = DAVElement.getElement("svn:", "target-revision");
    protected static final DAVElement UPDATE_REPORT = DAVElement.getElement("svn:", "update-report");
    protected static final DAVElement RESOURCE = DAVElement.getElement("svn:", "resource");
    protected static final DAVElement OPEN_DIRECTORY = DAVElement.getElement("svn:", "open-directory");
    protected static final DAVElement ADD_DIRECTORY = DAVElement.getElement("svn:", "add-directory");
    protected static final DAVElement ABSENT_DIRECTORY = DAVElement.getElement("svn:", "absent-directory");
    protected static final DAVElement OPEN_FILE = DAVElement.getElement("svn:", "open-file");
    protected static final DAVElement ADD_FILE = DAVElement.getElement("svn:", "add-file");
    protected static final DAVElement ABSENT_FILE = DAVElement.getElement("svn:", "absent-file");
    protected static final DAVElement DELETE_ENTRY = DAVElement.getElement("svn:", "delete-entry");
    protected static final DAVElement FETCH_PROPS = DAVElement.getElement("svn:", "fetch-props");
    protected static final DAVElement SET_PROP = DAVElement.getElement("svn:", "set-prop");
    protected static final DAVElement REMOVE_PROP = DAVElement.getElement("svn:", "remove-prop");
    protected static final DAVElement FETCH_FILE = DAVElement.getElement("svn:", "fetch-file");
    protected static final String REVISION_ATTR = "rev";
    protected static final String NAME_ATTR = "name";
    protected static final String ENCODING_ATTR = "encoding";
    protected static final String COPYFROM_REV_ATTR = "copyfrom-rev";
    protected static final String COPYFROM_PATH_ATTR = "copyfrom-path";
    protected static final String SEND_ALL_ATTR = "send-all";
    protected static final String BC_URL_ATTR = "bc-url";
    protected static final String BASE_CHECKSUM_ATTR = "base-checksum";
    protected static final String PATH_ATTR = "path";
    protected ISVNEditor myEditor;
    protected String myPath;
    protected String myPropertyName;
    protected boolean myIsDirectory;
    protected Stack myDirs;
    protected Map myLockTokens;
    protected DAVRepository myOwner;
    protected boolean myIsFetchContent;
    private String myChecksum;
    private String myEncoding;
    private ISVNDeltaConsumer myDeltaConsumer;
    private boolean myIsReceiveAll;
    private DAVConnection myConnection;
    private IHTTPConnectionFactory myConnectionFactory;
    private String myHref;
    private String myCurrentWCPath;
    private boolean myIsInResource;
    private boolean myIsFetchProps;
    private boolean myHasTarget;
    private Map myVersionURLs;

    public static StringBuffer generateEditorRequest(final DAVConnection connection, StringBuffer xmlBuffer, String url, long targetRevision, String target, String dstPath, SVNDepth depth, final Map lockTokens, boolean ignoreAncestry, boolean resourceWalk, boolean fetchContents, boolean sendCopyFromArgs, boolean sendAll, ISVNReporterBaton reporterBaton) throws SVNException {
        xmlBuffer = SVNXMLUtil.addXMLHeader(xmlBuffer);
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        SVNHashMap attrs = new SVNHashMap();
        attrs.put(SEND_ALL_ATTR, Boolean.toString(sendAll));
        SVNXMLUtil.openNamespaceDeclarationTag("S", "update-report", SVN_NAMESPACES_LIST, SVNXMLUtil.PREFIX_MAP, attrs, xmlBuffer, true);
        SVNXMLUtil.openCDataTag("S", "src-path", url, xmlBuffer);
        if (targetRevision >= 0L) {
            SVNXMLUtil.openCDataTag("S", "target-revision", String.valueOf(targetRevision), xmlBuffer);
        }
        if (target != null && !"".equals(target)) {
            SVNXMLUtil.openCDataTag("S", "update-target", target, xmlBuffer);
        }
        if (dstPath != null) {
            SVNXMLUtil.openCDataTag("S", "dst-path", dstPath, xmlBuffer);
        }
        if (depth == SVNDepth.FILES || depth == SVNDepth.EMPTY) {
            SVNXMLUtil.openCDataTag("S", "recursive", "no", xmlBuffer);
        }
        SVNXMLUtil.openCDataTag("S", "depth", SVNDepth.asString(depth), xmlBuffer);
        if (ignoreAncestry) {
            SVNXMLUtil.openCDataTag("S", "ignore-ancestry", "yes", xmlBuffer);
        }
        if (sendCopyFromArgs) {
            SVNXMLUtil.openCDataTag("S", "send-copyfrom-args", "yes", xmlBuffer);
        }
        if (resourceWalk) {
            SVNXMLUtil.openCDataTag("S", "resource-walk", "yes", xmlBuffer);
        }
        if (sendAll && !fetchContents) {
            SVNXMLUtil.openCDataTag("S", "text-deltas", "no", xmlBuffer);
        }
        final StringBuffer report = xmlBuffer;
        reporterBaton.report(new ISVNReporter(){

            @Override
            public void setPath(String path, String lockToken, long revision, boolean startEmpty) throws SVNException {
                this.setPath(path, lockToken, revision, SVNDepth.INFINITY, startEmpty);
            }

            @Override
            public void deletePath(String path) {
                SVNXMLUtil.openCDataTag("S", "missing", path, report);
            }

            @Override
            public void linkPath(SVNURL url, String path, String lockToken, long revision, boolean startEmpty) throws SVNException {
                this.linkPath(url, path, lockToken, revision, SVNDepth.INFINITY, startEmpty);
            }

            @Override
            public void finishReport() {
            }

            @Override
            public void linkPath(SVNURL url, String path, String lockToken, long revision, SVNDepth depth, boolean startEmpty) throws SVNException {
                SVNHashMap attrs = new SVNHashMap();
                attrs.put(DAVEditorHandler.REVISION_ATTR, String.valueOf(revision));
                attrs.put("depth", SVNDepth.asString(depth));
                if (lockToken != null) {
                    if (lockTokens != null) {
                        lockTokens.put(path, lockToken);
                    }
                    attrs.put("lock-token", lockToken);
                }
                if (startEmpty) {
                    attrs.put("start-empty", Boolean.TRUE.toString());
                }
                String linkedPath = url.getURIEncodedPath();
                DAVBaselineInfo info = DAVUtil.getBaselineInfo(connection, null, linkedPath, revision, false, false, null);
                linkedPath = SVNEncodingUtil.uriDecode(info.baselinePath);
                if (!linkedPath.startsWith("/")) {
                    linkedPath = "/" + linkedPath;
                }
                attrs.put("linkpath", linkedPath);
                SVNXMLUtil.openCDataTag("S", "entry", path, attrs, report);
            }

            @Override
            public void setPath(String path, String lockToken, long revision, SVNDepth depth, boolean startEmpty) throws SVNException {
                SVNHashMap attrs = new SVNHashMap();
                attrs.put(DAVEditorHandler.REVISION_ATTR, String.valueOf(revision));
                attrs.put("depth", SVNDepth.asString(depth));
                if (lockToken != null) {
                    if (lockTokens != null) {
                        lockTokens.put(path, lockToken);
                    }
                    attrs.put("lock-token", lockToken);
                }
                if (startEmpty) {
                    attrs.put("start-empty", Boolean.TRUE.toString());
                }
                SVNXMLUtil.openCDataTag("S", "entry", path, attrs, report);
            }

            @Override
            public void abortReport() throws SVNException {
            }
        });
        SVNXMLUtil.addXMLFooter("S", "update-report", xmlBuffer);
        return xmlBuffer;
    }

    public DAVEditorHandler(IHTTPConnectionFactory connectionFactory, DAVRepository owner, ISVNEditor editor, Map lockTokens, boolean fetchContent, boolean hasTarget) {
        this.myConnectionFactory = connectionFactory;
        this.myOwner = owner;
        this.myEditor = editor;
        this.myIsFetchContent = fetchContent;
        this.myHasTarget = hasTarget;
        this.myLockTokens = lockTokens;
        this.myDeltaConsumer = fetchContent ? editor : new ISVNDeltaConsumer(){

            @Override
            public void applyTextDelta(String path, String baseChecksum) throws SVNException {
                DAVEditorHandler.this.myEditor.applyTextDelta(path, baseChecksum);
            }

            @Override
            public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
                return null;
            }

            @Override
            public void textDeltaEnd(String path) throws SVNException {
                DAVEditorHandler.this.myEditor.textDeltaEnd(path);
            }
        };
        this.init();
        this.myDirs = new Stack();
        this.myVersionURLs = new SVNHashMap();
    }

    public void closeConnection() {
        if (this.myConnection != null) {
            this.myConnection.close();
            this.myConnection = null;
        }
    }

    @Override
    protected void startElement(DAVElement parent, DAVElement element, Attributes attrs) throws SVNException {
        if (element == UPDATE_REPORT) {
            String receiveAll = attrs.getValue(SEND_ALL_ATTR);
            if (receiveAll != null && Boolean.valueOf(receiveAll).booleanValue()) {
                this.myIsReceiveAll = true;
            }
        } else if (element == TARGET_REVISION) {
            long revision = -1L;
            try {
                revision = Long.parseLong(attrs.getValue(REVISION_ATTR));
            }
            catch (NumberFormatException nfe) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, nfe), SVNLogType.NETWORK);
            }
            this.myEditor.targetRevision(revision);
        } else if (element == ABSENT_DIRECTORY) {
            String name = attrs.getValue(NAME_ATTR);
            this.myEditor.absentDir(SVNPathUtil.append(this.myPath, name));
        } else if (element == ABSENT_FILE) {
            String name = attrs.getValue(NAME_ATTR);
            this.myEditor.absentFile(SVNPathUtil.append(this.myPath, name));
        } else if (element == OPEN_DIRECTORY) {
            String revAttr = attrs.getValue(REVISION_ATTR);
            if (revAttr == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing rev attr in open-directory element");
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
            long revision = -1L;
            try {
                revision = Long.parseLong(revAttr);
            }
            catch (NumberFormatException nfe) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, nfe), SVNLogType.NETWORK);
            }
            this.myIsDirectory = true;
            if (this.myPath == null) {
                this.myPath = "";
                this.myEditor.openRoot(revision);
            } else {
                String name = attrs.getValue(NAME_ATTR);
                if (name == null) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing name attr in open-directory element");
                    SVNErrorManager.error(err, SVNLogType.NETWORK);
                }
                this.myPath = SVNPathUtil.append(this.myPath, name);
                this.myEditor.openDir(this.myPath, revision);
            }
            DirInfo dirInfo = new DirInfo();
            this.myDirs.push(dirInfo);
        } else if (element == ADD_DIRECTORY) {
            this.myIsDirectory = true;
            String name = attrs.getValue(NAME_ATTR);
            if (name == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing name attr in add-directory element");
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
            String copyFromPath = attrs.getValue(COPYFROM_PATH_ATTR);
            long copyFromRev = -1L;
            if (copyFromPath != null) {
                String copyFromRevString = attrs.getValue(COPYFROM_REV_ATTR);
                if (copyFromRevString == null) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing copyfrom-rev attr in add-directory element");
                    SVNErrorManager.error(err, SVNLogType.NETWORK);
                }
                try {
                    copyFromRev = Long.parseLong(copyFromRevString);
                }
                catch (NumberFormatException nfe) {
                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, nfe), SVNLogType.NETWORK);
                }
            }
            this.myPath = SVNPathUtil.append(this.myPath, name);
            this.myEditor.addDir(this.myPath, copyFromPath, copyFromRev);
            DirInfo dirInfo = new DirInfo();
            this.myDirs.push(dirInfo);
            dirInfo.myIsFetchProps = true;
            String bcURL = attrs.getValue(BC_URL_ATTR);
            if (!this.myIsReceiveAll && bcURL != null) {
                DAVElement[] elements = null;
                SVNHashMap propsMap = new SVNHashMap();
                DAVUtil.getProperties(this.getConnection(), DAVUtil.getPathFromURL(bcURL), 0, null, elements, propsMap);
                if (!propsMap.isEmpty()) {
                    dirInfo.myChildren = new SVNHashMap();
                    for (DAVProperties props : propsMap.values()) {
                        SVNPropertyValue vcURL = props.getPropertyValue(DAVElement.CHECKED_IN);
                        if (vcURL == null) continue;
                        dirInfo.myChildren.put(vcURL.getString(), props);
                    }
                }
            }
        } else if (element == OPEN_FILE) {
            this.myIsDirectory = false;
            String revAttr = attrs.getValue(REVISION_ATTR);
            if (revAttr == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing rev attr in open-file element");
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
            long revision = -1L;
            try {
                revision = Long.parseLong(revAttr);
            }
            catch (NumberFormatException nfe) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, nfe), SVNLogType.NETWORK);
            }
            String name = attrs.getValue(NAME_ATTR);
            if (name == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing name attr in open-file element");
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
            this.myPath = SVNPathUtil.append(this.myPath, name);
            this.myEditor.openFile(this.myPath, revision);
            this.myIsFetchProps = false;
        } else if (element == ADD_FILE) {
            this.myIsDirectory = false;
            String name = attrs.getValue(NAME_ATTR);
            if (name == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing name attr in add-file element");
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
            this.myPath = SVNPathUtil.append(this.myPath, name);
            String copyFromPath = attrs.getValue(COPYFROM_PATH_ATTR);
            long copyFromRev = -1L;
            if (copyFromPath != null) {
                String copyFromRevisionAttr = attrs.getValue(COPYFROM_REV_ATTR);
                if (copyFromRevisionAttr == null) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing copyfrom-rev attr in add-file element");
                    SVNErrorManager.error(err, SVNLogType.NETWORK);
                }
                try {
                    copyFromRev = Long.parseLong(copyFromRevisionAttr);
                }
                catch (NumberFormatException nfe) {
                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, nfe), SVNLogType.NETWORK);
                }
            }
            this.myEditor.addFile(this.myPath, copyFromPath, copyFromRev);
            this.myIsFetchProps = true;
        } else if (element == DELETE_ENTRY) {
            String name = attrs.getValue(NAME_ATTR);
            if (name == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing name attr in delete-entry element");
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
            this.myEditor.deleteEntry(SVNPathUtil.append(this.myPath, name), -1L);
        } else if (element == SET_PROP) {
            this.myPropertyName = attrs.getValue(NAME_ATTR);
            if (this.myPropertyName == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing name attr in set-prop element");
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
            this.myEncoding = attrs.getValue(ENCODING_ATTR);
        } else if (element == REMOVE_PROP) {
            String name = attrs.getValue(NAME_ATTR);
            if (name == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing name attr in remove-prop element");
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
            if (this.myIsDirectory) {
                this.myEditor.changeDirProperty(name, null);
            } else {
                this.myEditor.changeFileProperty(this.myPath, name, null);
            }
        } else if (element == FETCH_FILE) {
            String baseChecksum = attrs.getValue(BASE_CHECKSUM_ATTR);
            this.myChecksum = null;
            if (!this.myIsReceiveAll) {
                this.fetchFile(baseChecksum);
            }
        } else if (element == RESOURCE) {
            this.myCurrentWCPath = attrs.getValue(PATH_ATTR);
            if (this.myCurrentWCPath == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing path attr in resource element");
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
            this.myIsInResource = true;
        } else if (element == FETCH_PROPS) {
            if (!this.myIsFetchContent) {
                if (this.myIsDirectory) {
                    this.myEditor.changeDirProperty("svn:BOGOSITY", null);
                } else {
                    this.myEditor.changeFileProperty(this.myPath, "svn:BOGOSITY", null);
                }
            } else if (this.myIsDirectory) {
                DirInfo dirInfo = (DirInfo)this.myDirs.peek();
                dirInfo.myIsFetchProps = true;
            } else {
                this.myIsFetchProps = true;
            }
        } else if (element == TX_DELTA && this.myIsReceiveAll) {
            this.setDeltaProcessing(true);
            this.myEditor.applyTextDelta(this.myPath, this.myChecksum);
        }
    }

    @Override
    protected void endElement(DAVElement parent, DAVElement element, StringBuffer cdata) throws SVNException {
        if (element == RESOURCE) {
            this.myIsInResource = false;
        } else if (element == UPDATE_REPORT) {
            this.myEditor.closeEdit();
        } else if (element == OPEN_DIRECTORY || element == ADD_DIRECTORY) {
            if (this.myDirs.size() != 1 || !this.myHasTarget) {
                this.addNodeProperties(this.myPath, true);
            }
            this.myEditor.closeDir();
            this.myChecksum = null;
            this.myPath = SVNPathUtil.removeTail(this.myPath);
            this.myDirs.pop();
        } else if (element == ADD_FILE) {
            if (!this.myIsReceiveAll) {
                this.fetchFile(null);
                this.addNodeProperties(this.myPath, false);
            }
            this.myEditor.closeFile(this.myPath, this.myChecksum);
            this.myChecksum = null;
            this.myPath = SVNPathUtil.removeTail(this.myPath);
            this.myIsDirectory = true;
        } else if (element == OPEN_FILE) {
            this.addNodeProperties(this.myPath, false);
            this.myEditor.closeFile(this.myPath, this.myChecksum);
            this.myChecksum = null;
            this.myPath = SVNPathUtil.removeTail(this.myPath);
            this.myIsDirectory = true;
        } else if (element == DAVElement.MD5_CHECKSUM) {
            this.myChecksum = cdata.toString();
        } else if (element == DAVElement.CREATOR_DISPLAY_NAME || element == DAVElement.VERSION_NAME || element == DAVElement.CREATION_DATE) {
            DAVUtil.setSpecialWCProperties(this.myEditor, this.myIsDirectory, this.myPath, element, SVNPropertyValue.create(cdata.toString()));
        } else if (element == DAVElement.HREF) {
            if (this.myIsFetchContent) {
                this.myHref = cdata.toString();
                if (this.myIsInResource) {
                    this.myVersionURLs.put(this.myCurrentWCPath, this.myHref);
                } else if (this.myIsDirectory) {
                    if (this.myDirs.size() != 1 || !this.myHasTarget) {
                        try {
                            this.myEditor.changeDirProperty("svn:wc:ra_dav:version-url", SVNPropertyValue.create(this.myHref));
                        }
                        catch (SVNException svne) {
                            SVNErrorManager.error(svne.getErrorMessage().wrap("Could not save the URL of the version resource"), SVNLogType.NETWORK);
                        }
                        DirInfo topDirInfo = (DirInfo)this.myDirs.peek();
                        topDirInfo.myVSNURL = this.myHref;
                    }
                } else {
                    try {
                        this.myEditor.changeFileProperty(this.myPath, "svn:wc:ra_dav:version-url", SVNPropertyValue.create(this.myHref));
                    }
                    catch (SVNException svne) {
                        SVNErrorManager.error(svne.getErrorMessage().wrap("Could not save the URL of the version resource"), SVNLogType.NETWORK);
                    }
                }
            }
        } else if (element == SET_PROP) {
            if (this.myPropertyName == null) {
                this.myPropertyName = DAVEditorHandler.computeWCPropertyName(element);
            }
            SVNPropertyValue value = null;
            if (this.myEncoding == null || "".equals(this.myEncoding)) {
                value = SVNPropertyValue.create(cdata.toString());
            } else if ("base64".equals(this.myEncoding)) {
                StringBuffer sb = SVNBase64.normalizeBase64(cdata);
                byte[] buffer = this.allocateBuffer(sb.length());
                int length = SVNBase64.base64ToByteArray(sb, buffer);
                value = SVNPropertyValue.create(this.myPropertyName, buffer, 0, length);
            } else {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.XML_UNKNOWN_ENCODING, "Unknown XML encoding: ''{0}''", this.myEncoding);
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
            if (this.myIsDirectory) {
                this.myEditor.changeDirProperty(this.myPropertyName, value);
            } else {
                this.myEditor.changeFileProperty(this.myPath, this.myPropertyName, value);
            }
            this.myPropertyName = null;
            this.myEncoding = null;
        } else if (element == TX_DELTA && this.myIsReceiveAll) {
            this.setDeltaProcessing(false);
        }
    }

    @Override
    protected String getCurrentPath() {
        return this.myPath;
    }

    @Override
    protected ISVNDeltaConsumer getDeltaConsumer() {
        return this.myDeltaConsumer;
    }

    protected void fetchFile(String baseChecksum) throws SVNException {
        this.setDeltaProcessing(true);
        try {
            this.myEditor.applyTextDelta(this.myPath, baseChecksum);
        }
        catch (SVNException svne) {
            SVNErrorManager.error(svne.getErrorMessage().wrap("Could not save file"), SVNLogType.NETWORK);
        }
        if (this.myIsFetchContent) {
            if (this.myHref == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "assertion failure in DAVEditorHandler.fetchFile(): myHref is null");
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
            String deltaBaseVersionURL = this.myPath != null ? (String)this.myVersionURLs.get(this.myPath) : null;
            DeltaOutputStreamWrapper osWrapper = new DeltaOutputStreamWrapper(deltaBaseVersionURL != null, this.myPath);
            DAVConnection connection = this.getConnection();
            connection.doGet(this.myHref, deltaBaseVersionURL, osWrapper);
        }
        this.setDeltaProcessing(false);
    }

    protected void addNodeProperties(String path, boolean isDir) throws SVNException {
        if (this.myIsReceiveAll) {
            return;
        }
        if (!this.myIsFetchContent) {
            return;
        }
        if (!isDir) {
            DAVProperties props;
            String lockToken = (String)this.myLockTokens.get(path);
            if (lockToken != null) {
                String fullPath = this.myOwner.doGetFullPath(path);
                fullPath = SVNEncodingUtil.uriEncode(fullPath);
                DAVConnection connection = this.getConnection();
                SVNLock lock = connection.doGetLock(fullPath, this.myOwner);
                if (lock == null || lock.getID() == null || !lockToken.equals(lock.getID())) {
                    this.myEditor.changeFileProperty(path, "svn:entry:lock-token", null);
                }
            }
            if (!this.myIsFetchProps) {
                return;
            }
            DirInfo topDirInfo = (DirInfo)this.myDirs.peek();
            DAVProperties dAVProperties = props = topDirInfo.myChildren != null ? (DAVProperties)topDirInfo.myChildren.get(this.myHref) : null;
            if (props == null) {
                props = DAVUtil.getResourceProperties(this.getConnection(), this.myHref, null, null);
            }
            this.addProps(props, false);
        } else {
            DAVProperties props;
            DirInfo topDirInfo = (DirInfo)this.myDirs.peek();
            if (!topDirInfo.myIsFetchProps) {
                return;
            }
            DAVProperties dAVProperties = props = topDirInfo.myChildren != null ? (DAVProperties)topDirInfo.myChildren.get(topDirInfo.myVSNURL) : null;
            if (props == null) {
                props = DAVUtil.getResourceProperties(this.getConnection(), topDirInfo.myVSNURL, null, null);
            }
            this.addProps(props, true);
        }
    }

    private void addProps(DAVProperties props, boolean isDir) throws SVNException {
        Map propsMap = props.getProperties();
        for (DAVElement element : propsMap.keySet()) {
            String propName;
            SVNPropertyValue propValue = (SVNPropertyValue)propsMap.get(element);
            String elementNamespace = element.getNamespace();
            if (elementNamespace.equals("http://subversion.tigris.org/xmlns/custom/")) {
                propName = element.getName();
                if (isDir) {
                    this.myEditor.changeDirProperty(propName, propValue);
                    continue;
                }
                this.myEditor.changeFileProperty(this.myPath, propName, propValue);
                continue;
            }
            if (elementNamespace.equals("http://subversion.tigris.org/xmlns/svn/")) {
                propName = "svn:" + element.getName();
                if (isDir) {
                    this.myEditor.changeDirProperty(propName, propValue);
                    continue;
                }
                this.myEditor.changeFileProperty(this.myPath, propName, propValue);
                continue;
            }
            DAVUtil.setSpecialWCProperties(this.myEditor, isDir, this.myPath, element, propValue);
        }
    }

    private DAVConnection getConnection() throws SVNException {
        if (this.myConnection == null) {
            this.myConnection = new DAVConnection(this.myConnectionFactory, this.myOwner);
            this.myConnection.setReportResponseSpooled(this.myOwner.isSpoolResponse());
            this.myConnection.open(this.myOwner);
        }
        return this.myConnection;
    }

    private static String computeWCPropertyName(DAVElement element) {
        return "svn:entry:" + element.getName();
    }

    private class DeltaOutputStreamWrapper
    extends OutputStream {
        private boolean myIsDelta;
        private SVNDeltaGenerator myDeltaGenerator;
        private String myPath;

        public DeltaOutputStreamWrapper(boolean isDelta, String path) {
            this.myIsDelta = isDelta;
            this.myPath = path;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.myIsDelta) {
                try {
                    DAVEditorHandler.this.characters(new char[]{(char)(b & 0xFF)}, 0, 1);
                }
                catch (SAXException saxe) {
                    throw new IOException(saxe.getMessage());
                }
            }
            try {
                this.getDeltaGenerator().sendDelta(this.myPath, new byte[]{(byte)b}, 1, DAVEditorHandler.this.myDeltaConsumer);
            }
            catch (SVNException svne) {
                IOExceptionWrapper ioeWrapper = new IOExceptionWrapper(svne);
                throw ioeWrapper;
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.myIsDelta) {
                char[] chars = new char[len];
                for (int i = 0; i < len; ++i) {
                    chars[i] = (char)(b[off + i] & 0xFF);
                }
                try {
                    DAVEditorHandler.this.characters(chars, 0, chars.length);
                }
                catch (SAXException saxe) {
                    throw new IOException(saxe.getMessage());
                }
            }
            try {
                byte[] target = new byte[len];
                System.arraycopy(b, off, target, 0, len);
                this.getDeltaGenerator().sendDelta(this.myPath, target, len, DAVEditorHandler.this.myDeltaConsumer);
            }
            catch (SVNException svne) {
                IOExceptionWrapper ioeWrapper = new IOExceptionWrapper(svne);
                throw ioeWrapper;
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            if (this.myIsDelta) {
                char[] chars = new char[b.length];
                for (int i = 0; i < b.length; ++i) {
                    chars[i] = (char)(b[i] & 0xFF);
                }
                try {
                    DAVEditorHandler.this.characters(chars, 0, chars.length);
                }
                catch (SAXException saxe) {
                    throw new IOException(saxe.getMessage());
                }
            }
            try {
                this.getDeltaGenerator().sendDelta(this.myPath, b, b.length, DAVEditorHandler.this.myDeltaConsumer);
            }
            catch (SVNException svne) {
                IOExceptionWrapper ioeWrapper = new IOExceptionWrapper(svne);
                throw ioeWrapper;
            }
        }

        private SVNDeltaGenerator getDeltaGenerator() {
            if (this.myDeltaGenerator == null) {
                this.myDeltaGenerator = new SVNDeltaGenerator();
            }
            return this.myDeltaGenerator;
        }
    }

    private class DirInfo {
        private boolean myIsFetchProps;
        private Map myChildren;
        private String myVSNURL;

        private DirInfo() {
        }
    }
}

