/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaReader;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;
import org.xml.sax.SAXException;

public abstract class BasicDAVDeltaHandler
extends BasicDAVHandler {
    protected static final DAVElement TX_DELTA = DAVElement.getElement("svn:", "txdelta");
    private boolean myIsDeltaProcessing;
    private SVNDeltaReader myDeltaReader;
    private StringBuffer myDeltaOutputStream;

    protected void setDeltaProcessing(boolean processing) throws SVNException {
        this.myIsDeltaProcessing = processing;
        if (!this.myIsDeltaProcessing) {
            this.myDeltaReader.reset(this.getCurrentPath(), this.getDeltaConsumer());
            this.getDeltaConsumer().textDeltaEnd(this.getCurrentPath());
        } else {
            this.myDeltaOutputStream.delete(0, this.myDeltaOutputStream.length());
        }
    }

    @Override
    protected void init() {
        this.myDeltaReader = new SVNDeltaReader();
        this.myDeltaOutputStream = new StringBuffer();
        super.init();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.myIsDeltaProcessing) {
            int index;
            int stored;
            int offset = start;
            for (int i = start; i < start + length; ++i) {
                if (ch[i] != '\r' && ch[i] != '\n') continue;
                this.myDeltaOutputStream.append(ch, offset, i - offset);
                offset = i + 1;
                if (i + 1 >= start + length || ch[i + 1] != '\n') continue;
                ++offset;
                ++i;
            }
            if (offset < start + length) {
                this.myDeltaOutputStream.append(ch, offset, start + length - offset);
            }
            if ((stored = this.myDeltaOutputStream.length()) < 4) {
                return;
            }
            int segmentsCount = stored / 4;
            int remains = stored - segmentsCount * 4;
            StringBuffer toDecode = new StringBuffer();
            toDecode.append(this.myDeltaOutputStream);
            toDecode.delete(this.myDeltaOutputStream.length() - remains, this.myDeltaOutputStream.length());
            for (index = 0; index < toDecode.length() && Character.isWhitespace(toDecode.charAt(index)); ++index) {
            }
            if (index > 0) {
                toDecode = toDecode.delete(0, index);
            }
            for (index = toDecode.length() - 1; index >= 0 && Character.isWhitespace(toDecode.charAt(index)); --index) {
                toDecode.delete(index, toDecode.length());
            }
            byte[] buffer = this.allocateBuffer(toDecode.length());
            int decodedLength = SVNBase64.base64ToByteArray(toDecode, buffer);
            try {
                this.myDeltaReader.nextWindow(buffer, 0, decodedLength, this.getCurrentPath(), this.getDeltaConsumer());
            }
            catch (SVNException e) {
                throw new SAXException(e);
            }
            this.myDeltaOutputStream.delete(0, toDecode.length());
        } else {
            super.characters(ch, start, length);
        }
    }

    protected abstract String getCurrentPath();

    protected abstract ISVNDeltaConsumer getDeltaConsumer();
}

