/*
 * Decompiled with CFR 0.152.
 */
package de.regnis.q.sequence.media;

import de.regnis.q.sequence.core.QSequenceCancelledException;
import de.regnis.q.sequence.core.QSequenceCanceller;
import de.regnis.q.sequence.core.QSequenceMedia;
import de.regnis.q.sequence.media.QSequenceDiscardingMediaBlock;
import de.regnis.q.sequence.media.QSequenceDiscardingMediaConfusionDetector;
import de.regnis.q.sequence.media.QSequenceDiscardingMediaLeftBlock;
import de.regnis.q.sequence.media.QSequenceDiscardingMediaRightBlock;
import de.regnis.q.sequence.media.QSequenceIntMedia;
import de.regnis.q.sequence.media.QSequenceMediaIndexTransformer;

public class QSequenceDiscardingMedia
implements QSequenceMedia,
QSequenceMediaIndexTransformer {
    private final QSequenceIntMedia media;
    private final QSequenceCanceller canceller;
    private final QSequenceDiscardingMediaBlock leftBlock;
    private final QSequenceDiscardingMediaBlock rightBlock;
    private final int[] undiscardedLeftSymbols;
    private final int[] undiscardedRightSymbols;
    private final int undiscardedLeftSymbolCount;
    private final int undiscardedRightSymbolCount;

    public QSequenceDiscardingMedia(QSequenceIntMedia media, QSequenceDiscardingMediaConfusionDetector confusionDetector, QSequenceCanceller canceller) {
        this.media = media;
        this.canceller = canceller;
        this.leftBlock = new QSequenceDiscardingMediaLeftBlock(this.media);
        this.rightBlock = new QSequenceDiscardingMediaRightBlock(this.media);
        this.leftBlock.init(this.rightBlock, confusionDetector);
        this.rightBlock.init(this.leftBlock, confusionDetector);
        this.undiscardedLeftSymbols = this.leftBlock.getUndiscardedSymbols();
        this.undiscardedLeftSymbolCount = this.leftBlock.getUndiscardedSymbolCount();
        this.undiscardedRightSymbols = this.rightBlock.getUndiscardedSymbols();
        this.undiscardedRightSymbolCount = this.rightBlock.getUndiscardedSymbolCount();
    }

    @Override
    public int getLeftLength() {
        return this.undiscardedLeftSymbolCount;
    }

    @Override
    public int getRightLength() {
        return this.undiscardedRightSymbolCount;
    }

    @Override
    public boolean equals(int leftIndex, int rightIndex) throws QSequenceCancelledException {
        this.canceller.checkCancelled();
        return this.undiscardedLeftSymbols[leftIndex] == this.undiscardedRightSymbols[rightIndex];
    }

    @Override
    public int getMediaLeftIndex(int index) {
        return this.leftBlock.getMediaIndex(index);
    }

    @Override
    public int getMediaRightIndex(int index) {
        return this.rightBlock.getMediaIndex(index);
    }

    @Override
    public int getMediaLeftLength() {
        return this.media.getLeftLength();
    }

    @Override
    public int getMediaRightLength() {
        return this.media.getRightLength();
    }
}

