/*
 * Decompiled with CFR 0.152.
 */
package de.regnis.q.sequence.core;

import de.regnis.q.sequence.core.QSequenceDeePathExtender;
import de.regnis.q.sequence.core.QSequenceDeePathExtenderArray;
import de.regnis.q.sequence.core.QSequenceException;
import de.regnis.q.sequence.core.QSequenceMedia;

final class QSequenceDeePathBackwardExtender
extends QSequenceDeePathExtender {
    private int delta;
    private int mediaLeftLength;
    private int mediaRightLength;

    public QSequenceDeePathBackwardExtender(int maximumMediaLeftLength, int maximumMediaRightLength) {
        super(new QSequenceDeePathExtenderArray(maximumMediaLeftLength + maximumMediaRightLength));
    }

    @Override
    protected int getNextX(QSequenceDeePathExtenderArray xs, int diagonal, int dee) {
        if (diagonal - this.delta == dee || diagonal - this.delta != -dee && xs.get(diagonal + 1) > xs.get(diagonal - 1)) {
            return xs.get(diagonal - 1);
        }
        return xs.get(diagonal + 1) - 1;
    }

    @Override
    protected int getSnakeX(QSequenceMedia media, int x, int y) throws QSequenceException {
        while (x > 0 && y > 0 && media.equals(x, y)) {
            --x;
            --y;
        }
        return x;
    }

    @Override
    protected final void reset(QSequenceMedia media, QSequenceDeePathExtenderArray xs) {
        this.mediaLeftLength = media.getLeftLength();
        this.mediaRightLength = media.getRightLength();
        this.delta = this.mediaLeftLength - this.mediaRightLength;
        xs.setDelta(this.delta);
        xs.set(this.delta - 1, this.mediaLeftLength);
    }

    @Override
    public int getProgress(int diagonal) {
        return this.mediaLeftLength - this.getLeft(diagonal) + this.mediaRightLength - this.getRight(diagonal);
    }
}

