/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.progress;

import java.awt.Component;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bm.util.ResourcePicker;
import oracle.ide.controls.progress.SteppedProgressComponent;
import oracle.ide.controls.progress.SteppedProgressMonitor;
import oracle.ide.help.HelpSystem;
import oracle.javatools.util.BundleLoader;

public final class SteppedProgressPanel {
    private SteppedProgressComponent m_component;
    private String m_hint;
    private String m_failedMessage;
    private String m_finishedMessage;
    private String[] m_tasks;
    private ResourcePicker m_resources;
    private JEWTDialog m_dialog;
    private WindowListener m_wl;

    public Component getComponent() {
        if (this.m_component == null) {
            this.m_component = this.createComponent();
        }
        return this.m_component;
    }

    JLabel getMessageDisplayLabel() {
        return this.m_component.getMessageDisplayLabel();
    }

    void setDialog(JEWTDialog d) {
        this.m_dialog = d;
    }

    JEWTDialog getDialog() {
        return this.m_dialog;
    }

    void setWindowListener(WindowListener wl) {
        this.m_wl = wl;
    }

    void finish(boolean closeDialog) {
        this.getDialog().removeWindowListener(this.m_wl);
        if (closeDialog) {
            this.getDialog().setVisible(false);
        } else {
            ((JButton)this.getDialog().getCustomButton(0)).setText(ResourcePicker.getPicker(SteppedProgressPanel.class).getString("SteppedProgressDialog.Close"));
        }
    }

    void setCancelled(boolean isCancelled) {
        this.m_component.setCancelled(isCancelled);
    }

    boolean isCancelled() {
        return this.m_component.isCancelled();
    }

    public void setHint(String hint) {
        this.m_hint = hint;
    }

    String getHint() {
        return this.m_hint;
    }

    public void setF1Help(String f1Help) {
        if (f1Help != null) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this.getComponent(), f1Help);
        }
    }

    public void setFinishedMessage(String message) {
        this.m_finishedMessage = message;
    }

    String getFinishedMessage() {
        return this.m_finishedMessage;
    }

    public void setFailedMessage(String message) {
        this.m_failedMessage = message;
    }

    String getFailedMessage() {
        return this.m_failedMessage;
    }

    public void setTasks(String[] tasks) {
        this.m_tasks = tasks;
        this.m_component = null;
    }

    String getTaskDescription(int i2) {
        return this.getTasks()[i2];
    }

    int getTaskCount() {
        return this.getTasks().length;
    }

    private String[] getTasks() {
        return this.m_tasks;
    }

    public SteppedProgressMonitor getMonitor() {
        return (SteppedProgressMonitor)((Object)this.getComponent());
    }

    ResourcePicker getRes() {
        if (this.m_resources == null) {
            this.m_resources = new ResourcePicker(BundleLoader.getBundle((String)"oracle.ide.controls.progress.res.Resource"));
        }
        return this.m_resources;
    }

    public boolean isSuccessful() {
        return this.m_component.isSuccessful();
    }

    private SteppedProgressComponent createComponent() {
        return new SteppedProgressComponent(this);
    }
}

