/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.progress;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Writer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.bm.util.ResourcePicker;
import oracle.ide.Ide;
import oracle.ide.controls.progress.DetailedProgressWatcher;
import oracle.ide.controls.progress.TruncatedFileLabel;
import oracle.ide.util.Assert;
import oracle.ide.util.SafeActionListener;

abstract class AbstractProgressDialog
implements DetailedProgressWatcher {
    private JPanel m_mainPanel;
    private JLabel m_descriptionLabel;
    private boolean m_descriptionSet = false;
    private JLabel m_detailLabel;
    private JButton m_stopButton;
    private boolean m_isCancelled = false;
    private boolean m_isFinished = false;
    private JDialog m_dialog;
    private boolean m_isStoppable = true;
    private static final int MIN_WIDTH = 300;
    private Object m_blockedObject = new Object();
    private boolean m_passedWait = false;
    private long m_pauseMs = 8000L;

    AbstractProgressDialog() {
        this.createComponents();
        this.layoutComponents();
        this.addListeners();
    }

    @Override
    public Writer getDetailsWriter() {
        return null;
    }

    @Override
    public void setPauseBeforeDisplay(long pauseMs) {
        this.m_pauseMs = pauseMs;
    }

    private void createComponents() {
        this.m_mainPanel = new JPanel();
        this.m_descriptionLabel = new JLabel(" ");
        this.m_detailLabel = new TruncatedFileLabel();
        this.m_detailLabel.setText(" ");
        this.m_stopButton = new JButton(ResourcePicker.getPicker(AbstractProgressDialog.class).getString("ProgressDialog.Stop"));
        this.createProgressBarSpi();
        this.getProgressBarSpi().setPreferredSize(new Dimension(300, this.getProgressBarSpi().getPreferredSize().height));
        this.m_descriptionLabel.setPreferredSize(new Dimension(300, this.m_descriptionLabel.getPreferredSize().height));
        this.m_detailLabel.setPreferredSize(new Dimension(300, this.m_detailLabel.getPreferredSize().height));
    }

    private void layoutComponents() {
        JPanel progressPanel = new JPanel(new BorderLayout());
        progressPanel.add((Component)this.getProgressBarSpi(), "Center");
        this.m_mainPanel.setLayout(new GridBagLayout());
        this.m_mainPanel.add((Component)this.m_descriptionLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 16, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.m_mainPanel.add((Component)this.m_detailLabel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.m_mainPanel.add((Component)progressPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.m_mainPanel.add((Component)this.m_stopButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    private void addListeners() {
        this.m_stopButton.addActionListener(new StopListener());
    }

    private void layout() {
        if (this.m_dialog != null) {
            this.m_dialog.pack();
        }
    }

    @Override
    public void showDialog(Component parent, String title) {
        this.showDialog(parent, title, null);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void showDialog(Component parent, String title, Object target) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean dispatchThisEvent(AWTEvent awe, boolean dispatchInputEvents) {
        boolean processed = false;
        try {
            if (awe instanceof ActiveEvent) {
                ((ActiveEvent)((Object)awe)).dispatch();
                processed = true;
            } else {
                Object src = awe.getSource();
                if (src instanceof Component && (dispatchInputEvents || !(awe instanceof InputEvent))) {
                    ((Component)src).dispatchEvent(awe);
                    processed = true;
                }
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable ex) {
            Assert.printStackTrace((Throwable)ex);
        }
        return processed;
    }

    @Override
    public void setProgressBarVisible(final boolean isVisible) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractProgressDialog.this.getProgressBarSpi().setVisible(isVisible);
                AbstractProgressDialog.this.layout();
            }
        });
    }

    @Override
    public void setDetailLabelVisible(final boolean isVisible) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractProgressDialog.this.m_detailLabel.setVisible(isVisible);
                AbstractProgressDialog.this.layout();
            }
        });
    }

    @Override
    public void setStoppable(final boolean isStoppable) {
        if (this.m_isStoppable != isStoppable) {
            this.m_isStoppable = isStoppable;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractProgressDialog.this.m_stopButton.setVisible(isStoppable);
                    AbstractProgressDialog.this.layout();
                }
            });
        }
    }

    @Override
    public void setDescription(final String description) {
        if (this.m_descriptionSet) {
            return;
        }
        this.m_descriptionSet = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractProgressDialog.this.m_descriptionLabel.setText(description);
                Graphics g = AbstractProgressDialog.this.m_descriptionLabel.getGraphics();
                if (g != null) {
                    AbstractProgressDialog.this.m_descriptionLabel.paint(g);
                }
            }
        });
    }

    @Override
    public void start() {
        this.setCancelled(false);
    }

    private void stop() {
        this.setCancelled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish() {
        this.finishWatchingSpi();
        this.m_isFinished = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
        Object object = this.m_blockedObject;
        synchronized (object) {
            this.m_isFinished = true;
            if (this.m_passedWait) {
                while (this.m_dialog != null && !this.m_dialog.isVisible()) {
                    Thread.yield();
                }
                if (this.m_dialog != null) {
                    this.m_dialog.setVisible(false);
                }
            }
        }
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.m_isCancelled;
    }

    private synchronized void setCancelled(boolean isCancelled) {
        this.m_isCancelled = isCancelled;
        this.m_stopButton.setEnabled(!isCancelled);
        if (isCancelled) {
            this.m_isStoppable = false;
            this.displayMessage(ResourcePicker.getPicker(AbstractProgressDialog.class).getString("ProgressDialog.Cancelling"));
        } else {
            this.displayMessage(" ");
        }
    }

    @Override
    public void displayMessage(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractProgressDialog.this.m_detailLabel.setText(message);
                Graphics g = AbstractProgressDialog.this.m_detailLabel.getGraphics();
                if (g != null) {
                    AbstractProgressDialog.this.m_detailLabel.paint(g);
                }
            }
        });
    }

    @Override
    public void setMinimum(int m) {
        this.setMinimumSpi(m);
    }

    @Override
    public int getMinimum() {
        return this.getMinimumSpi();
    }

    @Override
    public void setMaximum(int m) {
        this.setMaximumSpi(m);
    }

    @Override
    public int getMaximum() {
        return this.getMaximumSpi();
    }

    @Override
    public void setProgress(int p) {
        this.setProgressSpi(p);
    }

    @Override
    public int getProgress() {
        return this.getProgressSpi();
    }

    @Override
    public Component getComponent() {
        return this.m_mainPanel;
    }

    private final Window findParentWindow(Component c) {
        if (c == null) {
            return Ide.getMainWindow();
        }
        return c instanceof Window ? (Window)c : SwingUtilities.getWindowAncestor(c);
    }

    protected abstract void createProgressBarSpi();

    protected abstract JComponent getProgressBarSpi();

    protected abstract void setMinimumSpi(int var1);

    protected abstract int getMinimumSpi();

    protected abstract void setMaximumSpi(int var1);

    protected abstract int getMaximumSpi();

    protected abstract void setProgressSpi(int var1);

    protected abstract int getProgressSpi();

    protected abstract void startWatchingSpi();

    protected abstract void finishWatchingSpi();

    private class WindowStopper
    extends WindowAdapter {
        private WindowStopper() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (AbstractProgressDialog.this.m_isStoppable) {
                AbstractProgressDialog.this.stop();
            }
        }
    }

    private class StopListener
    extends SafeActionListener {
        private StopListener() {
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            AbstractProgressDialog.this.stop();
        }
    }
}

