/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.ui;

import oracle.ide.natives.NativeHandler;
import oracle.ide.natives.registry.Registry;
import oracle.ide.natives.registry.RegistryException;
import oracle.ide.natives.registry.RegistryKey;
import oracle.ide.natives.registry.RegistryNotAvailableException;
import oracle.ide.util.Assert;
import oracle.javatools.util.PlatformUtils;

public final class SystemFont {
    private static final String s_DEFAULT = "SansSerif";
    private static final SystemFont s_INSTANCE = new SystemFont();
    private String m_systemFontName = null;

    public static final SystemFont getInstance() {
        return s_INSTANCE;
    }

    private SystemFont() {
    }

    public final String getSystemFontName() {
        if (this.m_systemFontName == null) {
            this.m_systemFontName = this.getSystemFontNameImpl();
        }
        return this.m_systemFontName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getSystemFontNameImpl() {
        if (PlatformUtils.isWindows() && NativeHandler.isLoaded() && System.getProperty("oracle.bm.FontSubstitution", "true").equals("true")) {
            RegistryKey hklm = null;
            RegistryKey fs = null;
            try {
                Registry reg = NativeHandler.getRegistry();
                hklm = reg.getLocalMachineKey();
                fs = hklm.openKey("Software\\Microsoft\\Windows NT\\CurrentVersion\\FontSubstitutes", 131097L);
                if (!PlatformUtils.isWindowsNT()) {
                    try {
                        String shellDlg2 = fs.getStringValue("MS Shell Dlg 2");
                        if (shellDlg2 != null && !"".equals(shellDlg2)) {
                            String string = shellDlg2;
                            return string;
                        }
                    }
                    catch (RegistryException rex) {
                        // empty catch block
                    }
                }
                try {
                    String shellDlg = fs.getStringValue("MS Shell Dlg");
                    if (shellDlg != null && !"".equals(shellDlg)) {
                        String string = shellDlg;
                        return string;
                    }
                }
                catch (RegistryException rex) {
                    // empty catch block
                }
                String string = s_DEFAULT;
                return string;
            }
            catch (RegistryNotAvailableException rnaex) {
            }
            catch (RegistryException rex) {
                Assert.printStackTrace((Throwable)rex);
            }
            finally {
                if (fs != null) {
                    try {
                        fs.close();
                    }
                    catch (RegistryException rex) {
                        Assert.printStackTrace((Throwable)rex);
                    }
                }
                if (hklm != null) {
                    try {
                        hklm.close();
                    }
                    catch (RegistryException rex) {
                        Assert.printStackTrace((Throwable)rex);
                    }
                }
            }
        }
        return s_DEFAULT;
    }
}

