/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.bm.util.ui.ObmMenuItem;
import oracle.ide.controller.IdeAction;

public class ObmPopupMenu
extends JPopupMenu {
    public ObmPopupMenu(String name) {
        this.setName(name);
    }

    @Override
    public void show(Component invoker, int x, int y) {
        this.setInvoker(invoker);
        this.invalidate();
        super.show(invoker, x, y);
        Point pos = new Point(x, y);
        Point invokerpos = invoker.getLocationOnScreen();
        pos.translate(invokerpos.x, invokerpos.y);
        this.keepObjectOnScreen(pos, this.getSize());
        this.setLocation(pos);
    }

    protected void keepObjectOnScreen(Point position, Dimension size) {
        int bottomEdge;
        int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        int rightEdge = position.x + size.width;
        if (rightEdge > screenWidth) {
            position.translate(screenWidth - rightEdge, 0);
        }
        if (position.x < 0) {
            position.x = 0;
        }
        if ((bottomEdge = position.y + size.height) > screenHeight) {
            position.translate(0, screenHeight - bottomEdge);
        }
        if (position.y < 0) {
            position.y = 0;
        }
    }

    @Override
    public JMenuItem add(Action act) {
        ObmMenuItem om = new ObmMenuItem((String)act.getValue("Name"));
        om.addActionListener(act);
        this.add(om);
        return om;
    }

    public JMenuItem add(IdeAction act) {
        JMenuItem om = new JMenuItem((Action)act);
        this.add(om);
        return om;
    }
}

