/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.ui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import oracle.bm.util.ui.ObmPopupMenu;
import oracle.ide.resource.IdeIcons;

public class ObmMenu
extends JMenu {
    public ObmMenu(String name) {
        this.setIcon(IdeIcons.getIcon((int)23));
        this.setName(name);
    }

    @Override
    public void setPopupMenuVisible(boolean b) {
        boolean isVisible = this.isPopupMenuVisible();
        if (b != isVisible) {
            this.ensurePopupMenuCreated();
            int x = 0;
            int y = 0;
            if (b && this.isShowing()) {
                Container parent = this.getParent();
                Dimension s = this.getSize();
                if (parent instanceof JPopupMenu) {
                    if (!this.getPopupMenu().isVisible()) {
                        this.getPopupMenu().show(this, s.width, 0);
                        int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
                        int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
                        Point parentloc = parent.getLocationOnScreen();
                        Dimension parentsize = parent.getSize();
                        Point thisloc = this.getLocationOnScreen();
                        Dimension thissize = this.getSize();
                        Point popuploc = this.getPopupMenu().getLocationOnScreen();
                        Dimension popupsize = this.getPopupMenu().getSize();
                        x = parentloc.x + parentsize.width + popupsize.width > screenWidth ? parentloc.x - popupsize.width : parentloc.x + parentsize.width;
                        y = thisloc.y + popupsize.height > screenHeight ? thisloc.y + thissize.height - popupsize.height : thisloc.y;
                        this.getPopupMenu().setLocation(new Point(x, y));
                    }
                } else {
                    x = 0;
                    y = s.height;
                    this.getPopupMenu().show(this, x, y);
                }
            } else {
                this.getPopupMenu().setVisible(false);
            }
        }
    }

    private void ensurePopupMenuCreated() {
        if (this.getPopupMenu() == null) {
            // empty if block
        }
    }

    public static void main(String[] args) {
        final ObmPopupMenu popup = new ObmPopupMenu("MyPopup");
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        ObmMenu submenu = new ObmMenu("Sub Menu");
        ObmMenu subsubmenu = new ObmMenu("SubSubMenu");
        popup.add(new JMenuItem("Normal Item"));
        popup.add(new JMenuItem("Another normal one"));
        popup.add(new JSeparator());
        for (int i2 = 0; i2 < 10; ++i2) {
            subsubmenu.add(new JMenuItem("Hello"));
        }
        submenu.add(new JMenuItem("Normal Item"));
        submenu.add(subsubmenu);
        popup.add(submenu);
        JFrame testFrame = new JFrame();
        final JButton button = new JButton("Click to popup");
        testFrame.getContentPane().add(button);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                popup.show(button, button.getSize().width, 0);
            }
        });
        testFrame.pack();
        testFrame.setVisible(true);
    }
}

