/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.ui;

import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bm.util.ui.MultiCapable;
import oracle.ide.Ide;

public class MultiCapableTextArea
extends JTextArea
implements MultiCapable {
    private boolean m_isMulti = false;
    private String m_multiText = "";
    private boolean m_selfUpdate = false;
    private String m_warningQuestion = null;
    private boolean m_manualSetText = false;
    private boolean m_askingQuestion = false;
    private String m_enteredText = "";

    public MultiCapableTextArea() {
        this("");
    }

    public MultiCapableTextArea(String text) {
        super(text);
        this.getDocument().addDocumentListener(new AutoSwitcher());
    }

    public void setWarningQuestion(String question) {
        this.m_warningQuestion = question;
    }

    private boolean confirm() {
        if (this.m_warningQuestion != null) {
            return JOptionPane.showConfirmDialog(this, this.m_warningQuestion, Ide.getProgramName(), 0) == 0;
        }
        return true;
    }

    @Override
    public void setText(String s) {
        this.m_manualSetText = true;
        super.setText(s);
        this.m_manualSetText = false;
        if (!this.m_selfUpdate) {
            this.m_isMulti = false;
        }
    }

    @Override
    public void setMultiText(String multiText) {
        this.m_multiText = multiText;
    }

    @Override
    public boolean isMultiState() {
        return this.m_isMulti;
    }

    @Override
    public void setMultiState(boolean isMulti) {
        this.m_selfUpdate = true;
        if (isMulti) {
            this.setText(this.m_multiText);
        }
        this.m_isMulti = isMulti;
        this.m_selfUpdate = false;
    }

    private void documentUpdated() {
        if (this.m_manualSetText) {
            return;
        }
        if (!this.m_selfUpdate && this.isMultiState()) {
            if (this.m_askingQuestion) {
                return;
            }
            this.m_askingQuestion = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    boolean isConfirmed = MultiCapableTextArea.this.confirm();
                    MultiCapableTextArea.this.setMultiState(!isConfirmed);
                    MultiCapableTextArea.this.m_askingQuestion = false;
                    if (isConfirmed) {
                        MultiCapableTextArea.this.m_selfUpdate = true;
                        MultiCapableTextArea.this.setText(MultiCapableTextArea.this.m_enteredText);
                        MultiCapableTextArea.this.m_selfUpdate = false;
                    }
                }
            });
        }
    }

    private class AutoSwitcher
    implements DocumentListener {
        private AutoSwitcher() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            MultiCapableTextArea.this.documentUpdated();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            try {
                MultiCapableTextArea.this.m_enteredText = e.getDocument().getText(e.getOffset(), e.getLength());
            }
            catch (Exception exception) {
                // empty catch block
            }
            MultiCapableTextArea.this.documentUpdated();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            MultiCapableTextArea.this.documentUpdated();
        }
    }
}

