/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.re;

import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.bm.util.re.CWFastSet;
import oracle.bm.util.re.FABuilder;
import oracle.bm.util.re.FAQuerier;
import oracle.bm.util.re.RegExpConstants;

public class CWMappedFA
implements RegExpConstants,
FAQuerier,
FABuilder {
    int m_nstates = 1;
    Hashtable m_transByFromState;
    public STransList[] m_transArr;
    int m_accState = -1;
    boolean m_finalised = false;
    Vector subexpStates = new Vector();
    int subexpCount;
    CWFastSet[] m_statesInSubexp = null;
    BoundaryHolder[] m_boundaries = null;

    public CWMappedFA() {
        this.m_transByFromState = new Hashtable();
    }

    @Override
    public boolean ToStatesForEvent(int i_from, int i_oninput, CWFastSet o_toset) {
        boolean retval = false;
        if (this.m_finalised) {
            STransList tList = this.m_transArr[i_from];
            if (tList == null) {
                return retval;
            }
            if (tList.transByEvent != null && tList.transByEvent[i_oninput] != null) {
                for (int i2 = 0; i2 < tList.transByEvent[i_oninput].size; ++i2) {
                    o_toset.Append(tList.transByEvent[i_oninput].targets[i2]);
                }
            } else {
                for (int i3 = 0; i3 < tList.size; ++i3) {
                    if (tList.trans[i3].m_evt != i_oninput && (i_oninput == 256 || tList.trans[i3].m_evt != 257)) continue;
                    o_toset.Append(tList.trans[i3].m_state);
                }
            }
            retval = !o_toset.IsEmpty();
        } else {
            Vector stateTrans = (Vector)this.m_transByFromState.get(new Integer(i_from));
            if (stateTrans != null) {
                Enumeration e = stateTrans.elements();
                while (e.hasMoreElements()) {
                    STrans trans = (STrans)e.nextElement();
                    if (trans.m_evt != i_oninput && (i_oninput == 256 || trans.m_evt != 257)) continue;
                    o_toset.Append(trans.m_state);
                    retval = true;
                }
            }
        }
        return retval;
    }

    @Override
    public int GetAcceptState() {
        return this.m_accState;
    }

    @Override
    public boolean StatesInsideSubexp(int state, CWFastSet subexps) {
        boolean retval = false;
        if (this.m_statesInSubexp[state] != null) {
            retval = true;
            subexps.Append(this.m_statesInSubexp[state]);
        }
        return retval;
    }

    @Override
    public boolean SubexpBoundaryCrossed(CWFastSet itSet, CWFastSet inwardSet, CWFastSet outwardSet) {
        boolean retval = false;
        for (int i2 = 0; i2 < itSet.GetCount(); ++i2) {
            if (this.m_boundaries[itSet.elementAt(i2)] == null) continue;
            int itElem = itSet.elementAt(i2);
            for (int j = 0; j < this.m_boundaries[itElem].size; ++j) {
                if (itSet.Find(this.m_boundaries[itElem].bounds[j].endState) != 1) continue;
                retval = true;
                if (this.m_boundaries[itElem].bounds[j].type == 262) {
                    inwardSet.Append(this.m_boundaries[itElem].bounds[j].subexp);
                    continue;
                }
                outwardSet.Append(this.m_boundaries[itElem].bounds[j].subexp);
            }
        }
        return retval;
    }

    @Override
    public int GetSubexpCount() {
        return this.m_statesInSubexp != null ? this.subexpCount : 0;
    }

    @Override
    public void Dump(PrintStream out) {
        int j;
        int i2;
        out.println("+++ MappedFA transitions -");
        for (i2 = 0; i2 < this.m_nstates; ++i2) {
            out.print(Integer.toString(i2) + ": ");
            if (this.m_transArr[i2] != null && this.m_transArr[i2].size != 0) {
                for (j = 0; j < this.m_transArr[i2].size; ++j) {
                    String evt;
                    switch (this.m_transArr[i2].trans[j].m_evt) {
                        case 256: {
                            evt = "null";
                            break;
                        }
                        case 257: {
                            evt = "any";
                            break;
                        }
                        case 261: {
                            evt = "optional";
                            break;
                        }
                        case 262: {
                            evt = "openSubexp";
                            break;
                        }
                        case 263: {
                            evt = "closeSubexp";
                            break;
                        }
                        case 258: {
                            evt = "bufferStart";
                            break;
                        }
                        case 259: {
                            evt = "bufferEnd";
                            break;
                        }
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: 
                        case 31: 
                        case 127: {
                            int e = this.m_transArr[i2].trans[j].m_evt;
                            int hi = e >> 4 & 0xF;
                            char hiDig = "0123456789ABCDEF".charAt(hi);
                            int lo = e & 0xF;
                            char loDig = "0123456789ABCDEF".charAt(lo);
                            evt = "0x" + hiDig + loDig;
                            break;
                        }
                        default: {
                            evt = "'" + new Character((char)this.m_transArr[i2].trans[j].m_evt).toString() + "'";
                        }
                    }
                    out.print(evt + " -> " + Integer.toString(this.m_transArr[i2].trans[j].m_state) + "; ");
                }
            } else {
                out.print("none");
            }
            out.print("\n");
        }
        for (i2 = 0; i2 < this.m_nstates; ++i2) {
            out.print(Integer.toString(i2) + ": Subexps - ");
            if (this.m_statesInSubexp[i2] == null) {
                out.print("none");
            } else {
                for (j = 0; j < this.m_statesInSubexp[i2].GetCount(); ++j) {
                    out.print("$" + Integer.toString(this.m_statesInSubexp[i2].elementAt(j)) + " ");
                }
            }
            out.print("\t\tBoundaries - ");
            if (this.m_boundaries == null || this.m_boundaries[i2] == null) {
                out.print("none");
            } else {
                for (j = 0; j < this.m_boundaries[i2].size; ++j) {
                    out.print((this.m_boundaries[i2].bounds[j].type == 262 ? "into " : "out of ") + "$" + Integer.toString(this.m_boundaries[i2].bounds[j].subexp) + " to " + Integer.toString(this.m_boundaries[i2].bounds[j].endState) + "; ");
                }
            }
            out.print("\n");
        }
        out.print("\n");
    }

    @Override
    public int GetMaxState() {
        return this.m_nstates;
    }

    @Override
    public int NewState() {
        return this.m_nstates++;
    }

    @Override
    public void AddTransition(int sourceState, int event, int targetState) {
        STrans trans = new STrans();
        trans.m_evt = event;
        trans.m_state = targetState;
        Vector<STrans> stateTrans = (Vector<STrans>)this.m_transByFromState.get(new Integer(sourceState));
        if (stateTrans == null) {
            stateTrans = new Vector<STrans>();
            this.m_transByFromState.put(new Integer(sourceState), stateTrans);
        }
        stateTrans.addElement(trans);
    }

    @Override
    public void AddEmptyTransition(int sourceState, int targetState) {
        this.AddTransition(sourceState, 256, targetState);
    }

    @Override
    public void SetAcceptState(int a_acceptState) {
        this.m_accState = a_acceptState;
    }

    @Override
    public void Freeze() {
        int deadStates;
        int j;
        this.m_statesInSubexp = new CWFastSet[this.m_nstates];
        this.subexpCount = this.subexpStates.size();
        for (int i2 = 0; i2 < this.subexpCount; ++i2) {
            CWFastSet states = (CWFastSet)this.subexpStates.elementAt(i2);
            for (int j2 = 0; j2 < states.GetCount(); ++j2) {
                if (this.m_statesInSubexp[states.elementAt(j2)] == null) {
                    this.m_statesInSubexp[states.elementAt((int)j2)] = new CWFastSet(this.subexpCount);
                }
                this.m_statesInSubexp[states.elementAt(j2)].Append(i2);
            }
        }
        this.subexpStates.removeAllElements();
        this.m_transArr = new STransList[this.m_nstates];
        STransList[] fromsArr = new STransList[this.m_nstates];
        for (int i3 = 0; i3 < this.m_nstates; ++i3) {
            Vector stateTrans = (Vector)this.m_transByFromState.get(new Integer(i3));
            if (stateTrans != null) {
                this.m_transArr[i3] = new STransList();
                this.m_transArr[i3].size = this.m_transArr[i3].maxSize = stateTrans.size();
                this.m_transArr[i3].trans = new STrans[this.m_transArr[i3].maxSize];
                j = 0;
                Enumeration e = stateTrans.elements();
                while (e.hasMoreElements()) {
                    STrans trans = (STrans)e.nextElement();
                    this.m_transArr[i3].trans[j] = new STrans();
                    this.m_transArr[i3].trans[j].m_evt = trans.m_evt;
                    this.m_transArr[i3].trans[j].m_state = trans.m_state;
                    if (fromsArr[trans.m_state] == null) {
                        fromsArr[trans.m_state] = new STransList();
                        fromsArr[trans.m_state].trans = new STrans[this.m_transArr[i3].maxSize];
                        fromsArr[trans.m_state].maxSize = this.m_transArr[i3].maxSize;
                    }
                    if (fromsArr[trans.m_state].size == fromsArr[trans.m_state].maxSize) {
                        fromsArr[trans.m_state].trans = CWMappedFA.copyRealloc(fromsArr[trans.m_state].trans, fromsArr[trans.m_state].maxSize, fromsArr[trans.m_state].maxSize * 2);
                        fromsArr[trans.m_state].maxSize *= 2;
                    }
                    fromsArr[trans.m_state].trans[fromsArr[trans.m_state].size] = new STrans();
                    fromsArr[trans.m_state].trans[fromsArr[trans.m_state].size].m_evt = trans.m_evt;
                    fromsArr[trans.m_state].trans[fromsArr[trans.m_state].size].m_state = i3;
                    ++fromsArr[trans.m_state].size;
                    ++j;
                }
                continue;
            }
            this.m_transArr[i3] = null;
        }
        do {
            deadStates = 0;
            for (int i4 = 0; i4 < this.m_nstates; ++i4) {
                int j3;
                if (this.m_transArr[i4] == null || this.m_transArr[i4].size != 1 || fromsArr[i4] == null || fromsArr[i4].size != 1 || this.m_transArr[i4].trans[0].m_evt != 256 || fromsArr[i4].trans[0].m_evt != 256) continue;
                for (j3 = 0; j3 < this.m_transArr[fromsArr[i4].trans[0].m_state].size && this.m_transArr[fromsArr[i4].trans[0].m_state].trans[j3].m_state != i4; ++j3) {
                }
                this.m_transArr[fromsArr[i4].trans[0].m_state].trans[j3].m_state = this.m_transArr[i4].trans[0].m_state;
                for (j3 = 0; j3 < fromsArr[this.m_transArr[i4].trans[0].m_state].size && fromsArr[this.m_transArr[i4].trans[0].m_state].trans[j3].m_state != i4; ++j3) {
                }
                fromsArr[this.m_transArr[i4].trans[0].m_state].trans[j3].m_state = fromsArr[i4].trans[0].m_state;
                if (fromsArr[i4].size != 0) {
                    fromsArr[i4].clear();
                }
                if (this.m_transArr[i4].size != 0) {
                    this.m_transArr[i4].clear();
                }
                this.m_statesInSubexp[i4] = null;
                ++deadStates;
            }
        } while (deadStates != 0);
        int[] counters = new int[this.m_nstates];
        do {
            deadStates = 0;
            for (int i5 = 0; i5 < this.m_nstates; ++i5) {
                if (this.m_transArr[i5] == null) continue;
                for (int counter = 0; counter < counters.length; ++counter) {
                    counters[counter] = 0;
                }
                for (j = 0; j < this.m_transArr[i5].size; ++j) {
                    int n = this.m_transArr[i5].trans[j].m_state;
                    counters[n] = counters[n] + 1;
                }
                for (int k = 0; k < this.m_nstates; ++k) {
                    int z;
                    int n;
                    int kSize;
                    int nn;
                    int m;
                    if (counters[k] != 1) continue;
                    for (m = 0; m < this.m_transArr[i5].size && this.m_transArr[i5].trans[m].m_state != k; ++m) {
                    }
                    if (this.m_transArr[i5].trans[m].m_evt != 256) continue;
                    for (nn = 0; this.m_transArr[k] != null && nn < this.m_transArr[k].size && this.m_transArr[k].trans[nn].m_state != i5; ++nn) {
                    }
                    if (this.m_transArr[k] != null && nn < this.m_transArr[k].size) continue;
                    int n2 = kSize = this.m_transArr[k] != null ? this.m_transArr[k].size : 0;
                    if (this.m_transArr[i5].size + kSize > this.m_transArr[i5].maxSize) {
                        this.m_transArr[i5].trans = CWMappedFA.copyRealloc(this.m_transArr[i5].trans, this.m_transArr[i5].maxSize, this.m_transArr[i5].maxSize + kSize);
                        this.m_transArr[i5].maxSize += kSize;
                    }
                    CWFastSet touched = new CWFastSet(this.m_nstates);
                    for (n = 0; this.m_transArr[k] != null && n < this.m_transArr[k].size; ++n) {
                        this.m_transArr[i5].trans[this.m_transArr[i5].size] = this.m_transArr[k].trans[n];
                        ++this.m_transArr[i5].size;
                        if (touched.Find(this.m_transArr[k].trans[n].m_state) != -1) continue;
                        for (z = 0; this.m_transArr[this.m_transArr[k].trans[n].m_state] != null && z < this.m_transArr[this.m_transArr[k].trans[n].m_state].size; ++z) {
                            if (this.m_transArr[this.m_transArr[k].trans[n].m_state].trans[z].m_state != k) continue;
                            this.m_transArr[this.m_transArr[k].trans[n].m_state].trans[z].m_state = i5;
                        }
                        for (z = 0; fromsArr[this.m_transArr[k].trans[n].m_state] != null && z < fromsArr[this.m_transArr[k].trans[n].m_state].size; ++z) {
                            if (fromsArr[this.m_transArr[k].trans[n].m_state].trans[z].m_state != k) continue;
                            fromsArr[this.m_transArr[k].trans[n].m_state].trans[z].m_state = i5;
                        }
                        touched.Append(this.m_transArr[k].trans[n].m_state);
                    }
                    if (fromsArr[i5] == null && fromsArr[k] != null) {
                        fromsArr[i5] = new STransList();
                        fromsArr[i5].trans = new STrans[fromsArr[k].size];
                        fromsArr[i5].maxSize = fromsArr[k].size;
                    }
                    if (fromsArr[i5] != null && fromsArr[i5].size + fromsArr[k].size > fromsArr[i5].maxSize) {
                        fromsArr[i5].trans = CWMappedFA.copyRealloc(fromsArr[i5].trans, fromsArr[i5].maxSize, fromsArr[i5].maxSize + fromsArr[k].size);
                        fromsArr[i5].maxSize += fromsArr[k].size;
                    }
                    for (n = 0; n < fromsArr[k].size; ++n) {
                        if (fromsArr[k].trans[n].m_state == i5) continue;
                        if (fromsArr[i5].trans == null) {
                            fromsArr[i5].trans = new STrans[this.m_nstates];
                        }
                        fromsArr[i5].trans[fromsArr[i5].size] = fromsArr[k].trans[n];
                        ++fromsArr[i5].size;
                        if (touched.Find(fromsArr[k].trans[n].m_state) != -1) continue;
                        for (z = 0; z < this.m_transArr[fromsArr[k].trans[n].m_state].size; ++z) {
                            if (this.m_transArr[fromsArr[k].trans[n].m_state].trans[z].m_state != k) continue;
                            this.m_transArr[fromsArr[k].trans[n].m_state].trans[z].m_state = i5;
                        }
                        touched.Append(fromsArr[k].trans[n].m_state);
                    }
                    --this.m_transArr[i5].size;
                    this.m_transArr[i5].trans[m].m_state = this.m_transArr[i5].trans[this.m_transArr[i5].size].m_state;
                    this.m_transArr[i5].trans[m].m_evt = this.m_transArr[i5].trans[this.m_transArr[i5].size].m_evt;
                    if (fromsArr[k].size != 0) {
                        fromsArr[k].clear();
                    }
                    if (this.m_transArr[k] != null && this.m_transArr[k].size != 0) {
                        this.m_transArr[k].clear();
                    }
                    if (k == this.m_accState) {
                        this.m_accState = i5;
                    }
                    if (this.m_statesInSubexp[k] != null) {
                        if (this.m_statesInSubexp[i5] == null) {
                            this.m_statesInSubexp[i5] = this.m_statesInSubexp[k];
                            this.m_statesInSubexp[k] = null;
                        } else {
                            this.m_statesInSubexp[i5].Append(this.m_statesInSubexp[k]);
                            this.m_statesInSubexp[k] = null;
                        }
                    }
                    ++deadStates;
                }
            }
        } while (deadStates != 0);
        counters = null;
        fromsArr = null;
        CWFastSet outsideStateSubexps = new CWFastSet(this.GetSubexpCount());
        CWFastSet insideStateSubexps = new CWFastSet(this.GetSubexpCount());
        int subexp = -1;
        this.m_boundaries = new BoundaryHolder[this.m_nstates];
        for (int i6 = 0; i6 < this.m_nstates; ++i6) {
            if (this.m_transArr[i6] == null) continue;
            for (int j4 = 0; j4 < this.m_transArr[i6].size; ++j4) {
                int k;
                if (this.m_transArr[i6].trans[j4].m_evt == 261) {
                    this.m_transArr[i6].trans[j4].m_evt = 256;
                    continue;
                }
                if (this.m_transArr[i6].trans[j4].m_evt == 262) {
                    outsideStateSubexps.Empty();
                    insideStateSubexps.Empty();
                    this.StatesInsideSubexp(this.m_transArr[i6].trans[j4].m_state, insideStateSubexps);
                    if (this.StatesInsideSubexp(i6, outsideStateSubexps)) {
                        for (k = 0; k < insideStateSubexps.GetCount(); ++k) {
                            if (outsideStateSubexps.Find(insideStateSubexps.elementAt(k)) != -1) continue;
                            subexp = insideStateSubexps.elementAt(k);
                            break;
                        }
                    } else {
                        subexp = insideStateSubexps.elementAt(0);
                    }
                    this.AddBoundaryTransition(i6, this.m_transArr[i6].trans[j4].m_state, subexp, 262);
                    this.m_transArr[i6].trans[j4].m_evt = 256;
                    continue;
                }
                if (this.m_transArr[i6].trans[j4].m_evt != 263) continue;
                outsideStateSubexps.Empty();
                insideStateSubexps.Empty();
                this.StatesInsideSubexp(i6, insideStateSubexps);
                if (this.StatesInsideSubexp(this.m_transArr[i6].trans[j4].m_state, outsideStateSubexps)) {
                    for (k = 0; k < insideStateSubexps.GetCount(); ++k) {
                        if (outsideStateSubexps.Find(insideStateSubexps.elementAt(k)) != -1) continue;
                        subexp = insideStateSubexps.elementAt(k);
                        break;
                    }
                } else {
                    subexp = insideStateSubexps.elementAt(0);
                }
                this.AddBoundaryTransition(i6, this.m_transArr[i6].trans[j4].m_state, subexp, 263);
                this.m_transArr[i6].trans[j4].m_evt = 256;
            }
        }
        int threshold = 4;
        for (int i7 = 0; i7 < this.m_nstates; ++i7) {
            if (this.m_transArr[i7] == null || this.m_transArr[i7].size <= threshold) continue;
            boolean varyingEvents = false;
            this.m_transArr[i7].transByEvent = new STargetList[260];
            for (int j5 = 0; j5 < this.m_transArr[i7].size; ++j5) {
                if (this.m_transArr[i7].transByEvent[this.m_transArr[i7].trans[j5].m_evt] == null) {
                    varyingEvents = j5 > 0;
                    this.m_transArr[i7].transByEvent[this.m_transArr[i7].trans[j5].m_evt] = new STargetList();
                }
                int[] newTargets = new int[this.m_transArr[i7].transByEvent[this.m_transArr[i7].trans[j5].m_evt].size + 1];
                for (int k = 0; k < this.m_transArr[i7].transByEvent[this.m_transArr[i7].trans[j5].m_evt].size; ++k) {
                    newTargets[k] = this.m_transArr[i7].transByEvent[this.m_transArr[i7].trans[j5].m_evt].targets[k];
                }
                newTargets[k] = this.m_transArr[i7].trans[j5].m_state;
                this.m_transArr[i7].transByEvent[this.m_transArr[i7].trans[j5].m_evt].targets = newTargets;
                ++this.m_transArr[i7].transByEvent[this.m_transArr[i7].trans[j5].m_evt].size;
            }
            if (varyingEvents) continue;
            this.m_transArr[i7].transByEvent = null;
        }
        this.m_finalised = true;
    }

    @Override
    public void AddSubExpression(int subexpNum, int startState) {
        CWFastSet seStates = new CWFastSet(this.m_nstates);
        seStates.Append(startState);
        CWFastSet toSet = new CWFastSet(this.m_nstates);
        for (int pos = 0; pos < seStates.GetCount(); ++pos) {
            this.ToStatesFromState(seStates.elementAt(pos), toSet);
            seStates.Append(toSet);
            toSet.Empty();
        }
        if (subexpNum >= this.subexpStates.size()) {
            this.subexpStates.setSize(subexpNum + 1);
        }
        this.subexpStates.setElementAt(seStates, subexpNum);
    }

    static STrans[] copyRealloc(STrans[] oldMem, int oldSize, int newSize) {
        STrans[] newMem = new STrans[newSize];
        System.arraycopy(oldMem, 0, newMem, 0, oldSize);
        return newMem;
    }

    public boolean ToStatesFromState(int i_from, CWFastSet o_toset) {
        boolean retval = false;
        if (this.m_finalised) {
            STransList tList = this.m_transArr[i_from];
            for (int i2 = 0; i2 < tList.size; ++i2) {
                o_toset.Append(tList.trans[i2].m_state);
            }
            retval = !o_toset.IsEmpty();
        } else {
            Vector stateTrans = (Vector)this.m_transByFromState.get(new Integer(i_from));
            if (stateTrans != null) {
                Enumeration e = stateTrans.elements();
                while (e.hasMoreElements()) {
                    STrans trans = (STrans)e.nextElement();
                    o_toset.Append(trans.m_state);
                    retval = true;
                }
            }
        }
        return retval;
    }

    public void AddBoundaryTransition(int startState, int endState, int subexp, int type) {
        if (this.m_boundaries == null) {
            this.m_boundaries = new BoundaryHolder[this.m_nstates];
        }
        if (this.m_boundaries[startState] != null) {
            Boundary[] newBounds = new Boundary[this.m_boundaries[startState].size + 1];
            System.arraycopy(this.m_boundaries[startState].bounds, 0, newBounds, 0, this.m_boundaries[startState].size);
            this.m_boundaries[startState].bounds = newBounds;
        } else {
            this.m_boundaries[startState] = new BoundaryHolder();
            this.m_boundaries[startState].bounds = new Boundary[1];
        }
        int index = this.m_boundaries[startState].size++;
        this.m_boundaries[startState].bounds[index] = new Boundary();
        this.m_boundaries[startState].bounds[index].endState = endState;
        this.m_boundaries[startState].bounds[index].subexp = subexp;
        this.m_boundaries[startState].bounds[index].type = type;
    }

    private class BoundaryHolder {
        public int size = 0;
        public Boundary[] bounds = null;
    }

    private class Boundary {
        public int endState;
        public int subexp;
        public int type;

        private Boundary() {
        }
    }

    private class STransList {
        public STrans[] trans = null;
        public int size = 0;
        public int maxSize = 0;
        public STargetList[] transByEvent = null;

        public void clear() {
            if (this.size > 0 && this.trans != null) {
                this.trans = null;
                this.size = 0;
            }
        }
    }

    private class STargetList {
        public int size = 0;
        public int[] targets = null;
    }

    private class STrans {
        public int m_evt;
        public int m_state;

        private STrans() {
        }
    }
}

