/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.re;

public class CWFastSet
implements Cloneable {
    private int size;
    private boolean[] set;
    private int[] values;
    private int count;

    public CWFastSet(int maxSize) {
        this.size = maxSize;
        this.count = 0;
        this.set = new boolean[this.size];
        this.values = new int[this.size];
    }

    public int Find(int value) {
        return value < this.size ? (this.set[value] ? 1 : -1) : -1;
    }

    public int elementAt(int i2) {
        return i2 < this.count ? this.values[i2] : -1;
    }

    public void Append(int value) {
        if (value < this.size && !this.set[value]) {
            this.set[value] = true;
            this.values[this.count++] = value;
        }
    }

    public void Append(CWFastSet iset) {
        for (int i2 = 0; i2 < iset.count; ++i2) {
            if (this.set[iset.values[i2]]) continue;
            this.set[iset.values[i2]] = true;
            this.values[this.count++] = iset.values[i2];
        }
    }

    public Object clone() {
        CWFastSet copy = null;
        try {
            copy = (CWFastSet)super.clone();
            copy.set = (boolean[])this.set.clone();
            copy.values = (int[])this.values.clone();
        }
        catch (CloneNotSupportedException ce) {
            System.out.println("*** FastSet.clone: exception - " + ce);
        }
        return copy;
    }

    public int GetSize() {
        return this.size;
    }

    public boolean IsEmpty() {
        return this.count == 0;
    }

    public int GetCount() {
        return this.count;
    }

    public void Empty() {
        for (int i2 = 0; i2 < this.count; ++i2) {
            this.set[this.values[i2]] = false;
        }
        this.count = 0;
    }
}

