/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.re;

import java.io.PrintStream;
import oracle.bm.util.re.CWFastSet;
import oracle.bm.util.re.FAQuerier;
import oracle.bm.util.re.RegExpConstants;

public class CWAutomatonState
implements RegExpConstants,
Cloneable {
    private FAQuerier parent;
    private CWFastSet currentState;
    private int subexpCount;
    private match[] matches;
    private CWFastSet PerformTransitionSet_nextState;
    private CWFastSet PerformTransitionSet_inSet;
    private CWFastSet PerformTransitionSet_outSet;
    private CWFastSet TraverseEvents_toset;

    public CWAutomatonState(FAQuerier a_parent, int startState) {
        this.parent = a_parent;
        this.subexpCount = this.parent.GetSubexpCount();
        this.currentState = new CWFastSet(this.parent.GetMaxState());
        this.PerformTransitionSet_nextState = new CWFastSet(this.parent.GetMaxState());
        this.PerformTransitionSet_inSet = new CWFastSet(this.subexpCount);
        this.PerformTransitionSet_outSet = new CWFastSet(this.subexpCount);
        this.TraverseEvents_toset = new CWFastSet(this.parent.GetMaxState());
        this.matches = new match[this.subexpCount + 1];
        for (int i2 = 0; i2 < this.subexpCount + 1; ++i2) {
            this.matches[i2] = new match();
        }
        this.currentState.Append(startState);
        this.TraverseEvents(this.currentState, this.currentState, 256);
    }

    public Object clone() {
        try {
            CWAutomatonState copy = (CWAutomatonState)super.clone();
            copy.matches = new match[this.matches.length];
            for (int i2 = 0; i2 < this.matches.length; ++i2) {
                copy.matches[i2] = (match)this.matches[i2].clone();
            }
            copy.currentState = (CWFastSet)this.currentState.clone();
            copy.PerformTransitionSet_nextState = (CWFastSet)this.PerformTransitionSet_nextState.clone();
            copy.PerformTransitionSet_inSet = (CWFastSet)this.PerformTransitionSet_inSet.clone();
            copy.PerformTransitionSet_outSet = (CWFastSet)this.PerformTransitionSet_outSet.clone();
            copy.TraverseEvents_toset = (CWFastSet)this.TraverseEvents_toset.clone();
            return copy;
        }
        catch (CloneNotSupportedException ce) {
            return null;
        }
    }

    public boolean IsAccept() {
        return this.currentState.Find(this.parent.GetAcceptState()) != -1;
    }

    public boolean IsValid() {
        return !this.currentState.IsEmpty();
    }

    public boolean NextState(int event) {
        this.PerformTransitionSet(event);
        return this.IsValid() && !this.IsAccept();
    }

    public boolean Lookahead(int event) {
        boolean retval = false;
        if (this.IsValid()) {
            this.TraverseEvents(this.currentState, this.PerformTransitionSet_nextState, event);
            retval = !this.PerformTransitionSet_nextState.IsEmpty();
            this.PerformTransitionSet_nextState.Empty();
        }
        return retval;
    }

    public int GetSubexpCount() {
        return this.subexpCount;
    }

    public String GetSubexp(int subexp) {
        return subexp <= this.GetSubexpCount() && (subexp == 0 || this.matches[subexp].matched) ? this.matches[subexp].text.toString() : "";
    }

    public void Dump(PrintStream out) {
        out.println("+++ AutomatonState states -");
        for (int pos = 0; pos < this.currentState.GetCount(); ++pos) {
            out.print(Integer.toString(this.currentState.elementAt(pos)) + "; ");
        }
        out.print("\n");
    }

    private void PerformTransitionSet(int event) {
        int i2;
        if (!this.IsValid()) {
            return;
        }
        for (i2 = 1; i2 <= this.subexpCount; ++i2) {
            this.matches[i2].openBound = false;
        }
        if (this.parent.SubexpBoundaryCrossed(this.currentState, this.PerformTransitionSet_inSet, this.PerformTransitionSet_outSet)) {
            for (i2 = 0; i2 < this.PerformTransitionSet_inSet.GetCount(); ++i2) {
                this.matches[this.PerformTransitionSet_inSet.elementAt((int)i2) + 1].openBound = true;
            }
        }
        this.PerformTransitionSet_inSet.Empty();
        this.PerformTransitionSet_outSet.Empty();
        this.TraverseEvents(this.currentState, this.PerformTransitionSet_nextState, event);
        if (event == 258 || event == 259) {
            this.currentState.Append(this.PerformTransitionSet_nextState);
        } else {
            this.currentState = (CWFastSet)this.PerformTransitionSet_nextState.clone();
        }
        for (i2 = 0; i2 < this.currentState.GetCount(); ++i2) {
            if (i2 == 0 && event != 258 && event != 259) {
                this.matches[0].text.append((char)event);
            }
            if (this.parent.StatesInsideSubexp(this.currentState.elementAt(i2), this.PerformTransitionSet_inSet)) {
                for (int j = 0; j < this.PerformTransitionSet_inSet.GetCount(); ++j) {
                    if (this.matches[this.PerformTransitionSet_inSet.elementAt((int)j) + 1].openBound) {
                        this.matches[this.PerformTransitionSet_inSet.elementAt((int)j) + 1].text.setLength(0);
                        this.matches[this.PerformTransitionSet_inSet.elementAt((int)j) + 1].matched = false;
                    }
                    if (event == 258 || event == 259) continue;
                    this.matches[this.PerformTransitionSet_inSet.elementAt((int)j) + 1].text.append((char)event);
                }
            }
            this.PerformTransitionSet_inSet.Empty();
        }
        this.PerformTransitionSet_nextState.Empty();
        this.TraverseEvents(this.currentState, this.currentState, 256);
        if (this.parent.SubexpBoundaryCrossed(this.currentState, this.PerformTransitionSet_inSet, this.PerformTransitionSet_outSet)) {
            for (i2 = 0; i2 < this.PerformTransitionSet_outSet.GetCount(); ++i2) {
                this.matches[this.PerformTransitionSet_outSet.elementAt((int)i2) + 1].matched = true;
            }
        }
        this.PerformTransitionSet_inSet.Empty();
        this.PerformTransitionSet_outSet.Empty();
    }

    private void TraverseEvents(CWFastSet source, CWFastSet target, int event) {
        for (int pos = 0; pos < source.GetCount(); ++pos) {
            this.parent.ToStatesForEvent(source.elementAt(pos), event, this.TraverseEvents_toset);
            target.Append(this.TraverseEvents_toset);
            this.TraverseEvents_toset.Empty();
        }
    }

    private class match
    implements Cloneable {
        public StringBuffer text = new StringBuffer();
        public boolean openBound = false;
        public boolean matched = false;

        public Object clone() {
            try {
                match copy = (match)super.clone();
                copy.text = new StringBuffer(this.text.toString());
                return copy;
            }
            catch (CloneNotSupportedException ce) {
                return null;
            }
        }
    }
}

