/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.progress;

import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import oracle.bm.util.progress.ProgressMonitor;
import oracle.ide.log.LogManager;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;

public class IDEProgressMonitor
extends ProgressMonitor {
    private Component m_parent;
    private IndeterminateProgressMonitor m_monitor;
    private int m_noteCount;

    public IDEProgressMonitor(Component parent, String title) {
        this.m_parent = parent;
        this.m_monitor = new IndeterminateProgressMonitor(parent, title);
        this.m_monitor.setCloseOnFinish(true);
        this.setPhase("");
    }

    @Override
    public void start() {
        Thread.currentThread().setPriority(1);
        this.m_monitor.start();
    }

    @Override
    public void setPhase(String message) {
        this.m_monitor.getPanel().setMessage(message == null ? "" : message);
        this.m_monitor.getPanel().setNote("");
    }

    @Override
    public void setNote(ProgressMonitor.Descriptor descriptor) {
        if ((this.m_noteCount++ & 0xFF) == 0) {
            String note = descriptor.getNote();
            this.m_monitor.getPanel().setNote(note == null ? "" : note);
        }
    }

    @Override
    public boolean isCancelled() {
        return this.m_monitor.isCancelled();
    }

    @Override
    public void finish(final String message) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    IDEProgressMonitor.this.m_monitor.finish();
                    if (message != null) {
                        LogManager.getLogManager().getMsgPage().log((Object)message);
                    }
                }
            });
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void reportException(Exception e) {
        Component parent = this.m_monitor.getComponent();
        if (!this.m_monitor.getComponent().isVisible()) {
            parent = this.m_parent;
        }
        ExceptionDialog.showExceptionDialog((Component)parent, (Throwable)e);
    }
}

