/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.log;

import java.io.PrintStream;
import java.util.Properties;
import oracle.bm.util.log.CWLogCategory;
import oracle.bm.util.log.CWLogProvider;
import oracle.bm.util.log.CWStackInspector;

public class CWSimpleLogger
implements CWLogProvider {
    protected CWStackInspector m_stackInspector;
    protected PrintStream m_output;
    protected String[] m_indents = new String[]{null, "", "  ", "    ", "      ", "        "};

    public CWSimpleLogger() {
        this(2000, System.out);
    }

    protected CWSimpleLogger(int stackInspectorCapacity, PrintStream outStream) {
        this.m_stackInspector = new CWStackInspector(stackInspectorCapacity);
        this.m_output = outStream;
    }

    @Override
    public PrintStream getReportStream() {
        return this.m_output;
    }

    @Override
    public boolean getCategoryFlag(CWLogCategory category) {
        return false;
    }

    public synchronized PrintStream changePrintStream(PrintStream newOutput) {
        PrintStream oldOutput = this.m_output;
        this.m_output = newOutput;
        return oldOutput;
    }

    @Override
    public synchronized void trace(int level, Object caller, CWLogCategory category, String message, Object objectToInspect) {
        this.m_output.print(this.m_indents[level]);
        if (category != null) {
            this.m_output.print("[");
            this.m_output.print(category.getName());
            this.m_output.print("] ");
        }
        Class<?> clazz = caller instanceof Class ? (Class<?>)caller : caller.getClass();
        String fullClassName = clazz.getName();
        int i2 = fullClassName.lastIndexOf(46);
        String className = i2 > 0 ? fullClassName.substring(i2 + 1) : fullClassName;
        this.m_output.print(className);
        if (message != null) {
            this.m_output.print(" : ");
            this.m_output.print(message);
        }
        this.m_output.println();
        this.m_output.flush();
    }

    @Override
    public void initialize(Properties properties, PrintStream reportStream) {
        if (reportStream != null) {
            reportStream.println("CWSimpleLogger is providing diagnostics");
        }
    }

    @Override
    public void shutdown() {
    }
}

