/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.log;

import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import oracle.bm.util.log.CWLogCategory;
import oracle.bm.util.log.CWLogDriver;
import oracle.bm.util.log.CWLogEvent;
import oracle.bm.util.log.CWLogFilter;
import oracle.bm.util.log.CWLogPlugIn;
import oracle.bm.util.log.CWLogProcessor;
import oracle.bm.util.log.CWLogProvider;
import oracle.bm.util.log.CWStackInspector;

public class CWLogger
implements CWLogProvider {
    protected PrintStream m_reportStream;
    protected CWLogFilter[] m_logFilters;
    protected CWLogProcessor[] m_logProcessors;
    protected CWLogDriver[] m_logDrivers;
    protected long m_nextLogEventId;
    protected Object m_queueLock;
    protected CWLogEvent[] m_logEvents;
    protected CWStackInspector m_stackInspector;

    @Override
    public void initialize(Properties properties, PrintStream reportStream) {
        int i2;
        this.m_reportStream = reportStream;
        CWLogPlugIn[] plugIns = this.createAndInitializePlugIns(properties, "CWLogger.filter.");
        int size = 0;
        for (i2 = 0; i2 < plugIns.length; ++i2) {
            if (plugIns[i2] == null || !(plugIns[i2] instanceof CWLogFilter)) continue;
            ++size;
        }
        this.m_logFilters = new CWLogFilter[size];
        size = 0;
        for (i2 = 0; i2 < plugIns.length; ++i2) {
            if (plugIns[i2] == null) continue;
            this.m_logFilters[size++] = (CWLogFilter)plugIns[i2];
        }
        plugIns = this.createAndInitializePlugIns(properties, "CWLogger.proc.");
        size = 0;
        for (i2 = 0; i2 < plugIns.length; ++i2) {
            if (plugIns[i2] == null || !(plugIns[i2] instanceof CWLogProcessor)) continue;
            ++size;
        }
        this.m_logProcessors = new CWLogProcessor[size];
        size = 0;
        for (i2 = 0; i2 < plugIns.length; ++i2) {
            if (plugIns[i2] == null) continue;
            this.m_logProcessors[size++] = (CWLogProcessor)plugIns[i2];
        }
        plugIns = this.createAndInitializePlugIns(properties, "CWLogger.driver.");
        size = 0;
        for (i2 = 0; i2 < plugIns.length; ++i2) {
            if (plugIns[i2] == null || !(plugIns[i2] instanceof CWLogDriver)) continue;
            try {
                ((CWLogDriver)plugIns[i2]).open();
                ++size;
                continue;
            }
            catch (Throwable t) {
                if (reportStream != null) {
                    reportStream.print("Error opening CWLogDriver : ");
                    t.printStackTrace(reportStream);
                }
                plugIns[i2] = null;
            }
        }
        this.m_logDrivers = new CWLogDriver[size];
        size = 0;
        for (i2 = 0; i2 < plugIns.length; ++i2) {
            if (plugIns[i2] == null) continue;
            this.m_logDrivers[size++] = (CWLogDriver)plugIns[i2];
        }
        this.m_logEvents = new CWLogEvent[1];
        for (i2 = 0; i2 < this.m_logEvents.length; ++i2) {
            this.m_logEvents[i2] = new CWLogEvent();
        }
        this.m_nextLogEventId = 0L;
        this.m_queueLock = new Object();
        this.m_stackInspector = new CWStackInspector(4000);
    }

    @Override
    public PrintStream getReportStream() {
        return this.m_reportStream;
    }

    @Override
    public boolean getCategoryFlag(CWLogCategory category) {
        return false;
    }

    @Override
    public void shutdown() {
        for (int i2 = 0; i2 < this.m_logDrivers.length; ++i2) {
            try {
                this.m_logDrivers[i2].close();
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.m_logFilters = null;
        this.m_logProcessors = null;
        this.m_logDrivers = null;
        this.m_queueLock = null;
        this.m_logEvents = null;
        this.m_reportStream = null;
        this.m_stackInspector = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void trace(int level, Object caller, CWLogCategory category, String message, Object objectToInspect) {
        for (int i2 = 0; i2 < this.m_logFilters.length; ++i2) {
            try {
                if (this.m_logFilters[i2].isTraceLoggable(level, caller, category, message, objectToInspect)) continue;
                return;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        Object object = this.m_queueLock;
        synchronized (object) {
            CWLogEvent logEvent = this.getNextLogEventToFillIn();
            logEvent.m_id = this.m_nextLogEventId++;
            logEvent.m_level = level;
            logEvent.m_message = message;
            if (category != null) {
                logEvent.m_categoryName = category.getName();
                logEvent.m_categoryFlags = category.getDesignerCategory();
            } else {
                logEvent.m_categoryName = null;
                logEvent.m_categoryFlags = 0;
            }
            if (caller != null) {
                Class<?> clazz = caller instanceof Class ? (Class<?>)caller : caller.getClass();
                logEvent.m_className = clazz.getName();
                logEvent.m_packageNameLength = logEvent.m_className.lastIndexOf(46);
            } else {
                logEvent.m_className = "?Unknown class name?";
                logEvent.m_packageNameLength = 1;
            }
            Thread thread = Thread.currentThread();
            logEvent.m_threadName = thread.getName();
            logEvent.m_threadHash = System.identityHashCode(thread);
            logEvent.clearExtras();
            for (int i3 = 0; i3 < this.m_logProcessors.length; ++i3) {
                try {
                    this.m_logProcessors[i3].processTrace(logEvent, level, caller, category, message, objectToInspect);
                    continue;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            this.deliverLogEvent();
        }
    }

    private CWLogEvent getNextLogEventToFillIn() {
        return this.m_logEvents[0];
    }

    private void deliverLogEvent() {
        for (int i2 = 0; i2 < this.m_logDrivers.length; ++i2) {
            try {
                CWLogEvent[] buffer = this.m_logDrivers[i2].getLogEventArray();
                if (buffer == null || buffer.length <= 0) continue;
                buffer[0] = this.m_logEvents[0];
                this.m_logDrivers[i2].processLogEvents(1, 0);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public CWLogEvent getLogEvent(long id) {
        return null;
    }

    private CWLogPlugIn[] createAndInitializePlugIns(Properties properties, String plugInPrefix) {
        CWLogPlugIn[] plugIns = new CWLogPlugIn[100];
        Enumeration<Object> e = properties.keys();
        while (e.hasMoreElements()) {
            String s2;
            String s = (String)e.nextElement();
            if (!s.startsWith(plugInPrefix) || (s2 = s.substring(plugInPrefix.length())).indexOf(46) > -1) continue;
            String className = (String)properties.get(s);
            StringBuffer sb = new StringBuffer();
            sb.append("CWLogger: Error in plugin property\n");
            sb.append("- \"");
            sb.append(s);
            sb.append("=");
            sb.append(className);
            sb.append("\"\n- ");
            String errPrefix = sb.toString();
            int ix = -1;
            try {
                ix = Integer.parseInt(s2);
                plugIns[ix] = (CWLogPlugIn)Class.forName(className).newInstance();
            }
            catch (Throwable t) {
                if (this.m_reportStream == null) continue;
                this.m_reportStream.print(errPrefix);
                this.m_reportStream.print("instantiation failed\n- ");
                this.m_reportStream.println(t.toString());
                continue;
            }
            Hashtable<String, Object> plugInProps = new Hashtable<String, Object>();
            Enumeration<Object> ee = properties.keys();
            while (ee.hasMoreElements()) {
                String ss = (String)ee.nextElement();
                if (!ss.startsWith(s) || ss.length() <= s.length()) continue;
                plugInProps.put(ss.substring(s.length() + 1), properties.get(ss));
            }
            try {
                plugIns[ix].initialize(plugInProps, this.m_reportStream);
            }
            catch (Throwable t) {
                if (this.m_reportStream != null) {
                    this.m_reportStream.print(errPrefix);
                    this.m_reportStream.print("initialization failed\n- ");
                    this.m_reportStream.println(t.toString());
                }
                plugIns[ix] = null;
            }
        }
        return plugIns;
    }
}

