/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.log;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;
import java.util.Vector;
import oracle.bm.util.log.CWLogCategory;
import oracle.bm.util.log.CWLogProvider;
import oracle.bm.util.log.CWLogSettingsListener;

public class CWLog {
    public static final String SYSTEM_PROP_KEY = "oracle.bm.CWLog.config";
    public static final String DIAG_PROP_KEY = "oracle.bm.CWLog.diag";
    public static final String SYSTEM_PROP_VAL_DISABLE = "disable";
    public static final String PROP_FILENAME = "oracle.bm.CWLog.properties";
    public static final String PROP_KEY_ENABLE_ASSERT = "enableAssert";
    public static final String PROP_KEY_TRACE_LEVEL = "traceLevel";
    public static final String PROP_KEY_CLASS_NAME = "logProviderClassName";
    public static final String DEFAULT_ENABLE_ASSERT = "true";
    public static final String DEFAULT_TRACE_LEVEL = "0";
    public static final String DEFAULT_PROVIDER = "oracle.bm.util.log.CWLogger";
    public static final long START_TIME_MILLIS = System.currentTimeMillis();
    public static final boolean TRACE_LEVEL_1 = false;
    public static final boolean TRACE_LEVEL_2 = false;
    public static final boolean TRACE_LEVEL_3 = false;
    public static final boolean TRACE_LEVEL_4 = false;
    public static final boolean TRACE_LEVEL_5 = false;
    static int s_traceLevel;
    static CWLogProvider s_logProvider;
    static PrintStream s_reportStream;
    private static Vector s_listeners;
    private static boolean s_disableInitialization;
    private static boolean s_initializing;

    public static void trace(int level, Object caller, CWLogCategory category, String message, Object objectToInspect) {
        if (s_traceLevel >= level && level > 0 && caller != null) {
            try {
                s_logProvider.trace(level, caller, category, message, objectToInspect);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    public static void trace(int level, Object caller, String message, Object objectToInspect) {
        if (s_traceLevel >= level && level > 0 && caller != null) {
            try {
                s_logProvider.trace(level, caller, null, message, objectToInspect);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    public static void trace(int level, Object caller, CWLogCategory category, String message) {
        if (s_traceLevel >= level && level > 0 && caller != null) {
            try {
                s_logProvider.trace(level, caller, category, message, null);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    public static void trace(int level, Object caller, String message) {
        if (s_traceLevel >= level && level > 0 && caller != null) {
            try {
                s_logProvider.trace(level, caller, null, message, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static int getTraceLevel() {
        return s_traceLevel;
    }

    public static void setTraceLevel(int newTraceLevel) {
        int oldTraceLevel;
        if (s_logProvider == null || newTraceLevel < 0) {
            newTraceLevel = 0;
        }
        if (newTraceLevel > 5) {
            newTraceLevel = 5;
        }
        if ((s_traceLevel = newTraceLevel) != (oldTraceLevel = s_traceLevel)) {
            String message = "CWLog trace level is " + newTraceLevel;
            if (s_reportStream != null) {
                s_reportStream.println(message);
            }
        }
        CWLog.notifyListeners();
    }

    public static CWLogProvider getLogProvider() {
        return s_logProvider;
    }

    public static PrintStream getReportStream() {
        if (s_logProvider != null) {
            return s_logProvider.getReportStream();
        }
        return s_reportStream;
    }

    public static boolean getCategoryFlag(CWLogCategory category) {
        if (s_logProvider != null) {
            return s_logProvider.getCategoryFlag(category);
        }
        return false;
    }

    public static void addListener(CWLogSettingsListener listener) {
        if (s_listeners == null) {
            s_listeners = new Vector();
        }
        s_listeners.addElement(listener);
    }

    public static void removeListener(CWLogSettingsListener listener) {
        if (s_listeners != null) {
            s_listeners.removeElement(listener);
        }
    }

    private static void notifyListeners() {
        block4: {
            try {
                if (s_listeners != null && s_listeners.size() > 0) {
                    Object[] listeners = new CWLogSettingsListener[s_listeners.size()];
                    s_listeners.copyInto(listeners);
                    for (int i2 = 0; i2 < listeners.length; ++i2) {
                        listeners[i2].onCWLogSettingsChange();
                    }
                }
            }
            catch (Throwable t) {
                if (s_reportStream == null) break block4;
                s_reportStream.println("Error notifying CWLogSettingsListeners:");
                s_reportStream.println(t.toString());
            }
        }
    }

    public static boolean initialize(Properties properties, PrintStream reportStream) {
        if (s_initializing) {
            return true;
        }
        if (s_logProvider != null) {
            CWLog.shutdown();
        }
        if (!s_disableInitialization) {
            s_initializing = true;
            s_reportStream = reportStream;
            if (properties == null) {
                properties = CWLog.getPropertiesFromFile(PROP_FILENAME);
            }
            if (properties == null) {
                properties = new Properties();
            }
            if (properties.getProperty(PROP_KEY_TRACE_LEVEL) == null) {
                properties.put(PROP_KEY_TRACE_LEVEL, DEFAULT_TRACE_LEVEL);
            }
            if (properties.getProperty(PROP_KEY_CLASS_NAME) == null) {
                properties.put(PROP_KEY_CLASS_NAME, DEFAULT_PROVIDER);
            }
            try {
                String providerClassName = properties.getProperty(PROP_KEY_CLASS_NAME);
                CWLogProvider provider = (CWLogProvider)Class.forName(providerClassName).newInstance();
                provider.initialize(properties, reportStream);
                s_logProvider = provider;
            }
            catch (Throwable throwable) {
                if (s_reportStream != null) {
                    s_reportStream.println("CWLog failed to initialize provider - diagnostics disabled");
                    s_reportStream.println(throwable.toString());
                }
                s_logProvider = null;
            }
            if (s_logProvider != null) {
                boolean enable = false;
                int level = 0;
                try {
                    String str = properties.getProperty(PROP_KEY_TRACE_LEVEL);
                    level = Integer.parseInt(str);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                s_traceLevel = -1;
                CWLog.setTraceLevel(level);
                if (s_reportStream != null) {
                    s_reportStream.println("CWLog diagnostic service started OK");
                }
            }
            CWLog.notifyListeners();
        }
        s_initializing = false;
        return s_logProvider != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getPropertiesFromFile(String filename) {
        if (s_reportStream != null) {
            s_reportStream.println("CWLog is checking for file '" + filename + "'");
        }
        Properties props = null;
        FileInputStream fis = null;
        String pathSeparator = System.getProperty("file.separator", "\\");
        if (filename.indexOf(pathSeparator) < 0) {
            if (s_reportStream != null) {
                s_reportStream.println("CWLog assuming file in java home as not file seperator");
            }
            String javaHome = System.getProperty("java.home", "");
            StringBuffer sb = new StringBuffer();
            sb.append(javaHome);
            sb.append(pathSeparator);
            sb.append("lib");
            sb.append(pathSeparator);
            sb.append(filename);
            filename = sb.toString();
            if (s_reportStream != null) {
                s_reportStream.println("CWLog has changes filename to '" + filename + "'");
            }
        }
        try {
            fis = new FileInputStream(filename);
            props = new Properties();
            props.load(fis);
        }
        catch (FileNotFoundException e) {
            if (s_reportStream != null) {
                s_reportStream.println("CWLog checked for file '" + filename + "' - not found");
            }
            props = null;
        }
        catch (Throwable t) {
            if (s_reportStream != null) {
                s_reportStream.println("Error reading properties file:");
                s_reportStream.println(t.toString());
            }
            props = null;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        return props;
    }

    public static void shutdown() {
        if (s_logProvider != null) {
            s_logProvider.shutdown();
            s_logProvider = null;
        }
        if (s_reportStream != null) {
            s_reportStream.println("CWLog diagnostic service has shutdown");
        }
        CWLog.notifyListeners();
    }

    private CWLog() {
    }

    static {
        try {
            if (System.getProperty(DIAG_PROP_KEY) != null) {
                s_reportStream = System.err;
                s_reportStream.println("CWLog internal diagnostics enabled");
            } else {
                s_reportStream = null;
            }
            String configString = System.getProperty(SYSTEM_PROP_KEY);
            if (s_reportStream != null) {
                s_reportStream.println("CWLog has found oracle.bm.CWLog.config=" + configString);
            }
            if (configString == null || configString.length() < 1) {
                s_disableInitialization = true;
            } else if (configString.equalsIgnoreCase(SYSTEM_PROP_VAL_DISABLE)) {
                s_disableInitialization = true;
            } else {
                Properties props = CWLog.getPropertiesFromFile(configString);
                CWLog.initialize(props, s_reportStream);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

