/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.listener;

import java.util.ArrayList;

public abstract class AEventingHandler {
    private Class m_listenerType;
    private ArrayList m_listenerList = new ArrayList();

    public AEventingHandler(Class listenerType) {
        if (listenerType == null) {
            throw new IllegalArgumentException("Missing listener type");
        }
        this.m_listenerType = listenerType;
    }

    public boolean hasListeners() {
        return this.m_listenerList.size() > 0;
    }

    public void addListener(Object listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Missing listener");
        }
        if (!this.m_listenerType.isInstance(listener)) {
            throw new IllegalArgumentException("Listener is of wrong type");
        }
        if (this.m_listenerList.contains(listener)) {
            throw new IllegalArgumentException("Listener already in list");
        }
        this.m_listenerList.add(listener);
    }

    public void removeListener(Object listener) {
        if (listener == null) {
            throw new IllegalArgumentException("No listener to remove.");
        }
        int index = this.m_listenerList.indexOf(listener);
        if (index == -1) {
            throw new IllegalArgumentException("Listener was never added");
        }
        this.m_listenerList.remove(index);
    }

    public void fireEvent(Object event) {
        for (int i2 = this.m_listenerList.size() - 1; i2 >= 0; --i2) {
            this.fireEvent(this.m_listenerList.get(i2), event);
        }
    }

    protected abstract void fireEvent(Object var1, Object var2);
}

