/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.alert;

import java.awt.BorderLayout;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bm.util.alert.ErrorDialogMediator;

class ReportPanel
extends JPanel
implements ListSelectionListener {
    private ErrorDialogMediator m_med = null;
    private JList m_list = null;

    ReportPanel(String name, ErrorDialogMediator med) {
        super(null);
        this.setName(name);
        this.m_med = med;
        this.m_med.setReportPanel(this);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.initPanel();
    }

    public void initPanel() {
        JLabel text = new JLabel(" ");
        text.setName("ReportText");
        this.add("North", text);
        this.m_list = new JList();
        this.m_list.addListSelectionListener(this);
        this.m_list.setVisibleRowCount(4);
        JScrollPane scrollArea = new JScrollPane(this.m_list);
        scrollArea.setHorizontalScrollBarPolicy(30);
        scrollArea.setVerticalScrollBarPolicy(20);
        scrollArea.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), scrollArea.getBorder()));
        this.add("Center", scrollArea);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int index = e.getFirstIndex();
        this.m_med.messageSelected(this.m_list.getSelectedIndex());
    }

    void listMessages(String[] messages) {
        DefaultListModel<String> dlm = new DefaultListModel<String>();
        for (int counter = 0; counter < messages.length; ++counter) {
            dlm.addElement(messages[counter]);
        }
        this.m_list.setModel(dlm);
        this.m_list.getSelectionModel().setSelectionInterval(0, 0);
        this.m_med.messageSelected(0);
    }
}

