/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.alert;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.BreakIterator;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import oracle.bali.ewt.graphics.FontUtils;
import oracle.bali.ewt.text.CharacterWrapper;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.util.StringUtils;
import oracle.bm.util.alert.CWExceptionData;
import oracle.bm.util.alert.ErrorDialog;
import oracle.bm.util.alert.ErrorDialogMediator;

class MessagePanel
extends JPanel {
    private ErrorDialogMediator m_med = null;

    MessagePanel(String name, ErrorDialogMediator med) {
        super(null);
        this.setName(name);
        this.m_med = med;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.initPanel();
    }

    public void initPanel() {
        CWExceptionData message = this.m_med.getToplevelMessage();
        if (null != message) {
            this.setLayout(new GridBagLayout());
            Object gblc = null;
            JLabel dummy = new JLabel("   ");
            Icon image = null;
            String type = message.getType();
            image = "I" == type ? UIManager.getIcon("OptionPane.informationIcon") : ("E" == type ? UIManager.getIcon("OptionPane.errorIcon") : UIManager.getIcon("OptionPane.warningIcon"));
            if (image != null) {
                dummy.setIcon(image);
            }
            this.add((Component)dummy, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            MultiLineLabel text = new MultiLineLabel(WordWrapper.getTextWrapper(), message.getMessage());
            String messageText = message.getMessage();
            char[] textChars = messageText.toCharArray();
            int numChars = textChars.length;
            int currIndex = 0;
            int arrayOffset = 0;
            float aspectRatio = text.getPreferredAspectRatio();
            FontMetrics metrics = text.getFontMetrics(text.getFont());
            int stringWidth = metrics.stringWidth(text.getText());
            int lineHeight = metrics.getHeight();
            int avgWidth = FontUtils.getAverageWidth((FontMetrics)metrics);
            int wrapWidth = 0;
            int innerWidth = text.getInnerWidth();
            if (text.getPreferredColumns() == -1 && text.getPreferredRows() == -1) {
                wrapWidth = aspectRatio != 0.0f ? (int)(Math.sqrt((float)stringWidth * (float)lineHeight) * (double)aspectRatio) + 1 : Math.max(0, text.getInnerWidth());
            } else {
                if (text.getPreferredColumns() != -1) {
                    wrapWidth = avgWidth * text.getPreferredColumns();
                }
                if (text.getPreferredRows() != -1 && text.getPreferredColumns() == -1) {
                    int newLineCount = 0;
                    int i2 = 0;
                    while ((i2 = text.getText().indexOf(10, i2) + 1) > 0) {
                        ++newLineCount;
                    }
                    wrapWidth = newLineCount + 1 >= text.getPreferredRows() ? Integer.MAX_VALUE : stringWidth / text.getPreferredRows() * 21 / 20;
                }
            }
            Locale locale = Locale.getDefault();
            BreakIterator wordWrapper = BreakIterator.getLineInstance(locale);
            boolean useCharacterWrap = false;
            wordWrapper.setText(messageText);
            while (currIndex < numChars) {
                int currLineWidth = 0;
                int oldLineWidth = 0;
                int lastIndex = currIndex;
                int nextIndex = currIndex;
                int wordCount = 0;
                do {
                    String displayString;
                    ++wordCount;
                    nextIndex = wordWrapper.next();
                    if (nextIndex == -1) {
                        nextIndex = numChars;
                    }
                    boolean tabInWord = false;
                    for (int i3 = lastIndex; i3 < nextIndex; ++i3) {
                        if (textChars[i3 + arrayOffset] != '\t') continue;
                        tabInWord = true;
                        break;
                    }
                    if (tabInWord) {
                        displayString = new String(textChars, currIndex + arrayOffset, nextIndex - currIndex);
                        displayString = StringUtils.getDisplayString((String)displayString, (Locale)locale, (int)1);
                        currLineWidth = metrics.stringWidth(displayString);
                    } else {
                        displayString = new String(textChars, lastIndex + arrayOffset, nextIndex - lastIndex);
                        displayString = StringUtils.getDisplayString((String)displayString, (Locale)locale, (int)1);
                        currLineWidth += metrics.stringWidth(displayString);
                    }
                    if (currLineWidth > wrapWidth && oldLineWidth != 0) {
                        wordWrapper.previous();
                        break;
                    }
                    lastIndex = nextIndex;
                    oldLineWidth = currLineWidth;
                } while (lastIndex < numChars && currLineWidth <= wrapWidth);
                currIndex = lastIndex;
                if (wordCount != 1 || currLineWidth <= wrapWidth) continue;
                useCharacterWrap = true;
            }
            if (useCharacterWrap) {
                text = new MultiLineLabel(CharacterWrapper.getTextWrapper(), message.getMessage());
            }
            text.setAlignment(1);
            this.add((Component)text, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension parentSize = super.getPreferredSize();
        Dimension m_size = new Dimension(ErrorDialog.m_panelWidth, parentSize.height);
        return m_size;
    }
}

