/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.alert;

import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import oracle.bm.util.ResourcePicker;
import oracle.bm.util.alert.ActionPanel;
import oracle.bm.util.alert.CWAlert;
import oracle.bm.util.alert.CWExceptionData;
import oracle.bm.util.alert.CausePanel;
import oracle.bm.util.alert.ErrorContentPanel;
import oracle.bm.util.alert.ErrorDialog;
import oracle.bm.util.alert.ExpandedPanel;
import oracle.bm.util.alert.RCAPanel;
import oracle.bm.util.alert.ReportPanel;

class ErrorDialogMediator
implements ActionListener {
    private ErrorDialog m_errorDialog = null;
    private ErrorContentPanel m_contentPanel = null;
    private ExpandedPanel m_expandedPanel = null;
    private RCAPanel m_RCAPanel = null;
    private ReportPanel m_reportPanel = null;
    private CausePanel m_causePanel = null;
    private ActionPanel m_actionPanel = null;
    private JButton m_focusButton = null;
    private PopupMenu m_menu = null;
    private boolean m_haveMessages = false;
    private boolean m_expanded = false;
    private Vector m_messages = null;
    private String[] m_errorMessages = null;
    private ResourcePicker m_rp = new ResourcePicker(CWAlert.class);

    ErrorDialogMediator(Vector messages) {
        int i2 = messages.size();
        if (i2 > 0) {
            this.m_errorMessages = new String[i2];
            for (int j = 0; j < i2; ++j) {
                CWExceptionData data = (CWExceptionData)messages.elementAt(j);
                this.m_errorMessages[j] = data.getCode() == null || data.getCode().trim().length() == 0 || "I".equals(data.getType()) ? data.getMessage() : data.getCode() + ":  " + data.getMessage();
            }
            this.m_messages = messages;
            this.m_haveMessages = true;
        }
    }

    void setFocusButton(JButton button) {
        this.m_focusButton = button;
    }

    void setErrorDialog(ErrorDialog dialog) {
        this.m_errorDialog = dialog;
    }

    void setContentPanel(ErrorContentPanel panel) {
        this.m_contentPanel = panel;
    }

    void setExpandedPanel(ExpandedPanel panel) {
        this.m_expandedPanel = panel;
    }

    void setRCAPanel(RCAPanel panel) {
        this.m_RCAPanel = panel;
    }

    void setReportPanel(ReportPanel panel) {
        this.m_reportPanel = panel;
    }

    void setCausePanel(CausePanel panel) {
        this.m_causePanel = panel;
    }

    void setActionPanel(ActionPanel panel) {
        this.m_actionPanel = panel;
    }

    ResourcePicker getRP() {
        return this.m_rp;
    }

    ErrorDialog getErrorDialog() {
        return this.m_errorDialog;
    }

    void onShow() {
        this.readExpandedState();
        if (this.m_expanded) {
            this.m_contentPanel.toggleShowHideButtonText();
        }
        this.m_expandedPanel.setVisible(this.m_expanded);
        this.m_focusButton.requestFocus();
        if (this.m_haveMessages) {
            this.m_reportPanel.listMessages(this.m_errorMessages);
        }
    }

    void messageSelected(int index) {
        this.m_causePanel.displayCause(((CWExceptionData)this.m_messages.elementAt(index)).getCause());
        this.m_actionPanel.displayAction(((CWExceptionData)this.m_messages.elementAt(index)).getAction());
    }

    CWExceptionData getToplevelMessage() {
        if (this.m_haveMessages) {
            return (CWExceptionData)this.m_messages.elementAt(0);
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        boolean copyCauseAction = true;
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringBuffer messageStack = new StringBuffer();
        for (int i2 = 0; i2 < this.m_errorMessages.length; ++i2) {
            messageStack.append(this.m_rp.getString("ClipMsg"));
            messageStack.append(this.m_errorMessages[i2]);
            if (copyCauseAction) {
                messageStack.append(this.m_rp.getString("ClipCause"));
                messageStack.append(((CWExceptionData)this.m_messages.elementAt(i2)).getCause());
                messageStack.append(this.m_rp.getString("ClipAction"));
                messageStack.append(((CWExceptionData)this.m_messages.elementAt(i2)).getAction());
            }
            messageStack.append(this.m_rp.getString("ClipSeparator"));
        }
        StringSelection sel = new StringSelection(messageStack.toString());
        cb.setContents(sel, null);
    }

    void closeDialog() {
        this.m_errorDialog.setVisible(false);
    }

    void toggleDialog() {
        this.m_expanded = !this.m_expanded;
        this.dialogExpanded();
    }

    void dialogExpanded() {
        this.m_contentPanel.toggleShowHideButtonText();
        this.m_expandedPanel.setVisible(this.m_expanded);
        this.m_errorDialog.pack();
    }

    void saveExpandedState() {
    }

    void readExpandedState() {
    }
}

