/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.alert;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import oracle.bm.util.alert.ErrorContentPanel;
import oracle.bm.util.alert.ErrorDialogMediator;
import oracle.bm.util.alert.Util;
import oracle.ide.Ide;

public class ErrorDialog
extends JDialog {
    static int m_panelWidth = 480;
    static int m_panelHeight = 100;
    private ErrorDialogMediator m_med = null;

    private ErrorDialog(Frame parent, Vector messages) {
        super(parent, true);
        this.initDialog(messages);
    }

    private ErrorDialog(Dialog parent, Vector messages) {
        super(parent, true);
        this.initDialog(messages);
    }

    private void initDialog(Vector messages) {
        this.setName("ExceptionDialog");
        this.setResizable(true);
        if (null == messages) {
            throw new IllegalArgumentException("ErrorDialog: null message vector");
        }
        this.m_med = new ErrorDialogMediator(messages);
        this.m_med.setErrorDialog(this);
        ErrorContentPanel cp = new ErrorContentPanel("Content", this.m_med);
        this.getContentPane().add((Component)cp, "Center");
    }

    void closedown() {
        this.m_med.saveExpandedState();
    }

    public int runDialog() {
        this.firstShow();
        this.setVisible(true);
        return 0;
    }

    protected void firstShow() throws IllegalStateException {
        this.m_med.getRP().start(this);
        this.m_med.onShow();
        this.pack();
        this.setResizable(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                Window w = e.getWindow();
                Dimension d = w.getSize();
                ++d.width;
                w.setSize(d);
                Dimension szScreen = Toolkit.getDefaultToolkit().getScreenSize();
                Rectangle rectThis = w.getBounds();
                int nX = szScreen.width / 2 - rectThis.width / 2;
                int nY = szScreen.height / 2 - rectThis.height / 2;
                w.setLocation(nX, nY);
            }
        });
        Dimension d = this.getSize();
        ++d.width;
        this.setSize(d);
        Dimension szScreen = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle rectThis = this.getBounds();
        int nX = szScreen.width / 2 - rectThis.width / 2;
        int nY = szScreen.height / 2 - rectThis.height / 2;
        this.setLocation(nX, nY);
        this.pack();
    }

    public static ErrorDialog createErrorDialog(Component parent, Vector messages) {
        ErrorDialog dialog = null;
        while (parent != null) {
            if (parent instanceof Dialog) {
                dialog = new ErrorDialog((Dialog)parent, messages);
                break;
            }
            if (parent instanceof Frame) {
                dialog = new ErrorDialog((Frame)parent, messages);
                break;
            }
            parent = SwingUtilities.getWindowAncestor(parent);
        }
        if (dialog == null) {
            dialog = new ErrorDialog((Frame)Ide.getMainWindow(), messages);
        }
        return dialog;
    }

    public static void main(String[] argv) throws Exception {
        Util.main(new String[]{"oracle"});
        System.exit(0);
    }
}

