/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.alert;

import java.awt.Component;
import java.awt.Frame;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingUtilities;
import oracle.bm.util.alert.CWAlertData;
import oracle.bm.util.alert.CWAlertUI;
import oracle.bm.util.alert.CWExceptionData;
import oracle.bm.util.alert.Defs;
import oracle.bm.util.alert.ErrorDialog;
import oracle.ide.Ide;
import oracle.ide.util.Assert;

public class CWException
extends Exception
implements CWAlertUI,
Defs {
    private Vector m_messages = null;
    private Vector m_alerts = new Vector();

    public CWException() {
    }

    public CWException(CWException e) {
        if (null != e.m_messages) {
            this.m_messages = (Vector)e.m_messages.clone();
        }
        if (null != e.m_alerts) {
            this.m_alerts = (Vector)e.m_alerts.clone();
        }
    }

    public CWException(CWAlertData data) throws IllegalArgumentException {
        this.addAlert(data);
    }

    public CWException(String packageName, String key) throws IllegalArgumentException {
        CWAlertData data = new CWAlertData();
        data.setPackageName(packageName);
        data.setKey(key);
        this.addAlert(data);
    }

    public CWException(String packageName, String key, String param) throws IllegalArgumentException {
        CWAlertData data = new CWAlertData();
        data.setPackageName(packageName);
        data.setKey(key);
        data.setMsgParams(new String[]{param});
        this.addAlert(data);
    }

    public void addAlert(CWAlertData data) throws IllegalArgumentException {
        if (null == data) {
            throw new IllegalArgumentException("addAlert - null argument");
        }
        this.m_alerts.addElement(data);
    }

    public int showAlert(Frame parent) {
        return this.showAlert((Component)parent);
    }

    @Override
    public int showAlert(Component parent) {
        return this.showAlert(parent, Ide.getProgramName());
    }

    public int showAlert(Component parent, String title) {
        try {
            return this.showAlertImpl(parent, title);
        }
        catch (Throwable ex) {
            Assert.printStackTrace((Throwable)ex);
            return 0;
        }
    }

    private int showAlertImpl(final Component parent, String title) throws Exception {
        String alternativeTitle;
        if (!SwingUtilities.isEventDispatchThread()) {
            final int[] result = new int[1];
            try {
                final String t = title;
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        result[0] = CWException.this.showAlert(parent, t);
                    }
                });
                return result[0];
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
                return 0;
            }
        }
        this.buildMessageStack();
        if (this.m_messages.size() > 0 && (alternativeTitle = ((CWExceptionData)this.m_messages.get(0)).getTitle()) != null && !"".equals(alternativeTitle)) {
            title = alternativeTitle;
        }
        try {
            ErrorDialog dlg = ErrorDialog.createErrorDialog(parent, this.m_messages);
            dlg.setTitle(title);
            int closeButton = dlg.runDialog();
            dlg.closedown();
            dlg.dispose();
            return closeButton;
        }
        catch (Throwable t) {
            return 8;
        }
    }

    public Enumeration getAlerts() {
        this.buildMessageStack();
        return this.m_messages.elements();
    }

    public Iterator getAlertsIte() {
        this.buildMessageStack();
        return this.m_messages.iterator();
    }

    public Iterator getAlertsDataIterator() {
        return this.m_alerts.iterator();
    }

    public List getMessages() {
        this.buildMessageStack();
        return this.m_messages;
    }

    public Vector getAlertDatas() {
        return this.m_alerts;
    }

    @Override
    public String getMessage() {
        this.buildMessageStack();
        if (this.m_messages.size() > 0) {
            return ((CWExceptionData)this.m_messages.elementAt(0)).getMessage();
        }
        return null;
    }

    private void buildMessageStack() {
        if (null == this.m_messages) {
            this.m_messages = new Vector();
        } else {
            this.m_messages.removeAllElements();
        }
        for (int i2 = this.m_alerts.size() - 1; i2 >= 0; --i2) {
            this.m_messages.add(((CWAlertData)this.m_alerts.get(i2)).getExceptionData());
        }
    }

    public static final class QuietException
    extends CWException {
        @Override
        public int showAlert(Component parent, String title) {
            return 0;
        }
    }
}

