/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.alert;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.bm.util.ResourcePicker;
import oracle.bm.util.alert.CWExceptionData;
import oracle.javatools.util.BundleLoader;

public class CWAlertData
implements Cloneable {
    private static final String MESSAGE_RESOURCE = "MessageResource";
    private String m_masterFile = "oracle.bm.message.res.Message";
    private ResourcePicker m_rp;
    private String m_packageName;
    private Class m_cls;
    private String m_errorKey;
    private String[] m_paramsMsg;
    private String[] m_paramsCause;
    private String[] m_paramsAction;
    private String m_askOnceKey;
    private String m_msgText;
    private CWExceptionData m_exceptionData;

    public CWAlertData() {
    }

    public CWAlertData(CWExceptionData cwed) {
        this.m_exceptionData = cwed;
    }

    public CWExceptionData getExceptionData() {
        if (this.m_exceptionData == null) {
            this.m_exceptionData = this.createExceptionData();
        }
        return this.m_exceptionData;
    }

    public void setRP(ResourcePicker rp) {
        this.m_rp = rp;
    }

    public void setClass(Class cls) {
        this.m_cls = cls;
    }

    public void setPackageName(String name) {
        this.m_packageName = name;
    }

    public void setMasterFile(String masterFile) {
        this.m_masterFile = masterFile;
    }

    public void setKey(String key) {
        this.m_errorKey = key;
    }

    public void setMsgParams(String[] msg) {
        this.m_paramsMsg = msg;
    }

    public void setCauseParams(String[] cause) {
        this.m_paramsCause = cause;
    }

    public void setActionParams(String[] action) {
        this.m_paramsAction = action;
    }

    public void setErrorMessageText(String text) {
        this.m_msgText = text;
    }

    public void setAskOnceKey(String key) {
        this.m_askOnceKey = key;
    }

    ResourcePicker getRP() {
        return this.m_rp;
    }

    Class getResClass() {
        return this.m_cls;
    }

    String getPackageName() {
        return this.m_packageName;
    }

    public String getKey() {
        return this.m_errorKey;
    }

    public String[] getMsgParams() {
        return this.m_paramsMsg;
    }

    public String[] getCauseParams() {
        return this.m_paramsCause;
    }

    public String[] getActionParams() {
        return this.m_paramsAction;
    }

    public String getErrorMessageText() {
        return this.m_msgText;
    }

    public String getAskOnceKey() {
        return this.m_askOnceKey;
    }

    protected Object clone() {
        try {
            CWAlertData clone = (CWAlertData)super.clone();
            if (null != this.m_paramsMsg) {
                clone.m_paramsMsg = (String[])this.m_paramsMsg.clone();
            }
            if (null != this.m_paramsCause) {
                clone.m_paramsCause = (String[])this.m_paramsCause.clone();
            }
            if (null != this.m_paramsAction) {
                clone.m_paramsAction = (String[])this.m_paramsAction.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private CWExceptionData createExceptionData() {
        String message = this.getErrorMessageText();
        if (message != null) {
            return this.createDefaultExceptionData(message);
        }
        if (null == this.getKey()) {
            return this.createDefaultExceptionData("No key found");
        }
        if (null == this.getRP()) {
            if (null == this.getResClass()) {
                if (null == this.getPackageName()) {
                    return this.createDefaultExceptionData("No resources found");
                }
                this.setRP(new ResourcePicker(this.getPackageName(), MESSAGE_RESOURCE));
            } else {
                this.setRP(new ResourcePicker(this.getResClass(), MESSAGE_RESOURCE));
            }
        }
        return this.createExceptionData(false);
    }

    private CWExceptionData createDefaultExceptionData(String message) {
        CWExceptionData ced = new CWExceptionData();
        ced.setMessage(message);
        ced.setButtons("Ok");
        ced.setType("W");
        return ced;
    }

    private CWExceptionData createExceptionData(boolean failure) {
        String key;
        ResourcePicker rp = this.getRP();
        String message = rp.getStringResource(key = this.getKey(), "message", this.getMsgParams());
        if (message == null) {
            if (failure) {
                return this.createDefaultExceptionData("Couldn't find: " + key + " in " + rp.toString());
            }
            CWAlertData ad = new CWAlertData();
            ad.setRP(new ResourcePicker(CWAlertData.class, MESSAGE_RESOURCE));
            ad.setKey("Default");
            ad.setCauseParams(new String[]{key, rp.toString()});
            return ad.createExceptionData(true);
        }
        CWExceptionData data = new CWExceptionData();
        data.setMessage(message);
        data.setType(rp.getStringResource(key, "type"));
        data.setButtons(rp.getStringResource(key, "button"));
        data.setTitle(rp.getStringResource(key, "title"));
        data.setAskOnceKey(this.m_askOnceKey);
        String code = rp.getStringResource(key, "code");
        if (null != code) {
            try {
                ResourceBundle mastRes = BundleLoader.getBundle((String)this.m_masterFile);
                code = mastRes.getString(code);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            data.setCode(code);
            data.setCause(rp.getStringResource(key, "cause", this.getCauseParams()));
            data.setAction(rp.getStringResource(key, "action", this.getActionParams()));
        }
        return data;
    }
}

