/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.alert;

import java.awt.Component;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import oracle.bm.util.ResourcePicker;
import oracle.bm.util.alert.AskOnceMessagePanel;
import oracle.bm.util.alert.CWAlertData;
import oracle.bm.util.alert.CWAlertUI;
import oracle.bm.util.alert.CWExceptionData;
import oracle.bm.util.alert.CopyableInteger;
import oracle.bm.util.alert.Defs;
import oracle.ide.Ide;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.IdeSettings;
import oracle.ide.dialogs.BaseMessageDialog;
import oracle.ide.util.Assert;
import oracle.javatools.util.Copyable;

public class CWAlert
implements CWAlertUI,
Defs {
    protected CWExceptionData m_exceptionData;
    protected BaseMessageDialog m_messageBox;
    protected AskOnceMessagePanel m_askOncePanel;

    CWAlert(CWExceptionData exceptionData) {
        this.m_exceptionData = exceptionData;
    }

    public CWAlert(ResourcePicker rp, String messageKey, String[] params) {
        CWAlertData data = CWAlert.createAlertData(messageKey, params);
        data.setRP(rp);
        this.m_exceptionData = data.getExceptionData();
    }

    public CWAlert(Class cls, String messageKey, String[] params) {
        CWAlertData data = CWAlert.createAlertData(messageKey, params);
        data.setClass(cls);
        this.m_exceptionData = data.getExceptionData();
    }

    public CWAlert(String packageName, String messageKey, String[] params) {
        CWAlertData data = CWAlert.createAlertData(messageKey, params);
        data.setPackageName(packageName);
        this.m_exceptionData = data.getExceptionData();
    }

    public CWAlert(CWAlertData data) {
        this.m_exceptionData = data.getExceptionData();
    }

    @Override
    public int showAlert(final Component parent) {
        if (this.m_exceptionData.getAskOnceKey() != null) {
            String askOnceKey = this.m_exceptionData.getAskOnceKey();
            IdeSettings ideSettings = Ide.getSettings();
            CopyableInteger i2 = (CopyableInteger)ideSettings.getData(askOnceKey);
            if (i2 != null) {
                return i2.getValue();
            }
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            final int[] result = new int[1];
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        result[0] = CWAlert.this.showAlert(parent);
                    }
                });
                return result[0];
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
                return 0;
            }
        }
        int result = 0;
        try {
            this.buildMessageBox(parent);
            result = this.runMessageBox();
            this.m_messageBox.dispose();
            this.m_messageBox = null;
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        if (this.m_exceptionData.getAskOnceKey() != null && result != 4 && result != 2 && this.m_askOncePanel.isAskOnceChecked()) {
            String askOnceKey = this.m_exceptionData.getAskOnceKey();
            ClientSetting setting = ClientSetting.findOrCreate((String)"oracle.bm");
            setting.putData(askOnceKey, (Copyable)new CopyableInteger(result));
            try {
                setting.save();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    void buildMessageBox(Component parent) {
        int type = this.string2Type(this.m_exceptionData.getButtons(), this.m_exceptionData.getType());
        this.m_messageBox = BaseMessageDialog.createMessageDialog((Component)parent, (String)(this.m_exceptionData.getTitle() != null ? this.m_exceptionData.getTitle() : Ide.getProgramName()), (int)type);
        if (this.m_exceptionData.getAskOnceKey() != null) {
            if (this.m_askOncePanel == null) {
                this.m_askOncePanel = new AskOnceMessagePanel();
            }
            this.m_askOncePanel.setMessageText(this.m_exceptionData.getMessage());
            this.m_messageBox.setMessage((Object)this.m_askOncePanel);
        } else {
            this.m_messageBox.setMessageText(this.m_exceptionData.getMessage());
        }
        if (type == 3) {
            this.m_messageBox.setButtonMask(this.m_messageBox.getButtonMask() | 2);
        }
        this.m_messageBox.setButtonMask(this.m_messageBox.getButtonMask() & 0xFFFFFFFB);
    }

    void addUserButton(String constraintName, JButton userButton) throws IllegalStateException {
        if (null != this.m_messageBox) {
            throw new IllegalStateException("Not implemented as yet");
        }
        throw new IllegalStateException("Message box object not yet constructed");
    }

    int runMessageBox() throws IllegalStateException {
        if (null != this.m_messageBox) {
            int type = this.string2Type(this.m_exceptionData.getButtons(), this.m_exceptionData.getType());
            if (type == 4) {
                return this.m_messageBox.runDialog() ? 1 : 2;
            }
            return this.m_messageBox.runDialog() ? 8 : 4;
        }
        throw new IllegalStateException("Message box object not yet constructed");
    }

    private int string2Type(String buttons, String type) {
        int result = 0;
        if ("AbortRetryIgnore".equals(buttons)) {
            throw new IllegalStateException("We on longer support abort / retry dialogs");
        }
        if ("Ok".equals(buttons)) {
            result = "E".equals(type) ? 1 : 2;
        } else if ("OkCancel".equals(buttons)) {
            result = 3;
        } else {
            if ("RetryCancel".equals(buttons)) {
                throw new IllegalStateException("We on longer support abort / retry dialogs");
            }
            if ("YesNo".equals(buttons)) {
                result = 4;
            } else {
                if ("YesNoCancel".equals(buttons)) {
                    throw new IllegalStateException("We on longer support abort / retry dialogs");
                }
                result = 4;
            }
        }
        return result;
    }

    private static CWAlertData createAlertData(String messageKey, String[] params) {
        CWAlertData alertData = new CWAlertData();
        alertData.setKey(messageKey);
        alertData.setMsgParams(params);
        return alertData;
    }
}

