/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bm.util.CustomComboBoxModel;
import oracle.bm.util.EnumerationStack;
import oracle.bm.util.res.NullResources;
import oracle.bm.util.ui.CompositeToolButton;
import oracle.ide.help.HelpSystem;
import oracle.ide.resource.IdeIcons;
import oracle.javatools.dialogs.DialogHeader;
import oracle.javatools.util.BundleLoader;

public class ResourcePicker
extends ResourceBundle {
    public static final String s_INDIRECTION = "@>";
    private static Method s_handleGetObject;
    private static Field s_parentField;
    private static ResourceBundle[] s_defaultRes;
    private static ResourceBundle[] s_nullRes;
    private static final Map s_pickers;
    protected ResourceBundle[] m_resource;
    protected ResourceBundle[] m_defaultRes;
    protected MessageFormat m_formatter;
    protected Vector m_keyList;
    private Map m_imageCache;

    public ResourcePicker(ResourceBundle resource, ResourceBundle defaultRes) {
        this(resource, defaultRes == null ? s_nullRes : ResourcePicker.getResources(defaultRes));
    }

    public ResourcePicker(ResourceBundle resource) {
        this(resource, s_defaultRes);
    }

    private ResourcePicker(ResourceBundle resource, ResourceBundle[] defaultRes) {
        this.m_resource = ResourcePicker.getResources(resource);
        this.m_defaultRes = defaultRes;
        this.m_formatter = new MessageFormat("DUMMY");
    }

    public ResourcePicker(String kjpackage, String resource) throws MissingResourceException {
        this(BundleLoader.getBundle((String)(kjpackage + ".res." + resource)), s_defaultRes);
    }

    public ResourcePicker(Class clazz) throws MissingResourceException {
        this(BundleLoader.getBundle((String)(clazz.getPackage().getName() + ".res." + "Resource")), s_defaultRes);
    }

    public ResourcePicker(Class clazz, String resource) throws MissingResourceException {
        this(BundleLoader.getBundle((String)(clazz.getPackage().getName() + ".res." + resource)), s_defaultRes);
    }

    public String getString(String key, Object[] replace) {
        String val = this.getString(key);
        return this.formatString(val, replace);
    }

    public String getString(String key, Object singleReplace) {
        return this.getString(key, new Object[]{singleReplace});
    }

    public String formatString(String pattern, Object[] arguments) {
        if (pattern != null) {
            this.m_formatter.applyPattern(pattern);
            StringBuffer result = new StringBuffer();
            return this.m_formatter.format(arguments, result, (FieldPosition)null).toString();
        }
        return "";
    }

    public void start(Container current) {
        StringBuffer resourcePath = new StringBuffer();
        resourcePath.append(current.getName());
        resourcePath.append(".");
        this.dealWithObject(current, resourcePath, 0);
        this.fillSubComponents(current, resourcePath);
    }

    public void fillComponent(Component c) {
        StringBuffer resourcePath;
        String name = c.getName();
        if (name != null) {
            resourcePath = new StringBuffer(c.getName());
            resourcePath.append('.');
        } else {
            resourcePath = new StringBuffer();
        }
        if (!(c instanceof ResourceFree)) {
            this.dealWithObject(c, resourcePath, 0);
        }
        if (c instanceof Container) {
            this.fillSubComponents((Container)c, resourcePath);
        }
    }

    protected void fillSubComponents(Container current, StringBuffer resourcePath) {
        JComponent jmb;
        int i2;
        Component[] items;
        if (current instanceof JTabbedPane) {
            JTabbedPane tp = (JTabbedPane)current;
            items = new Component[tp.getTabCount()];
            for (i2 = 0; i2 < items.length; ++i2) {
                items[i2] = tp.getComponentAt(i2);
            }
        } else if (current instanceof JMenuBar) {
            jmb = (JMenuBar)current;
            items = new Component[((JMenuBar)jmb).getMenuCount()];
            for (i2 = 0; i2 < items.length; ++i2) {
                items[i2] = jmb.getComponent(i2);
            }
        } else if (current instanceof JPopupMenu) {
            jmb = (JPopupMenu)current;
            items = new Component[jmb.getComponentCount()];
            for (i2 = 0; i2 < items.length; ++i2) {
                items[i2] = jmb.getComponent(i2);
            }
        } else {
            items = current instanceof JMenu ? ((JMenu)current).getMenuComponents() : current.getComponents();
        }
        int pathFallback = resourcePath.length();
        for (i2 = 0; i2 < items.length; ++i2) {
            if (items[i2] instanceof ResourceBase) {
                this.fillComponent(items[i2]);
                continue;
            }
            String name = items[i2].getName();
            if (name != null) {
                resourcePath.append(name).append('.');
            }
            if (!(items[i2] instanceof ResourceFree)) {
                this.dealWithObject(items[i2], resourcePath, pathFallback);
            }
            if (items[i2] instanceof Container) {
                this.fillSubComponents((Container)items[i2], resourcePath);
            }
            resourcePath.setLength(pathFallback);
        }
    }

    protected void dealWithObject(Object current, StringBuffer resourcePath, int leafNamePos) {
    }

    protected void dealWithObject(Component current, StringBuffer resourcePath, int leafNamePos) {
        if (current instanceof JComponent) {
            this.dealWithObject((JComponent)current, resourcePath, leafNamePos);
        } else if (current instanceof JDialog) {
            this.dealWithObject((JDialog)current, resourcePath, leafNamePos);
        } else if (current instanceof JFrame) {
            this.dealWithObject((JFrame)current, resourcePath, leafNamePos);
        }
    }

    protected void dealWithObject(JComponent current, StringBuffer resourcePath, int leafNamePos) {
        String helpId;
        String btitle;
        Border bd;
        String tp = this.getStringResource(resourcePath, "tooltip", leafNamePos);
        if (tp != null) {
            current.setToolTipText(tp);
        }
        if ((bd = current.getBorder()) instanceof TitledBorder && (btitle = this.getStringResource(resourcePath, "bordertitle", leafNamePos)) != null) {
            ((TitledBorder)bd).setTitle(btitle);
        }
        if ((helpId = this.getStringResource(resourcePath, "help", leafNamePos)) != null) {
            HelpSystem.getHelpSystem().registerTopic(current, helpId);
        }
        if (current instanceof CompositeToolButton) {
            this.dealWithObject((CompositeToolButton)current, resourcePath, leafNamePos);
        } else if (current instanceof AbstractButton) {
            this.dealWithObject((AbstractButton)current, resourcePath, leafNamePos);
        } else if (current instanceof JTextComponent) {
            this.dealWithObject((JTextComponent)current, resourcePath, leafNamePos);
        } else if (current instanceof JLabel) {
            this.dealWithObject((JLabel)current, resourcePath, leafNamePos);
        } else if (current instanceof JList) {
            this.dealWithObject((JList)current, resourcePath, leafNamePos);
        } else if (current instanceof JComboBox) {
            this.dealWithObject((JComboBox)current, resourcePath, leafNamePos);
        } else if (current instanceof JTable) {
            this.dealWithObject((JTable)current, resourcePath, leafNamePos);
        } else if (current instanceof JInternalFrame) {
            this.dealWithObject((JInternalFrame)current, resourcePath, leafNamePos);
        } else if (current instanceof MultiLineLabel) {
            this.dealWithObject((MultiLineLabel)current, resourcePath, leafNamePos);
        } else if (current instanceof DialogHeader) {
            this.dealWithObject((DialogHeader)current, resourcePath, leafNamePos);
        }
    }

    void dealWithObject(CompositeToolButton current, StringBuffer resourcePath, int leafNamePos) {
        JPopupMenu menu = current.getPopupMenu();
        this.dealWithObject(current.getPopupMenu(), resourcePath, leafNamePos);
    }

    void dealWithObject(AbstractButton current, StringBuffer resourcePath, int leafNamePos) {
        ImageIcon icon;
        String iconName;
        KeyStroke ks;
        String keyStroke;
        String text = this.getStringResource(resourcePath, "text", leafNamePos);
        String mnemonic = this.getStringResource(resourcePath, "mnemonic", leafNamePos);
        if (mnemonic != null) {
            current.setMnemonic(mnemonic.charAt(0));
        }
        if ((keyStroke = this.getStringResource(resourcePath, "key", leafNamePos)) != null && (ks = KeyStroke.getKeyStroke(keyStroke)) != null) {
            if (current instanceof JMenuItem) {
                ((JMenuItem)current).setAccelerator(ks);
            } else {
                final AbstractButton finalButton = current;
                current.registerKeyboardAction(new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        finalButton.doClick();
                    }
                }, keyStroke, ks, 2);
            }
        }
        if ((iconName = this.getStringResource(resourcePath, "image", leafNamePos)) != null && (icon = this.getImageResource(iconName)) != null) {
            current.setIcon(icon);
            if ((text == null || text.length() == 0) && current instanceof JButton) {
                current.setMargin(new Insets(0, 0, 0, 0));
                ((JButton)current).setDefaultCapable(false);
            }
        }
        if (text != null) {
            current.setText(text);
        } else if (!(current.getName() == null || current.getText() != null && current.getText().length() != 0 || current.getIcon() != null && current.getIcon() != IdeIcons.getIcon((int)23))) {
            current.setText("!NLS " + current.getName() + ".text");
        }
    }

    void dealWithObject(JTextComponent current, StringBuffer resourcePath, int leafNamePos) {
        String text = this.getStringResource(resourcePath, "text", leafNamePos);
        if (text != null) {
            current.setText(text);
        }
    }

    void dealWithObject(JLabel current, StringBuffer resourcePath, int leafNamePos) {
        ImageIcon icon;
        String iconName;
        String mnemonic;
        String text = this.getStringResource(resourcePath, "text", leafNamePos);
        if (text != null) {
            current.setText(text);
        }
        if ((mnemonic = this.getStringResource(resourcePath, "mnemonic", leafNamePos)) != null) {
            current.setDisplayedMnemonic(mnemonic.charAt(0));
        }
        if ((iconName = this.getStringResource(resourcePath, "image", leafNamePos)) != null && (icon = this.getImageResource(iconName)) != null) {
            current.setIcon(icon);
        }
    }

    void dealWithObject(JList current, StringBuffer resourcePath, int leafNamePos) {
        ComboBoxModel ccbm = this.getList(resourcePath, leafNamePos);
        if (ccbm != null) {
            current.setModel(ccbm);
        }
    }

    void dealWithObject(JComboBox current, StringBuffer resourcePath, int leafNamePos) {
        ComboBoxModel ccbm = this.getList(resourcePath, leafNamePos);
        if (ccbm != null) {
            current.setModel(ccbm);
        }
    }

    void dealWithObject(JTable current, StringBuffer resourcePath, int leafNamePos) {
        TableColumnModel colm = this.getHeaders(resourcePath, leafNamePos);
        if (colm != null) {
            current.setColumnModel(colm);
        }
    }

    void dealWithObject(JMenuBar current, StringBuffer resourcePath, int leafNamePos) {
        this.fillSubComponents(current, resourcePath);
    }

    void dealWithObject(JPopupMenu current, StringBuffer resourcePath, int leafNamePos) {
        this.fillSubComponents(current, resourcePath);
    }

    void dealWithObject(JFrame current, StringBuffer resourcePath, int leafNamePos) {
        String title = this.getStringResource(resourcePath, "title", leafNamePos);
        if (title != null) {
            current.setTitle(title);
        }
    }

    void dealWithObject(JInternalFrame current, StringBuffer resourcePath, int leafNamePos) {
        String title = this.getStringResource(resourcePath, "title", leafNamePos);
        if (title != null) {
            current.setTitle(title);
        }
    }

    void dealWithObject(JDialog current, StringBuffer resourcePath, int leafNamePos) {
        JMenuBar jmb;
        String title = this.getStringResource(resourcePath, "title", leafNamePos);
        if (title != null) {
            current.setTitle(title);
        }
        if ((jmb = current.getJMenuBar()) != null) {
            resourcePath.append("menubar.");
            this.fillSubComponents(jmb, resourcePath);
        }
    }

    private void dealWithObject(DialogHeader current, StringBuffer resourcePath, int leafNamePos) {
        String description;
        String title = this.getStringResource(resourcePath, "title", leafNamePos);
        if (title != null) {
            current.setHeaderTitle(title);
        }
        if ((description = this.getStringResource(resourcePath, "description", leafNamePos)) != null) {
            current.setHeaderDescription(description);
        }
    }

    void dealWithObject(MultiLineLabel current, StringBuffer resourcePath, int leafNamePos) {
        String title = this.getStringResource(resourcePath, "text", leafNamePos);
        if (title != null) {
            current.setPreferredAspectRatio(8.0f);
            current.setTextWrapper(WordWrapper.getTextWrapper());
            current.setText(title);
        }
    }

    protected ComboBoxModel getList(StringBuffer resourcePath, int leafNamePos) {
        CustomComboBoxModel ccbm = new CustomComboBoxModel();
        int i2 = 0;
        String next = this.getStringResource(resourcePath, new Integer(i2).toString(), leafNamePos);
        while (next != null) {
            ccbm.addElement(next);
            next = this.getStringResource(resourcePath, new Integer(++i2).toString(), leafNamePos);
        }
        if (ccbm.getSize() != 0) {
            return ccbm;
        }
        return null;
    }

    protected TableColumnModel getHeaders(StringBuffer resourcePath, int leafNamePos) {
        DefaultTableColumnModel ccm = new DefaultTableColumnModel();
        int i2 = 0;
        String next = this.getStringResource(resourcePath, new Integer(i2).toString(), leafNamePos);
        while (next != null) {
            TableColumn thisColumn = new TableColumn();
            thisColumn.setHeaderValue(next);
            ccm.addColumn(thisColumn);
            next = this.getStringResource(resourcePath, new Integer(++i2).toString(), leafNamePos);
        }
        if (ccm.getColumnCount() != 0) {
            return ccm;
        }
        return null;
    }

    private String handleGetString(ResourceBundle[] rb, String name) {
        return (String)this.handleGetObject(rb, name);
    }

    private Object handleGetObject(ResourceBundle[] rbs, String name) {
        try {
            ResourceBundle rb;
            for (int i2 = 0; i2 < rbs.length && (rb = rbs[i2]) != null; ++i2) {
                if (rb.getClass() == this.getClass()) {
                    return ((ResourcePicker)rb).handleGetObject(name);
                }
                Object result = s_handleGetObject.invoke((Object)rb, name);
                if (result == null) continue;
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    protected Object handleGetObject(String name) {
        Object next = this.handleGetObject(this.m_resource, name);
        if (next == null) {
            next = this.handleGetObject(this.m_defaultRes, name);
        }
        return next;
    }

    public Enumeration getKeys() {
        if (this.m_keyList == null) {
            EnumerationStack es = new EnumerationStack();
            es.push(this.m_defaultRes[0].getKeys());
            es.push(this.m_resource[0].getKeys());
            this.m_keyList = new Vector();
            EnumerationStack enm = es;
            while (enm.hasMoreElements()) {
                Object next = enm.nextElement();
                if (this.m_keyList.contains(next)) continue;
                this.m_keyList.addElement(next);
            }
        }
        return this.m_keyList.elements();
    }

    private String redirectIfRequired(String result) {
        if (result == null) {
            return null;
        }
        try {
            if (result.startsWith(s_INDIRECTION)) {
                String subString = result.substring(2, result.length());
                return (String)this.handleGetObject(subString);
            }
        }
        catch (StackOverflowError soe) {
            soe.printStackTrace();
            return result;
        }
        return result;
    }

    public String getStringResource(String name, String type, Object[] subst) {
        return this.formatString(this.getStringResource(name, type), subst);
    }

    public String getStringResource(String name, String type) {
        StringBuffer sb = new StringBuffer(name);
        String longName = sb.append('.').append(type).toString();
        String string = this.redirectIfRequired(this.handleGetString(this.m_resource, longName));
        if (string == null) {
            string = this.redirectIfRequired(this.handleGetString(this.m_defaultRes, longName));
        }
        return string;
    }

    public String getStringResource(String name, StringBuffer longName, String type) {
        int leafNamePos = longName.length() - name.length();
        return this.getStringResource(longName.append('.').append(type), "", leafNamePos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStringResource(StringBuffer resourcePath, String type, int leafNamePos) {
        String string;
        int pathFallback = resourcePath.length();
        String longName = resourcePath.append(type).toString();
        try {
            string = this.redirectIfRequired(this.handleGetString(this.m_resource, longName));
            if (string == null) {
                if (leafNamePos <= 0) {
                    String string2 = this.redirectIfRequired(this.handleGetString(this.m_defaultRes, longName));
                    return string2;
                }
                String shortName = longName.substring(leafNamePos);
                string = this.redirectIfRequired(this.handleGetString(this.m_defaultRes, shortName));
                if (string == null && (string = this.redirectIfRequired(this.handleGetString(this.m_resource, shortName))) == null) {
                    string = this.redirectIfRequired(this.handleGetString(this.m_defaultRes, longName));
                }
            }
        }
        finally {
            resourcePath.setLength(pathFallback);
        }
        return string;
    }

    public String getStringResource(String name) {
        return this.redirectIfRequired((String)this.handleGetObject(name));
    }

    public Icon getImage(String key) {
        return this.getImageResource(this.getString(key));
    }

    public ImageIcon getImageResource(String iconName) {
        if (iconName == null || iconName == "") {
            return null;
        }
        ImageIcon result = this.getCachedImage(iconName);
        if (result == null) {
            result = this.loadImageResourceFromPicker(this.m_resource, iconName);
            if (result != null) {
                return result;
            }
            if (this.m_defaultRes[0] instanceof ResourcePicker) {
                return ((ResourcePicker)this.m_defaultRes[0]).getImageResource(iconName);
            }
            result = this.loadImageResourceFromPicker(this.m_defaultRes, iconName);
            if (result != null) {
                return result;
            }
            return null;
        }
        return result;
    }

    private ImageIcon loadImageResourceFromPicker(ResourceBundle[] rb, String iconName) {
        ImageIcon result;
        URL url = rb[0].getClass().getResource(iconName);
        if (url != null && (result = this.loadImageFromURL(url)) != null) {
            this.cacheImage(iconName, result);
            return result;
        }
        return null;
    }

    private ImageIcon loadImageFromURL(URL u) {
        ImageIcon i2;
        if (u != null && ((i2 = new ImageIcon(u)).getImageLoadStatus() & 9) > 0) {
            return i2;
        }
        return null;
    }

    private ImageIcon getCachedImage(String iconName) {
        if (this.m_imageCache == null) {
            return null;
        }
        return (ImageIcon)this.m_imageCache.get(iconName);
    }

    private void cacheImage(String iconName, ImageIcon icon) {
        if (this.m_imageCache == null) {
            this.m_imageCache = new HashMap();
        }
        this.m_imageCache.put(iconName, icon);
    }

    public static final ResourcePicker getPicker(Object o) {
        return ResourcePicker.getPicker(o.getClass());
    }

    public static final ResourcePicker getPicker(Class c) {
        String pkg = c.getPackage().getName();
        ResourcePicker rp = (ResourcePicker)s_pickers.get(pkg);
        if (rp != null) {
            return rp;
        }
        rp = new ResourcePicker(c);
        s_pickers.put(pkg, rp);
        return rp;
    }

    public static final ResourcePicker get() {
        StackTraceElement[] stack = new Throwable().getStackTrace();
        try {
            Class<?> c = Class.forName(stack[1].getClassName());
            return ResourcePicker.getPicker(c);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static final ResourceBundle[] getResources(ResourceBundle rb) {
        ResourceBundle[] resources = new ResourceBundle[4];
        for (int i2 = 0; i2 < 4 && rb != null; ++i2) {
            resources[i2] = rb;
            try {
                rb = (ResourceBundle)s_parentField.get(rb);
                continue;
            }
            catch (IllegalArgumentException iae) {
                break;
            }
            catch (IllegalAccessException iae) {
                break;
            }
        }
        return resources;
    }

    static {
        s_pickers = new HashMap();
        try {
            s_handleGetObject = ResourceBundle.class.getDeclaredMethod("handleGetObject", String.class);
            s_handleGetObject.setAccessible(true);
            s_parentField = ResourceBundle.class.getDeclaredField("parent");
            s_parentField.setAccessible(true);
            s_defaultRes = ResourcePicker.getResources(BundleLoader.getBundle((String)"oracle.bm.util.res.DefaultResource"));
            s_nullRes = new ResourceBundle[]{new NullResources()};
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static interface ResourceFree {
    }

    public static interface ResourceBase {
    }
}

