/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class MultiValuedMap
implements Map {
    private final Map m_impl;
    private static final Collection m_empty = Collections.unmodifiableCollection(new ArrayList());

    public MultiValuedMap() {
        this(new HashMap());
    }

    public MultiValuedMap(int initialCapacity) {
        this(new HashMap(initialCapacity));
    }

    public MultiValuedMap(Map implementation) {
        if (implementation == null) {
            throw new IllegalArgumentException("implementation must not be null");
        }
        this.m_impl = implementation;
        this.m_impl.clear();
    }

    @Override
    public void clear() {
        Collection values = this.m_impl.values();
        Collection[] arrValues = values.toArray(new Collection[values.size()]);
        for (int i2 = 0; i2 < arrValues.length; ++i2) {
            arrValues[i2].clear();
        }
        this.m_impl.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.m_impl.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        Collection values = this.m_impl.values();
        Iterator i2 = values.iterator();
        while (i2.hasNext()) {
            if (!((Collection)i2.next()).contains(value)) continue;
            return true;
        }
        return false;
    }

    public Set entrySet() {
        HashSet<MyMapEntry> s = new HashSet<MyMapEntry>();
        for (Object key : this.m_impl.keySet()) {
            Collection c = (Collection)this.m_impl.get(key);
            if (c == null) continue;
            for (Object value : c) {
                s.add(new MyMapEntry(key, value));
            }
        }
        return Collections.unmodifiableSet(s);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof MultiValuedMap) {
            return ((Object)this.entrySet()).equals(((MultiValuedMap)o).entrySet());
        }
        return false;
    }

    public Object get(Object key) {
        Collection c = (Collection)this.m_impl.get(key);
        if (c == null || c.size() == 0) {
            return null;
        }
        Iterator i2 = c.iterator();
        return i2.next();
    }

    @Override
    public int hashCode() {
        return ((Object)this.m_impl).hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.m_impl.isEmpty();
    }

    public Set keySet() {
        return this.m_impl.keySet();
    }

    public Object put(Object key, Object value) {
        Collection c = (Collection)this.m_impl.get(key);
        if (c == null) {
            c = this.createCollection();
            this.m_impl.put(key, c);
        }
        if (!c.contains(value)) {
            c.add(value);
        }
        return value;
    }

    public void putAll(Map t) {
        Set s = t.entrySet();
        for (Map.Entry entry : s) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object key) {
        Object o = this.get(key);
        this.m_impl.remove(key);
        return o;
    }

    @Override
    public int size() {
        return this.m_impl.size();
    }

    public Collection values() {
        ArrayList contents = new ArrayList();
        Collection values = this.m_impl.values();
        Iterator i2 = values.iterator();
        while (i2.hasNext()) {
            contents.addAll((Collection)i2.next());
        }
        return contents;
    }

    public Iterator valueIterator(Object key) {
        return this._values(key).iterator();
    }

    public Iterator valueIterator(Object key, Comparator c) {
        ArrayList l = new ArrayList(this._values(key));
        Collections.sort(l, c);
        return l.iterator();
    }

    public Enumeration valueEnumeration(Object key) {
        return new ArrayEnumerator(this._values(key).toArray());
    }

    public Collection values(Object key) {
        return Collections.unmodifiableCollection(this._values(key));
    }

    protected Collection _values(Object key) {
        Collection c = (Collection)this.m_impl.get(key);
        if (c != null) {
            return c;
        }
        return m_empty;
    }

    public Enumeration keyEnumeration() {
        return new ArrayEnumerator(this.m_impl.keySet().toArray());
    }

    public Enumeration elementEnumeration() {
        return new ArrayEnumerator(this.values().toArray());
    }

    public int count(Object key) {
        Collection c = (Collection)this.m_impl.get(key);
        if (c != null) {
            return c.size();
        }
        return 0;
    }

    public Object remove(Object key, Object value) {
        Collection c = (Collection)this.m_impl.get(key);
        if (c == null) {
            return null;
        }
        boolean status = c.remove(value);
        if (status) {
            if (c.isEmpty()) {
                this.m_impl.remove(key);
            }
            return value;
        }
        return null;
    }

    protected Collection createCollection() {
        return new ArrayList();
    }

    public static void main(String[] args) {
        MultiValuedMap m = new MultiValuedMap();
        m.put("foo", "1");
        m.put("bar", "1");
        m.put("foo", "1");
        m.put("foo", "2");
        m.dump();
        m.dumpEntries("foo");
        m.dumpEntries("boo");
        m.remove("foo", "1");
        m.dump();
        m.remove("bar");
        m.dump();
    }

    protected final void dumpEntries(Object key) {
        System.out.println("dumping entries for " + key + "...");
        Iterator i2 = this.valueIterator(key);
        while (i2.hasNext()) {
            System.out.println(i2.next());
        }
        System.out.println("");
    }

    protected final void dump() {
        System.out.println("dumping...");
        for (Map.Entry e : this.entrySet()) {
            System.out.println(e.getKey() + ", " + e.getValue());
        }
        System.out.println("");
    }

    protected static final class ArrayEnumerator
    implements Enumeration {
        private final Object[] m_values;
        private int m_counter = 0;

        protected ArrayEnumerator(Object[] content) {
            this.m_values = content;
        }

        @Override
        public boolean hasMoreElements() {
            return this.m_counter < this.m_values.length;
        }

        public Object nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            return this.m_values[this.m_counter++];
        }
    }

    protected static class MyMapEntry
    implements Map.Entry {
        private final Object m_key;
        private final Object m_value;

        protected MyMapEntry(Object key, Object value) {
            this.m_key = key;
            this.m_value = value;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry other = (Map.Entry)o;
                return this.areEqual(this.getKey(), other.getKey()) && this.areEqual(this.getValue(), other.getValue());
            }
            return false;
        }

        public Object getKey() {
            return this.m_key;
        }

        public Object getValue() {
            return this.m_value;
        }

        @Override
        public int hashCode() {
            return this.m_key.hashCode();
        }

        public Object setValue(Object value) {
            throw new IllegalStateException("setValue() not permitted on MultiValuedMap Map.Entry");
        }

        protected boolean areEqual(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return true;
            }
            if (o1 != null && o2 != null) {
                return o1.equals(o2);
            }
            return false;
        }
    }
}

