/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util;

public class History {
    private int _max;
    private int _currentHead;
    private int _size;
    private boolean _strict;
    private Object[] _history;

    public History(int maxElts) {
        this._max = maxElts;
        this._history = new Object[this._max];
    }

    public History(int maxElts, boolean strict) {
        this._max = maxElts;
        this._strict = strict;
        this._history = new Object[this._max];
    }

    public void add(Object o) {
        this._history[this._currentHead] = o;
        if (this._currentHead == this._max - 1) {
            if (this._strict) {
                // empty if block
            }
            this._currentHead = 0;
        } else {
            ++this._currentHead;
        }
        if (this._size < this._max) {
            ++this._size;
        }
    }

    public Object remove() {
        Object obj = this.get(0);
        this._currentHead = this._currentHead == 0 ? this._max - 1 : --this._currentHead;
        --this._size;
        return obj;
    }

    public Object get(int index) {
        int ind = this._currentHead - index - 1;
        if (ind < 0) {
            ind = this._max + ind;
        }
        return this._history[ind];
    }

    public int size() {
        return this._size;
    }

    public int max() {
        return this._max;
    }

    public boolean isEmpty() {
        return this._size == 0;
    }

    public boolean isFull() {
        return this._size == this._max;
    }
}

